package org.jboss.hal.client.runtime.group;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.typeahead.Typeahead;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.IdBuilder;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_ServerGroupView extends ServerGroupView {

    private final Metadata metadata13;
    private final Metadata metadata12;
    private final Metadata metadata14;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_ServerGroupView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata13Template = AddressTemplate.of("/{selected.group}/jvm=*");
        this.metadata13 = mbuiContext.metadataRegistry().lookup(metadata13Template);
        AddressTemplate metadata12Template = AddressTemplate.of("/{selected.group}");
        this.metadata12 = mbuiContext.metadataRegistry().lookup(metadata12Template);
        AddressTemplate metadata14Template = AddressTemplate.of("/{selected.group}/system-property=*");
        this.metadata14 = mbuiContext.metadataRegistry().lookup(metadata14Template);
        this.handlebarElements = new HashMap<>();

        serverGroupConfigurationForm = new ModelNodeForm.Builder<org.jboss.hal.core.runtime.group.ServerGroup>("server-group-configuration-form", metadata12)
            .includeRuntime()
            .include("profile", "socket-binding-group", "socket-binding-port-offset", "socket-binding-default-interface", "management-subsystem-endpoint")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm(changedValues, metadata12Template.resolve(mbuiContext.statementContext()), "Server Group Configuration"))
            .build();
        serverGroupJvmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("server-group-jvm-form", metadata13)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata13Template.resolve(mbuiContext.statementContext(), name),
                    "Jvm", name);
            })
            .build();
        serverGroupSystemPropertyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("server-group-system-property-form", metadata14)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata14Template.resolve(mbuiContext.statementContext(), name),
                    "System Property", name);
            })
            .build();

        Options<org.jboss.hal.dmr.model.NamedNode> serverGroupJvmTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata13)
            .button(mbuiContext.tableButtonFactory().add(IdBuilder.build("server-group-jvm-table", "add"), "Jvm",
                metadata13Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Jvm", metadata13Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        serverGroupJvmTable = new ModelNodeTable<>("server-group-jvm-table", serverGroupJvmTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> serverGroupSystemPropertyTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata14)
            .button(mbuiContext.tableButtonFactory().add(IdBuilder.build("server-group-system-property-table", "add"), "System Property",
                metadata14Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("System Property", metadata14Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("value")
            .build();
        serverGroupSystemPropertyTable = new ModelNodeTable<>("server-group-system-property-table", serverGroupSystemPropertyTableOptions);

        registerAttachable(serverGroupConfigurationForm);
        registerAttachable(serverGroupJvmTable);
        registerAttachable(serverGroupJvmForm);
        registerAttachable(serverGroupSystemPropertyTable);
        registerAttachable(serverGroupSystemPropertyForm);

        navigation = new VerticalNavigation();
        Elements.Builder serverGroupConfigurationItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Server Group Configuration</h1><p>{{metadata12.getDescription().getDescription()}}</p>"))
                    .rememberAs("html35")
                .end()
                .add(serverGroupConfigurationForm)
            .end();
        Element serverGroupConfigurationItemElement = serverGroupConfigurationItemBuilder.build();
        handlebarElements.put("html35", serverGroupConfigurationItemBuilder.referenceFor("html35"));
        navigation.addPrimary("server-group-configuration-item", "Configuration", "pficon pficon-cluster", serverGroupConfigurationItemElement);
        Elements.Builder serverGroupJvmItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JVMs</h1><p>{{metadata13.getDescription().getDescription()}}</p>"))
                    .rememberAs("html37")
                .end()
                .add(serverGroupJvmTable)
                .add(serverGroupJvmForm)
            .end();
        Element serverGroupJvmItemElement = serverGroupJvmItemBuilder.build();
        handlebarElements.put("html37", serverGroupJvmItemBuilder.referenceFor("html37"));
        navigation.addPrimary("server-group-jvm-item", "JVMs", "fa fa-coffee", serverGroupJvmItemElement);
        Elements.Builder serverGroupSystemPropertyItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>System Properties</h1><p>{{metadata14.getDescription().getDescription()}}</p>"))
                    .rememberAs("html40")
                .end()
                .add(serverGroupSystemPropertyTable)
                .add(serverGroupSystemPropertyForm)
            .end();
        Element serverGroupSystemPropertyItemElement = serverGroupSystemPropertyItemBuilder.build();
        handlebarElements.put("html40", serverGroupSystemPropertyItemBuilder.referenceFor("html40"));
        navigation.addPrimary("server-group-system-property-item", "System Properties", "fa fa-list-ul", serverGroupSystemPropertyItemElement);

        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

        serverGroupJvmTable.api().bindForm(serverGroupJvmForm);
        serverGroupSystemPropertyTable.api().bindForm(serverGroupSystemPropertyForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html35"), "{{metadata12.getDescription().getDescription()}}", String.valueOf(metadata12.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html37"), "{{metadata13.getDescription().getDescription()}}", String.valueOf(metadata13.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html40"), "{{metadata14.getDescription().getDescription()}}", String.valueOf(metadata14.getDescription().getDescription()));
    }
}
