package org.jboss.hal.client.runtime.host;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.typeahead.Typeahead;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.IdBuilder;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_HostView extends HostView {

    private final Metadata metadata39;
    private final Metadata metadata43;
    private final Metadata metadata41;
    private final Metadata metadata42;
    private final Metadata metadata40;
    private final Metadata metadata44;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_HostView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata39Template = AddressTemplate.of("/{selected.host}");
        this.metadata39 = mbuiContext.metadataRegistry().lookup(metadata39Template);
        AddressTemplate metadata43Template = AddressTemplate.of("/{selected.host}/socket-binding-group=*");
        this.metadata43 = mbuiContext.metadataRegistry().lookup(metadata43Template);
        AddressTemplate metadata41Template = AddressTemplate.of("/{selected.host}/jvm=*");
        this.metadata41 = mbuiContext.metadataRegistry().lookup(metadata41Template);
        AddressTemplate metadata42Template = AddressTemplate.of("/{selected.host}/path=*");
        this.metadata42 = mbuiContext.metadataRegistry().lookup(metadata42Template);
        AddressTemplate metadata40Template = AddressTemplate.of("/{selected.host}/interface=*");
        this.metadata40 = mbuiContext.metadataRegistry().lookup(metadata40Template);
        AddressTemplate metadata44Template = AddressTemplate.of("/{selected.host}/system-property=*");
        this.metadata44 = mbuiContext.metadataRegistry().lookup(metadata44Template);
        this.handlebarElements = new HashMap<>();

        hostConfigurationForm = new ModelNodeForm.Builder<org.jboss.hal.core.runtime.host.Host>("host-configuration-form", metadata39)
            .includeRuntime()
            .include("name", "organization", "directory-grouping", "uuid", "release-codename", "release-version", "product-name", "product-version", "management-major-version", "management-minor-version", "management-micro-version", "running-mode", "host-state", "suspend-state")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveHost(form, changedValues))
            .build();
        hostInterfaceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("host-interface-form", metadata40)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata40Template.resolve(mbuiContext.statementContext(), name),
                    "Interface", name);
            })
            .build();
        hostJvmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("host-jvm-form", metadata41)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata41Template.resolve(mbuiContext.statementContext(), name),
                    "Jvm", name);
            })
            .build();
        hostPathForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("host-path-form", metadata42)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata42Template.resolve(mbuiContext.statementContext(), name),
                    "Path", name);
            })
            .build();
        hostSocketBindingGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("host-socket-binding-group-form", metadata43)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata43Template.resolve(mbuiContext.statementContext(), name),
                    "Socket Binding Group", name);
            })
            .build();
        hostSystemPropertyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("host-system-property-form", metadata44)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata44Template.resolve(mbuiContext.statementContext(), name),
                    "System Property", name);
            })
            .build();

        Options<org.jboss.hal.dmr.model.NamedNode> hostInterfaceTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata40)
            .button(mbuiContext.tableButtonFactory().add(IdBuilder.build("host-interface-table", "add"), "Interface",
                metadata40Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Interface", metadata40Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        hostInterfaceTable = new ModelNodeTable<>("host-interface-table", hostInterfaceTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> hostJvmTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata41)
            .button(mbuiContext.tableButtonFactory().add(IdBuilder.build("host-jvm-table", "add"), "Jvm",
                metadata41Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Jvm", metadata41Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        hostJvmTable = new ModelNodeTable<>("host-jvm-table", hostJvmTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> hostPathTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata42)
            .button(mbuiContext.tableButtonFactory().add(IdBuilder.build("host-path-table", "add"), "Path",
                metadata42Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Path", metadata42Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "path")
            .build();
        hostPathTable = new ModelNodeTable<>("host-path-table", hostPathTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> hostSocketBindingGroupTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata43)
            .button(mbuiContext.tableButtonFactory().add(IdBuilder.build("host-socket-binding-group-table", "add"), "Socket Binding Group",
                metadata43Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Socket Binding Group", metadata43Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        hostSocketBindingGroupTable = new ModelNodeTable<>("host-socket-binding-group-table", hostSocketBindingGroupTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> hostSystemPropertyTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata44)
            .button(mbuiContext.tableButtonFactory().add(IdBuilder.build("host-system-property-table", "add"), "System Property",
                metadata44Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("System Property", metadata44Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("value")
            .build();
        hostSystemPropertyTable = new ModelNodeTable<>("host-system-property-table", hostSystemPropertyTableOptions);

        registerAttachable(hostConfigurationForm);
        registerAttachable(hostInterfaceTable);
        registerAttachable(hostInterfaceForm);
        registerAttachable(hostJvmTable);
        registerAttachable(hostJvmForm);
        registerAttachable(hostPathTable);
        registerAttachable(hostPathForm);
        registerAttachable(hostSocketBindingGroupTable);
        registerAttachable(hostSocketBindingGroupForm);
        registerAttachable(hostSystemPropertyTable);
        registerAttachable(hostSystemPropertyForm);

        navigation = new VerticalNavigation();
        Elements.Builder hostConfigurationItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1 id=\"host-configuration-title\" /><p>{{metadata39.getDescription().getDescription()}}</p>"))
                    .rememberAs("html110")
                .end()
                .add(hostConfigurationForm)
            .end();
        Element hostConfigurationItemElement = hostConfigurationItemBuilder.build();
        handlebarElements.put("html110", hostConfigurationItemBuilder.referenceFor("html110"));
        navigation.addPrimary("host-configuration-item", "Configuration", "pficon pficon-cluster", hostConfigurationItemElement);
        Elements.Builder hostInterfaceItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Interfaces</h1><p>{{metadata40.getDescription().getDescription()}}</p>"))
                    .rememberAs("html112")
                .end()
                .add(hostInterfaceTable)
                .add(hostInterfaceForm)
            .end();
        Element hostInterfaceItemElement = hostInterfaceItemBuilder.build();
        handlebarElements.put("html112", hostInterfaceItemBuilder.referenceFor("html112"));
        navigation.addPrimary("host-interface-item", "Interfaces", "fa fa-exchange", hostInterfaceItemElement);
        Elements.Builder hostJvmItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JVMs</h1><p>{{metadata41.getDescription().getDescription()}}</p>"))
                    .rememberAs("html115")
                .end()
                .add(hostJvmTable)
                .add(hostJvmForm)
            .end();
        Element hostJvmItemElement = hostJvmItemBuilder.build();
        handlebarElements.put("html115", hostJvmItemBuilder.referenceFor("html115"));
        navigation.addPrimary("host-jvm-item", "JVMs", "fa fa-coffee", hostJvmItemElement);
        Elements.Builder hostPathItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Paths</h1><p>{{metadata42.getDescription().getDescription()}}</p>"))
                    .rememberAs("html118")
                .end()
                .add(hostPathTable)
                .add(hostPathForm)
            .end();
        Element hostPathItemElement = hostPathItemBuilder.build();
        handlebarElements.put("html118", hostPathItemBuilder.referenceFor("html118"));
        navigation.addPrimary("host-path-item", "Paths", "fa fa-folder-open", hostPathItemElement);
        Elements.Builder hostSocketBindingGroupItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Socket Binding Groups</h1><p>{{metadata43.getDescription().getDescription()}}</p>"))
                    .rememberAs("html121")
                .end()
                .add(hostSocketBindingGroupTable)
                .add(hostSocketBindingGroupForm)
            .end();
        Element hostSocketBindingGroupItemElement = hostSocketBindingGroupItemBuilder.build();
        handlebarElements.put("html121", hostSocketBindingGroupItemBuilder.referenceFor("html121"));
        navigation.addPrimary("host-socket-binding-group-item", "Socket Binding Groups", "fa fa-object-group", hostSocketBindingGroupItemElement);
        Elements.Builder hostSystemPropertyItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>System Properties</h1><p>{{metadata44.getDescription().getDescription()}}</p>"))
                    .rememberAs("html124")
                .end()
                .add(hostSystemPropertyTable)
                .add(hostSystemPropertyForm)
            .end();
        Element hostSystemPropertyItemElement = hostSystemPropertyItemBuilder.build();
        handlebarElements.put("html124", hostSystemPropertyItemBuilder.referenceFor("html124"));
        navigation.addPrimary("host-system-property-item", "System Properties", "fa fa-list-ul", hostSystemPropertyItemElement);

        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

        hostInterfaceTable.api().bindForm(hostInterfaceForm);
        hostJvmTable.api().bindForm(hostJvmForm);
        hostPathTable.api().bindForm(hostPathForm);
        hostSocketBindingGroupTable.api().bindForm(hostSocketBindingGroupForm);
        hostSystemPropertyTable.api().bindForm(hostSystemPropertyForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html110"), "{{metadata39.getDescription().getDescription()}}", String.valueOf(metadata39.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html112"), "{{metadata40.getDescription().getDescription()}}", String.valueOf(metadata40.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html115"), "{{metadata41.getDescription().getDescription()}}", String.valueOf(metadata41.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html118"), "{{metadata42.getDescription().getDescription()}}", String.valueOf(metadata42.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html121"), "{{metadata43.getDescription().getDescription()}}", String.valueOf(metadata43.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html124"), "{{metadata44.getDescription().getDescription()}}", String.valueOf(metadata44.getDescription().getDescription()));
    }
}
