package org.jboss.hal.client.runtime.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.typeahead.Typeahead;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.IdBuilder;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_ServerView extends ServerView {

    private final Metadata metadata22;
    private final Metadata metadata18;
    private final Metadata metadata21;
    private final Metadata metadata20;
    private final Metadata metadata19;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_ServerView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata22Template = AddressTemplate.of("/{selected.host}/{selected.server}/system-property=*");
        this.metadata22 = mbuiContext.metadataRegistry().lookup(metadata22Template);
        AddressTemplate metadata18Template = AddressTemplate.of("/{selected.host}/{selected.server}");
        this.metadata18 = mbuiContext.metadataRegistry().lookup(metadata18Template);
        AddressTemplate metadata21Template = AddressTemplate.of("/{selected.host}/{selected.server}/path=*");
        this.metadata21 = mbuiContext.metadataRegistry().lookup(metadata21Template);
        AddressTemplate metadata20Template = AddressTemplate.of("/{selected.host}/{selected.server}/jvm=*");
        this.metadata20 = mbuiContext.metadataRegistry().lookup(metadata20Template);
        AddressTemplate metadata19Template = AddressTemplate.of("/{selected.host}/{selected.server}/interface=*");
        this.metadata19 = mbuiContext.metadataRegistry().lookup(metadata19Template);
        this.handlebarElements = new HashMap<>();

        serverConfigurationForm = new ModelNodeForm.Builder<org.jboss.hal.core.runtime.server.Server>("server-configuration-form", metadata18)
            .includeRuntime()
            .include("name", "group", "auto-start", "update-auto-start-with-server-status", "socket-binding-group", "socket-binding-port-offset", "socket-binding-default-interface", "status")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm(changedValues, metadata18Template.resolve(mbuiContext.statementContext()), "Server Configuration"))
            .build();
        serverInterfaceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("server-interface-form", metadata19)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata19Template.resolve(mbuiContext.statementContext(), name),
                    "Interface", name);
            })
            .build();
        serverJvmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("server-jvm-form", metadata20)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata20Template.resolve(mbuiContext.statementContext(), name),
                    "Jvm", name);
            })
            .build();
        serverPathForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("server-path-form", metadata21)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata21Template.resolve(mbuiContext.statementContext(), name),
                    "Path", name);
            })
            .build();
        serverSystemPropertyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("server-system-property-form", metadata22)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata22Template.resolve(mbuiContext.statementContext(), name),
                    "System Property", name);
            })
            .build();

        Options<org.jboss.hal.dmr.model.NamedNode> serverInterfaceTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata19)
            .button(mbuiContext.tableButtonFactory().add(IdBuilder.build("server-interface-table", "add"), "Interface",
                metadata19Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Interface", metadata19Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        serverInterfaceTable = new ModelNodeTable<>("server-interface-table", serverInterfaceTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> serverJvmTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata20)
            .button(mbuiContext.tableButtonFactory().add(IdBuilder.build("server-jvm-table", "add"), "Jvm",
                metadata20Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Jvm", metadata20Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        serverJvmTable = new ModelNodeTable<>("server-jvm-table", serverJvmTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> serverPathTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata21)
            .button(mbuiContext.tableButtonFactory().add(IdBuilder.build("server-path-table", "add"), "Path",
                metadata21Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Path", metadata21Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "path")
            .build();
        serverPathTable = new ModelNodeTable<>("server-path-table", serverPathTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> serverSystemPropertyTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata22)
            .button(mbuiContext.tableButtonFactory().add(IdBuilder.build("server-system-property-table", "add"), "System Property",
                metadata22Template,
                () -> presenter.reload(),
                "value"))
            .button(mbuiContext.tableButtonFactory().remove("System Property", metadata22Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("value")
            .build();
        serverSystemPropertyTable = new ModelNodeTable<>("server-system-property-table", serverSystemPropertyTableOptions);

        registerAttachable(serverConfigurationForm);
        registerAttachable(serverInterfaceTable);
        registerAttachable(serverInterfaceForm);
        registerAttachable(serverJvmTable);
        registerAttachable(serverJvmForm);
        registerAttachable(serverPathTable);
        registerAttachable(serverPathForm);
        registerAttachable(serverSystemPropertyTable);
        registerAttachable(serverSystemPropertyForm);

        navigation = new VerticalNavigation();
        Elements.Builder serverConfigurationItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Server Configuration</h1><p>{{metadata18.getDescription().getDescription()}}</p>"))
                    .rememberAs("html51")
                .end()
                .add(serverConfigurationForm)
            .end();
        Element serverConfigurationItemElement = serverConfigurationItemBuilder.build();
        handlebarElements.put("html51", serverConfigurationItemBuilder.referenceFor("html51"));
        navigation.addPrimary("server-configuration-item", "Configuration", "pficon pficon-cluster", serverConfigurationItemElement);
        Elements.Builder serverInterfaceItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Interfaces</h1><p>{{metadata19.getDescription().getDescription()}}</p>"))
                    .rememberAs("html53")
                .end()
                .add(serverInterfaceTable)
                .add(serverInterfaceForm)
            .end();
        Element serverInterfaceItemElement = serverInterfaceItemBuilder.build();
        handlebarElements.put("html53", serverInterfaceItemBuilder.referenceFor("html53"));
        navigation.addPrimary("server-interface-item", "Interfaces", "fa fa-exchange", serverInterfaceItemElement);
        Elements.Builder serverJvmItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JVMs</h1><p>{{metadata20.getDescription().getDescription()}}</p>"))
                    .rememberAs("html56")
                .end()
                .add(serverJvmTable)
                .add(serverJvmForm)
            .end();
        Element serverJvmItemElement = serverJvmItemBuilder.build();
        handlebarElements.put("html56", serverJvmItemBuilder.referenceFor("html56"));
        navigation.addPrimary("server-jvm-item", "JVMs", "fa fa-coffee", serverJvmItemElement);
        Elements.Builder serverPathItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Paths</h1><p>{{metadata21.getDescription().getDescription()}}</p>"))
                    .rememberAs("html59")
                .end()
                .add(serverPathTable)
                .add(serverPathForm)
            .end();
        Element serverPathItemElement = serverPathItemBuilder.build();
        handlebarElements.put("html59", serverPathItemBuilder.referenceFor("html59"));
        navigation.addPrimary("server-path-item", "Paths", "fa fa-folder-open", serverPathItemElement);
        Elements.Builder serverSystemPropertyItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>System Properties</h1><p>{{metadata22.getDescription().getDescription()}}</p>"))
                    .rememberAs("html62")
                .end()
                .add(serverSystemPropertyTable)
                .add(serverSystemPropertyForm)
            .end();
        Element serverSystemPropertyItemElement = serverSystemPropertyItemBuilder.build();
        handlebarElements.put("html62", serverSystemPropertyItemBuilder.referenceFor("html62"));
        navigation.addPrimary("server-system-property-item", "System Properties", "fa fa-list-ul", serverSystemPropertyItemElement);

        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

        serverInterfaceTable.api().bindForm(serverInterfaceForm);
        serverJvmTable.api().bindForm(serverJvmForm);
        serverPathTable.api().bindForm(serverPathForm);
        serverSystemPropertyTable.api().bindForm(serverSystemPropertyForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html51"), "{{metadata18.getDescription().getDescription()}}", String.valueOf(metadata18.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html53"), "{{metadata19.getDescription().getDescription()}}", String.valueOf(metadata19.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html56"), "{{metadata20.getDescription().getDescription()}}", String.valueOf(metadata20.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html59"), "{{metadata21.getDescription().getDescription()}}", String.valueOf(metadata21.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html62"), "{{metadata22.getDescription().getDescription()}}", String.valueOf(metadata22.getDescription().getDescription()));
    }
}
