package org.jboss.hal.client.runtime.host;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.typeahead.Typeahead;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.IdBuilder;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_HostView extends HostView {

    private final Metadata metadata35;
    private final Metadata metadata39;
    private final Metadata metadata37;
    private final Metadata metadata38;
    private final Metadata metadata36;
    private final Metadata metadata40;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_HostView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata35Template = AddressTemplate.of("/{selected.host}");
        this.metadata35 = mbuiContext.metadataRegistry().lookup(metadata35Template);
        AddressTemplate metadata39Template = AddressTemplate.of("/{selected.host}/socket-binding-group=*");
        this.metadata39 = mbuiContext.metadataRegistry().lookup(metadata39Template);
        AddressTemplate metadata37Template = AddressTemplate.of("/{selected.host}/jvm=*");
        this.metadata37 = mbuiContext.metadataRegistry().lookup(metadata37Template);
        AddressTemplate metadata38Template = AddressTemplate.of("/{selected.host}/path=*");
        this.metadata38 = mbuiContext.metadataRegistry().lookup(metadata38Template);
        AddressTemplate metadata36Template = AddressTemplate.of("/{selected.host}/interface=*");
        this.metadata36 = mbuiContext.metadataRegistry().lookup(metadata36Template);
        AddressTemplate metadata40Template = AddressTemplate.of("/{selected.host}/system-property=*");
        this.metadata40 = mbuiContext.metadataRegistry().lookup(metadata40Template);
        this.handlebarElements = new HashMap<>();

        hostConfigurationForm = new ModelNodeForm.Builder<org.jboss.hal.core.runtime.host.Host>("host-configuration-form", metadata35)
            .includeRuntime()
            .include("name", "organization", "directory-grouping", "uuid", "release-codename", "release-version", "product-name", "product-version", "management-major-version", "management-minor-version", "management-micro-version", "running-mode", "host-state", "suspend-state")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveHost(form, changedValues))
            .build();
        hostInterfaceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("host-interface-form", metadata36)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata36Template.resolve(mbuiContext.statementContext(), name),
                    "Interface", name);
            })
            .build();
        hostJvmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("host-jvm-form", metadata37)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata37Template.resolve(mbuiContext.statementContext(), name),
                    "Jvm", name);
            })
            .build();
        hostPathForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("host-path-form", metadata38)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata38Template.resolve(mbuiContext.statementContext(), name),
                    "Path", name);
            })
            .build();
        hostSocketBindingGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("host-socket-binding-group-form", metadata39)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata39Template.resolve(mbuiContext.statementContext(), name),
                    "Socket Binding Group", name);
            })
            .build();
        hostSystemPropertyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("host-system-property-form", metadata40)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata40Template.resolve(mbuiContext.statementContext(), name),
                    "System Property", name);
            })
            .build();

        Options<org.jboss.hal.dmr.model.NamedNode> hostInterfaceTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata36)
            .button(mbuiContext.tableButtonFactory().add(IdBuilder.build("host-interface-table", "add"), "Interface",
                metadata36Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Interface", metadata36Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        hostInterfaceTable = new ModelNodeTable<>("host-interface-table", hostInterfaceTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> hostJvmTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata37)
            .button(mbuiContext.tableButtonFactory().add(IdBuilder.build("host-jvm-table", "add"), "Jvm",
                metadata37Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Jvm", metadata37Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        hostJvmTable = new ModelNodeTable<>("host-jvm-table", hostJvmTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> hostPathTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata38)
            .button(mbuiContext.tableButtonFactory().add(IdBuilder.build("host-path-table", "add"), "Path",
                metadata38Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Path", metadata38Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "path")
            .build();
        hostPathTable = new ModelNodeTable<>("host-path-table", hostPathTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> hostSocketBindingGroupTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata39)
            .button(mbuiContext.tableButtonFactory().add(IdBuilder.build("host-socket-binding-group-table", "add"), "Socket Binding Group",
                metadata39Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Socket Binding Group", metadata39Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        hostSocketBindingGroupTable = new ModelNodeTable<>("host-socket-binding-group-table", hostSocketBindingGroupTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> hostSystemPropertyTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata40)
            .button(mbuiContext.tableButtonFactory().add(IdBuilder.build("host-system-property-table", "add"), "System Property",
                metadata40Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("System Property", metadata40Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("value")
            .build();
        hostSystemPropertyTable = new ModelNodeTable<>("host-system-property-table", hostSystemPropertyTableOptions);

        registerAttachable(hostConfigurationForm);
        registerAttachable(hostInterfaceTable);
        registerAttachable(hostInterfaceForm);
        registerAttachable(hostJvmTable);
        registerAttachable(hostJvmForm);
        registerAttachable(hostPathTable);
        registerAttachable(hostPathForm);
        registerAttachable(hostSocketBindingGroupTable);
        registerAttachable(hostSocketBindingGroupForm);
        registerAttachable(hostSystemPropertyTable);
        registerAttachable(hostSystemPropertyForm);

        navigation = new VerticalNavigation();
        Elements.Builder hostConfigurationItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1 id=\"host-configuration-title\" /><p>{{metadata35.getDescription().getDescription()}}</p>"))
                    .rememberAs("html106")
                .end()
                .add(hostConfigurationForm)
            .end();
        Element hostConfigurationItemElement = hostConfigurationItemBuilder.build();
        handlebarElements.put("html106", hostConfigurationItemBuilder.referenceFor("html106"));
        navigation.addPrimary("host-configuration-item", "Configuration", "pficon pficon-cluster", hostConfigurationItemElement);
        Elements.Builder hostInterfaceItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Interfaces</h1><p>{{metadata36.getDescription().getDescription()}}</p>"))
                    .rememberAs("html108")
                .end()
                .add(hostInterfaceTable)
                .add(hostInterfaceForm)
            .end();
        Element hostInterfaceItemElement = hostInterfaceItemBuilder.build();
        handlebarElements.put("html108", hostInterfaceItemBuilder.referenceFor("html108"));
        navigation.addPrimary("host-interface-item", "Interfaces", "fa fa-exchange", hostInterfaceItemElement);
        Elements.Builder hostJvmItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JVMs</h1><p>{{metadata37.getDescription().getDescription()}}</p>"))
                    .rememberAs("html111")
                .end()
                .add(hostJvmTable)
                .add(hostJvmForm)
            .end();
        Element hostJvmItemElement = hostJvmItemBuilder.build();
        handlebarElements.put("html111", hostJvmItemBuilder.referenceFor("html111"));
        navigation.addPrimary("host-jvm-item", "JVMs", "fa fa-coffee", hostJvmItemElement);
        Elements.Builder hostPathItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Paths</h1><p>{{metadata38.getDescription().getDescription()}}</p>"))
                    .rememberAs("html114")
                .end()
                .add(hostPathTable)
                .add(hostPathForm)
            .end();
        Element hostPathItemElement = hostPathItemBuilder.build();
        handlebarElements.put("html114", hostPathItemBuilder.referenceFor("html114"));
        navigation.addPrimary("host-path-item", "Paths", "fa fa-folder-open", hostPathItemElement);
        Elements.Builder hostSocketBindingGroupItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Socket Binding Groups</h1><p>{{metadata39.getDescription().getDescription()}}</p>"))
                    .rememberAs("html117")
                .end()
                .add(hostSocketBindingGroupTable)
                .add(hostSocketBindingGroupForm)
            .end();
        Element hostSocketBindingGroupItemElement = hostSocketBindingGroupItemBuilder.build();
        handlebarElements.put("html117", hostSocketBindingGroupItemBuilder.referenceFor("html117"));
        navigation.addPrimary("host-socket-binding-group-item", "Socket Binding Groups", "fa fa-object-group", hostSocketBindingGroupItemElement);
        Elements.Builder hostSystemPropertyItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>System Properties</h1><p>{{metadata40.getDescription().getDescription()}}</p>"))
                    .rememberAs("html120")
                .end()
                .add(hostSystemPropertyTable)
                .add(hostSystemPropertyForm)
            .end();
        Element hostSystemPropertyItemElement = hostSystemPropertyItemBuilder.build();
        handlebarElements.put("html120", hostSystemPropertyItemBuilder.referenceFor("html120"));
        navigation.addPrimary("host-system-property-item", "System Properties", "fa fa-list-ul", hostSystemPropertyItemElement);

        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

        hostInterfaceTable.api().bindForm(hostInterfaceForm);
        hostJvmTable.api().bindForm(hostJvmForm);
        hostPathTable.api().bindForm(hostPathForm);
        hostSocketBindingGroupTable.api().bindForm(hostSocketBindingGroupForm);
        hostSystemPropertyTable.api().bindForm(hostSystemPropertyForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html106"), "{{metadata35.getDescription().getDescription()}}", String.valueOf(metadata35.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html108"), "{{metadata36.getDescription().getDescription()}}", String.valueOf(metadata36.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html111"), "{{metadata37.getDescription().getDescription()}}", String.valueOf(metadata37.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html114"), "{{metadata38.getDescription().getDescription()}}", String.valueOf(metadata38.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html117"), "{{metadata39.getDescription().getDescription()}}", String.valueOf(metadata39.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html120"), "{{metadata40.getDescription().getDescription()}}", String.valueOf(metadata40.getDescription().getDescription()));
    }
}
