package org.jboss.hal.meta.resource;

import com.google.common.collect.HashMultimap;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.HashMap;
import javax.annotation.Generated;

import static java.util.Arrays.asList;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.RequiredResourcesProcessor")
public class RequiredResourcesImpl implements org.jboss.hal.meta.resource.RequiredResources {

    private final HashMultimap<String, String> resources;
    private final Map<String, Boolean> recursive;

    public RequiredResourcesImpl() {
        resources = HashMultimap.create();
        recursive = new HashMap<>();

        resources.putAll("ee", asList("/{selected.profile}/subsystem=ee"));
        recursive.put("ee", true);
        resources.putAll("server", asList("/host=*/server=*", "/host=*/server-config=*"));
        recursive.put("server", false);
        resources.putAll("jdbc-driver", asList("/{selected.profile}/subsystem=datasources/jdbc-driver=*"));
        recursive.put("jdbc-driver", true);
        resources.putAll("io", asList("/{selected.profile}/subsystem=io/worker=*", "/{selected.profile}/subsystem=io", "/{selected.profile}/subsystem=io/buffer-pool=*"));
        recursive.put("io", true);
        resources.putAll("profile", asList("/profile=*"));
        recursive.put("profile", false);
        resources.putAll("iiop-openjdk", asList("/{selected.profile}/subsystem=iiop-openjdk"));
        recursive.put("iiop-openjdk", true);
        resources.putAll("logging-configuration", asList("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*", "/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*", "/{selected.profile}/subsystem=logging/syslog-handler=*", "/{selected.profile}/subsystem=logging", "/{selected.profile}/subsystem=logging/size-rotating-file-handler=*", "/{selected.profile}/subsystem=logging/pattern-formatter=*", "/{selected.profile}/subsystem=logging/root-logger=ROOT", "/{selected.profile}/subsystem=logging/console-handler=*", "/{selected.profile}/subsystem=logging/async-handler=*", "/{selected.profile}/subsystem=logging/logger=*", "/{selected.profile}/subsystem=logging/custom-handler=*", "/{selected.profile}/subsystem=logging/file-handler=*", "/{selected.profile}/subsystem=logging/custom-formatter=*"));
        recursive.put("logging-configuration", true);
        resources.putAll("interface", asList("/interface=*"));
        recursive.put("interface", true);
        resources.putAll("transactions", asList("/{selected.profile}/subsystem=datasources/data-source=*", "/{selected.profile}/subsystem=datasources/xa-data-source=*", "/{selected.profile}/subsystem=transactions"));
        recursive.put("transactions", true);
        resources.putAll("server-configuration", asList("/{selected.host}/{selected.server}/system-property=*", "/{selected.host}/{selected.server}", "/{selected.host}/{selected.server}/jvm=*", "/{selected.host}/{selected.server}/path=*", "/{selected.host}/{selected.server}/interface=*"));
        recursive.put("server-configuration", false);
        resources.putAll("server-group-configuration", asList("/{selected.group}/jvm=*", "/{selected.group}", "/{selected.group}/system-property=*"));
        recursive.put("server-group-configuration", false);
        resources.putAll("mail-session", asList("/{selected.profile}/subsystem=mail/mail-session=*"));
        recursive.put("mail-session", true);
        resources.putAll("logging-profile", asList("/{selected.profile}/subsystem=logging/logging-profile=*"));
        recursive.put("logging-profile", true);
        resources.putAll("path", asList("/path=*"));
        recursive.put("path", true);
        resources.putAll("socket-binding", asList("/socket-binding-group=*"));
        recursive.put("socket-binding", true);
        resources.putAll("deployment-scanner", asList("/{selected.profile}/subsystem=deployment-scanner/scanner=*", "/{selected.profile}/subsystem=deployment-scanner"));
        recursive.put("deployment-scanner", true);
        resources.putAll("data-source", asList("/{selected.profile}/subsystem=datasources/data-source=*", "/{selected.profile}/subsystem=datasources/jdbc-driver=*", "/{selected.profile}/subsystem=datasources/xa-data-source=*"));
        recursive.put("data-source", true);
        resources.putAll("host", asList("/host=*"));
        recursive.put("host", false);
        resources.putAll("server-group", asList("/server-group=*"));
        recursive.put("server-group", false);
        resources.putAll("host-configuration", asList("/{selected.host}", "/{selected.host}/socket-binding-group=*", "/{selected.host}/jvm=*", "/{selected.host}/path=*", "/{selected.host}/interface=*", "/{selected.host}/system-property=*"));
        recursive.put("host-configuration", false);
    }

    @Override
    public Set<String> getResources(String id) {
        if (resources.containsKey(id)) {
            return resources.get(id);
        } else {
            return Collections.<String>emptySet();
        }
    }

    @Override
    public boolean isRecursive(String id) {
        if (recursive.containsKey(id)) {
            return recursive.get(id);
        } else {
            return false;
        }
    }
}
