package org.jboss.hal.client.configuration.subsystem.io;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.typeahead.Typeahead;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_IOView extends IOView {

    private final Metadata metadata4;
    private final Metadata metadata5;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_IOView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata4Template = AddressTemplate.of("/{selected.profile}/subsystem=io/worker=*");
        this.metadata4 = mbuiContext.metadataRegistry().lookup(metadata4Template);
        AddressTemplate metadata5Template = AddressTemplate.of("/{selected.profile}/subsystem=io/buffer-pool=*");
        this.metadata5 = mbuiContext.metadataRegistry().lookup(metadata5Template);
        this.handlebarElements = new HashMap<>();

        bufferPoolForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("buffer-pool-form", metadata5)
            .include("buffer-size", "buffers-per-slice", "direct-buffers")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata5Template.resolve(mbuiContext.statementContext(), name),
                    "Buffer Pool", name);
            })
            .build();
        workerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("worker-form", metadata4)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata4Template.resolve(mbuiContext.statementContext(), name),
                    "Worker", name);
            })
            .build();

        Options<org.jboss.hal.dmr.model.NamedNode> bufferPoolTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata5)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("buffer-pool-table", Ids.ADD_SUFFIX), "Buffer Pool",
                metadata5Template,
                () -> presenter.reload(),
                "buffer-size", 
                "buffers-per-slice", 
                "direct-buffers"))
            .button(mbuiContext.tableButtonFactory().remove("Buffer Pool", metadata5Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        bufferPoolTable = new ModelNodeTable<>("buffer-pool-table", bufferPoolTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> workerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata4)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("worker-table", Ids.ADD_SUFFIX), "Worker",
                metadata4Template,
                () -> presenter.reload(),
                "io-threads", 
                "stack-size", 
                "task-keepalive", 
                "task-max-threads"))
            .button(mbuiContext.tableButtonFactory().remove("Worker", metadata4Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        workerTable = new ModelNodeTable<>("worker-table", workerTableOptions);

        registerAttachable(bufferPoolTable);
        registerAttachable(bufferPoolForm);
        registerAttachable(workerTable);
        registerAttachable(workerForm);

        navigation = new VerticalNavigation();
        Elements.Builder workerItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Worker</h1><p>{{metadata4.getDescription().getDescription()}}</p>"))
                    .rememberAs("html10")
                .end()
                .add(workerTable)
                .add(workerForm)
            .end();
        Element workerItemElement = workerItemBuilder.build();
        handlebarElements.put("html10", workerItemBuilder.referenceFor("html10"));
        navigation.addPrimary("worker-item", "Worker", "fa fa-cogs", workerItemElement);
        Elements.Builder bufferPoolItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Buffer Pool</h1><p>{{metadata5.getDescription().getDescription()}}</p>"))
                    .rememberAs("html13")
                .end()
                .add(bufferPoolTable)
                .add(bufferPoolForm)
            .end();
        Element bufferPoolItemElement = bufferPoolItemBuilder.build();
        handlebarElements.put("html13", bufferPoolItemBuilder.referenceFor("html13"));
        navigation.addPrimary("buffer-pool-item", "Buffer Pool", "pficon pficon-repository", bufferPoolItemElement);

        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

        bufferPoolTable.api().bindForm(bufferPoolForm);
        workerTable.api().bindForm(workerForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html10"), "{{metadata4.getDescription().getDescription()}}", String.valueOf(metadata4.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html13"), "{{metadata5.getDescription().getDescription()}}", String.valueOf(metadata5.getDescription().getDescription()));
    }
}
