package org.jboss.hal.client.runtime.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.typeahead.Typeahead;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_ServerView extends ServerView {

    private final Metadata metadata42;
    private final Metadata metadata43;
    private final Metadata metadata41;
    private final Metadata metadata45;
    private final Metadata metadata44;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_ServerView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata42Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/interface=*");
        this.metadata42 = mbuiContext.metadataRegistry().lookup(metadata42Template);
        AddressTemplate metadata43Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/jvm=*");
        this.metadata43 = mbuiContext.metadataRegistry().lookup(metadata43Template);
        AddressTemplate metadata41Template = AddressTemplate.of("/{selected.host}/{selected.server-config}");
        this.metadata41 = mbuiContext.metadataRegistry().lookup(metadata41Template);
        AddressTemplate metadata45Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/system-property=*");
        this.metadata45 = mbuiContext.metadataRegistry().lookup(metadata45Template);
        AddressTemplate metadata44Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/path=*");
        this.metadata44 = mbuiContext.metadataRegistry().lookup(metadata44Template);
        this.handlebarElements = new HashMap<>();

        serverConfigurationForm = new ModelNodeForm.Builder<org.jboss.hal.core.runtime.server.Server>("server-configuration-form", metadata41)
            .includeRuntime()
            .include("name", "group", "auto-start", "update-auto-start-with-server-status", "socket-binding-group", "socket-binding-port-offset", "socket-binding-default-interface", "status")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm(changedValues, metadata41Template.resolve(mbuiContext.statementContext()), "Server Configuration"))
            .build();
        serverInterfaceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("server-interface-form", metadata42)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata42Template.resolve(mbuiContext.statementContext(), name),
                    "Interface", name);
            })
            .build();
        serverJvmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("server-jvm-form", metadata43)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata43Template.resolve(mbuiContext.statementContext(), name),
                    "Jvm", name);
            })
            .build();
        serverPathForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("server-path-form", metadata44)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata44Template.resolve(mbuiContext.statementContext(), name),
                    "Path", name);
            })
            .build();
        serverSystemPropertyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("server-system-property-form", metadata45)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata45Template.resolve(mbuiContext.statementContext(), name),
                    "System Property", name);
            })
            .build();

        Options<org.jboss.hal.dmr.model.NamedNode> serverInterfaceTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata42)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-interface-table", Ids.ADD_SUFFIX), "Interface",
                metadata42Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Interface", metadata42Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        serverInterfaceTable = new ModelNodeTable<>("server-interface-table", serverInterfaceTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> serverJvmTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata43)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-jvm-table", Ids.ADD_SUFFIX), "Jvm",
                metadata43Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Jvm", metadata43Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        serverJvmTable = new ModelNodeTable<>("server-jvm-table", serverJvmTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> serverPathTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata44)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-path-table", Ids.ADD_SUFFIX), "Path",
                metadata44Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Path", metadata44Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "path")
            .build();
        serverPathTable = new ModelNodeTable<>("server-path-table", serverPathTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> serverSystemPropertyTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata45)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-system-property-table", Ids.ADD_SUFFIX), "System Property",
                metadata45Template,
                () -> presenter.reload(),
                "value"))
            .button(mbuiContext.tableButtonFactory().remove("System Property", metadata45Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("value")
            .build();
        serverSystemPropertyTable = new ModelNodeTable<>("server-system-property-table", serverSystemPropertyTableOptions);

        registerAttachable(serverConfigurationForm);
        registerAttachable(serverInterfaceTable);
        registerAttachable(serverInterfaceForm);
        registerAttachable(serverJvmTable);
        registerAttachable(serverJvmForm);
        registerAttachable(serverPathTable);
        registerAttachable(serverPathForm);
        registerAttachable(serverSystemPropertyTable);
        registerAttachable(serverSystemPropertyForm);

        navigation = new VerticalNavigation();
        Elements.Builder serverConfigurationItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Server Configuration</h1><p>{{metadata41.getDescription().getDescription()}}</p>"))
                    .rememberAs("html123")
                .end()
                .add(serverConfigurationForm)
            .end();
        Element serverConfigurationItemElement = serverConfigurationItemBuilder.build();
        handlebarElements.put("html123", serverConfigurationItemBuilder.referenceFor("html123"));
        navigation.addPrimary("server-configuration-item", "Configuration", "pficon pficon-cluster", serverConfigurationItemElement);
        Elements.Builder serverInterfaceItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Interfaces</h1><p>{{metadata42.getDescription().getDescription()}}</p>"))
                    .rememberAs("html125")
                .end()
                .add(serverInterfaceTable)
                .add(serverInterfaceForm)
            .end();
        Element serverInterfaceItemElement = serverInterfaceItemBuilder.build();
        handlebarElements.put("html125", serverInterfaceItemBuilder.referenceFor("html125"));
        navigation.addPrimary("server-interface-item", "Interfaces", "fa fa-exchange", serverInterfaceItemElement);
        Elements.Builder serverJvmItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JVMs</h1><p>{{metadata43.getDescription().getDescription()}}</p>"))
                    .rememberAs("html128")
                .end()
                .add(serverJvmTable)
                .add(serverJvmForm)
            .end();
        Element serverJvmItemElement = serverJvmItemBuilder.build();
        handlebarElements.put("html128", serverJvmItemBuilder.referenceFor("html128"));
        navigation.addPrimary("server-jvm-item", "JVMs", "fa fa-coffee", serverJvmItemElement);
        Elements.Builder serverPathItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Paths</h1><p>{{metadata44.getDescription().getDescription()}}</p>"))
                    .rememberAs("html131")
                .end()
                .add(serverPathTable)
                .add(serverPathForm)
            .end();
        Element serverPathItemElement = serverPathItemBuilder.build();
        handlebarElements.put("html131", serverPathItemBuilder.referenceFor("html131"));
        navigation.addPrimary("server-path-item", "Paths", "fa fa-folder-open", serverPathItemElement);
        Elements.Builder serverSystemPropertyItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>System Properties</h1><p>{{metadata45.getDescription().getDescription()}}</p>"))
                    .rememberAs("html134")
                .end()
                .add(serverSystemPropertyTable)
                .add(serverSystemPropertyForm)
            .end();
        Element serverSystemPropertyItemElement = serverSystemPropertyItemBuilder.build();
        handlebarElements.put("html134", serverSystemPropertyItemBuilder.referenceFor("html134"));
        navigation.addPrimary("server-system-property-item", "System Properties", "fa fa-list-ul", serverSystemPropertyItemElement);

        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

        serverInterfaceTable.api().bindForm(serverInterfaceForm);
        serverJvmTable.api().bindForm(serverJvmForm);
        serverPathTable.api().bindForm(serverPathForm);
        serverSystemPropertyTable.api().bindForm(serverSystemPropertyForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html123"), "{{metadata41.getDescription().getDescription()}}", String.valueOf(metadata41.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html125"), "{{metadata42.getDescription().getDescription()}}", String.valueOf(metadata42.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html128"), "{{metadata43.getDescription().getDescription()}}", String.valueOf(metadata43.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html131"), "{{metadata44.getDescription().getDescription()}}", String.valueOf(metadata44.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html134"), "{{metadata45.getDescription().getDescription()}}", String.valueOf(metadata45.getDescription().getDescription()));
    }
}
