package org.jboss.hal.meta.search;

import com.google.common.collect.HashMultimap;

import java.util.Collections;
import java.util.Set;
import java.util.HashSet;
import javax.annotation.Generated;

import static java.util.Arrays.asList;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.NameTokenProcessor")
public class SearchIndexImpl implements org.jboss.hal.meta.search.SearchIndex {

    private final Set<String> standaloneTokens;
    private final Set<String> domainTokens;
    private final HashMultimap<String, String> keywords;
    private final HashMultimap<String, String> resources;

    public SearchIndexImpl() {
        standaloneTokens = new HashSet<>();
        domainTokens = new HashSet<>();
        keywords = HashMultimap.create();
        resources = HashMultimap.create();

        standaloneTokens.add("configuration");
        domainTokens.add("configuration");
        standaloneTokens.add("data-source-configuration");
        domainTokens.add("data-source-configuration");
        standaloneTokens.add("logging-configuration");
        domainTokens.add("logging-configuration");
        standaloneTokens.add("interface");
        domainTokens.add("interface");
        standaloneTokens.add("patching");
        domainTokens.add("patching");
        standaloneTokens.add("server-configuration");
        domainTokens.add("server-configuration");
        standaloneTokens.add("server-group-configuration");
        domainTokens.add("server-group-configuration");
        standaloneTokens.add("logging-profile");
        domainTokens.add("logging-profile");
        standaloneTokens.add("path");
        domainTokens.add("path");
        standaloneTokens.add("deployment-scanner");
        domainTokens.add("deployment-scanner");
        standaloneTokens.add("server-status");
        domainTokens.add("server-status");
        standaloneTokens.add("rhcp");
        domainTokens.add("rhcp");
        standaloneTokens.add("model-browser");
        domainTokens.add("model-browser");
        standaloneTokens.add("generic-subsystem");
        domainTokens.add("generic-subsystem");
        standaloneTokens.add("log-file");
        domainTokens.add("log-file");
        standaloneTokens.add("host-configuration");
        domainTokens.add("host-configuration");
        standaloneTokens.add("macro-editor");
        domainTokens.add("macro-editor");
        standaloneTokens.add("access-control");
        domainTokens.add("access-control");
        standaloneTokens.add("ee");
        domainTokens.add("ee");
        standaloneTokens.add("utb");
        domainTokens.add("utb");
        standaloneTokens.add("data-source-runtime");
        domainTokens.add("data-source-runtime");
        standaloneTokens.add("io");
        domainTokens.add("io");
        standaloneTokens.add("iiop-openjdk");
        domainTokens.add("iiop-openjdk");
        standaloneTokens.add("runtime");
        domainTokens.add("runtime");
        standaloneTokens.add("transactions");
        domainTokens.add("transactions");
        standaloneTokens.add("mail-session");
        domainTokens.add("mail-session");
        standaloneTokens.add("jpa-runtime");
        domainTokens.add("jpa-runtime");
        standaloneTokens.add("home");
        domainTokens.add("home");
        standaloneTokens.add("deployments");
        domainTokens.add("deployments");
    }

    @Override
    public Set<String> getTokens(boolean standalone) {
        return standalone ? standaloneTokens : domainTokens;
    }

    @Override
    public Set<String> getKeywords(String token) {
        if (keywords.containsKey(token)) {
            return keywords.get(token);
        } else {
            return Collections.<String>emptySet();
        }
    }

    @Override
    public Set<String> getResources(String token) {
        if (resources.containsKey(token)) {
            return resources.get(token);
        } else {
            return Collections.<String>emptySet();
        }
    }
}
