package org.jboss.hal.client.configuration.subsystem.batch;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.Tabs;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.typeahead.Typeahead;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_BatchView extends BatchView {

    private final Metadata metadata6;
    private final Metadata metadata5;
    private final Metadata metadata2;
    private final Metadata metadata4;
    private final Metadata metadata3;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_BatchView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata6Template = AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet/thread-pool=*");
        this.metadata6 = mbuiContext.metadataRegistry().lookup(metadata6Template);
        AddressTemplate metadata5Template = AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet/thread-factory=*");
        this.metadata5 = mbuiContext.metadataRegistry().lookup(metadata5Template);
        AddressTemplate metadata2Template = AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet");
        this.metadata2 = mbuiContext.metadataRegistry().lookup(metadata2Template);
        AddressTemplate metadata4Template = AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet/jdbc-job-repository=*");
        this.metadata4 = mbuiContext.metadataRegistry().lookup(metadata4Template);
        AddressTemplate metadata3Template = AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet/in-memory-job-repository=*");
        this.metadata3 = mbuiContext.metadataRegistry().lookup(metadata3Template);
        this.handlebarElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("configuration-form", metadata2)
            .onSave((form, changedValues) -> saveSingletonForm(changedValues, metadata2Template.resolve(mbuiContext.statementContext()), "Subsystem"))
            .build();
        inMemoryJobRepoForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("in-memory-job-repo-form", metadata3)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata3Template.resolve(mbuiContext.statementContext(), name),
                    "In Memory Job Repository", name);
            })
            .build();
        jdbcJobRepoForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("jdbc-job-repo-form", metadata4)
            .include("data-source")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata4Template.resolve(mbuiContext.statementContext(), name),
                    "JDBC Job Repository", name);
            })
            .build();
        jdbcJobRepoForm.getFormItem("data-source").registerSuggestHandler(new Typeahead(
            AddressTemplate.of("/{selected.profile}/subsystem=datasources/data-source=*"), mbuiContext.statementContext()));
        threadFactoryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("thread-factory-form", metadata5)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata5Template.resolve(mbuiContext.statementContext(), name),
                    "Thread Factory", name);
            })
            .build();
        threadPoolForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("thread-pool-form", metadata6)
            .include("name", "max-threads", "thread-factory")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata6Template.resolve(mbuiContext.statementContext(), name),
                    "Thread Pool", name);
            })
            .build();
        threadPoolForm.getFormItem("thread-factory").registerSuggestHandler(new Typeahead(
            AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet/thread-factory=*"), mbuiContext.statementContext()));

        Options<org.jboss.hal.dmr.model.NamedNode> inMemoryJobRepoTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata3)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("in-memory-job-repo-table", Ids.ADD_SUFFIX), "In Memory Job",
                metadata3Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("In Memory Job", metadata3Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        inMemoryJobRepoTable = new ModelNodeTable<>("in-memory-job-repo-table", inMemoryJobRepoTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> jdbcJobRepoTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata4)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("jdbc-job-repo-table", Ids.ADD_SUFFIX), "JDBC Job Repository",
                metadata4Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("JDBC Job Repository", metadata4Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        jdbcJobRepoTable = new ModelNodeTable<>("jdbc-job-repo-table", jdbcJobRepoTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> threadFactoryTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata5)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("thread-factory-table", Ids.ADD_SUFFIX), "Thread Factory",
                metadata5Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Thread Factory", metadata5Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        threadFactoryTable = new ModelNodeTable<>("thread-factory-table", threadFactoryTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> threadPoolTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata6)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("thread-pool-table", Ids.ADD_SUFFIX), "Thread Pool",
                metadata6Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Thread Pool", metadata6Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        threadPoolTable = new ModelNodeTable<>("thread-pool-table", threadPoolTableOptions);

        registerAttachable(configurationForm);
        registerAttachable(inMemoryJobRepoTable);
        registerAttachable(inMemoryJobRepoForm);
        registerAttachable(jdbcJobRepoTable);
        registerAttachable(jdbcJobRepoForm);
        registerAttachable(threadFactoryTable);
        registerAttachable(threadFactoryForm);
        registerAttachable(threadPoolTable);
        registerAttachable(threadPoolForm);


        navigation = new VerticalNavigation();
        Elements.Builder configurationItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>{{metadata2.getDescription().getDescription()}}</p>"))
                    .rememberAs("html5")
                .end()
                .add(configurationForm)
            .end();
        Element configurationItemElement = configurationItemBuilder.build();
        handlebarElements.put("html5", configurationItemBuilder.referenceFor("html5"));
        navigation.addPrimary("configuration-item", "Configuration", "fa fa-cogs", configurationItemElement);
        Elements.Builder inMemoryJobRepoItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>In Memory Job Repository</h1><p>{{metadata3.getDescription().getDescription()}}</p>"))
                    .rememberAs("html7")
                .end()
                .add(inMemoryJobRepoTable)
                .add(inMemoryJobRepoForm)
            .end();
        Element inMemoryJobRepoItemElement = inMemoryJobRepoItemBuilder.build();
        handlebarElements.put("html7", inMemoryJobRepoItemBuilder.referenceFor("html7"));
        navigation.addPrimary("in-memory-job-repo-item", "In Memory", "pficon pficon-memory", inMemoryJobRepoItemElement);
        Elements.Builder jdbcJobRepoItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JDBC Job Repository</h1><p>{{metadata4.getDescription().getDescription()}}</p>"))
                    .rememberAs("html10")
                .end()
                .add(jdbcJobRepoTable)
                .add(jdbcJobRepoForm)
            .end();
        Element jdbcJobRepoItemElement = jdbcJobRepoItemBuilder.build();
        handlebarElements.put("html10", jdbcJobRepoItemBuilder.referenceFor("html10"));
        navigation.addPrimary("jdbc-job-repo-item", "JDBC", "fa fa-database", jdbcJobRepoItemElement);
        Elements.Builder threadFactoryItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Thread Factory</h1><p>{{metadata5.getDescription().getDescription()}}</p>"))
                    .rememberAs("html13")
                .end()
                .add(threadFactoryTable)
                .add(threadFactoryForm)
            .end();
        Element threadFactoryItemElement = threadFactoryItemBuilder.build();
        handlebarElements.put("html13", threadFactoryItemBuilder.referenceFor("html13"));
        navigation.addPrimary("thread-factory-item", "Thread Factory", "pficon pficon-service", threadFactoryItemElement);
        Elements.Builder threadPoolItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Thread Pool</h1><p>{{metadata6.getDescription().getDescription()}}</p>"))
                    .rememberAs("html16")
                .end()
                .add(threadPoolTable)
                .add(threadPoolForm)
            .end();
        Element threadPoolItemElement = threadPoolItemBuilder.build();
        handlebarElements.put("html16", threadPoolItemBuilder.referenceFor("html16"));
        navigation.addPrimary("thread-pool-item", "Thread Pool", "pficon pficon-resource-pool", threadPoolItemElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

        inMemoryJobRepoTable.api().bindForm(inMemoryJobRepoForm);
        jdbcJobRepoTable.api().bindForm(jdbcJobRepoForm);
        threadFactoryTable.api().bindForm(threadFactoryForm);
        threadPoolTable.api().bindForm(threadPoolForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html5"), "{{metadata2.getDescription().getDescription()}}", String.valueOf(metadata2.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html7"), "{{metadata3.getDescription().getDescription()}}", String.valueOf(metadata3.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html10"), "{{metadata4.getDescription().getDescription()}}", String.valueOf(metadata4.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html13"), "{{metadata5.getDescription().getDescription()}}", String.valueOf(metadata5.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html16"), "{{metadata6.getDescription().getDescription()}}", String.valueOf(metadata6.getDescription().getDescription()));
    }
}
