package org.jboss.hal.client.configuration.subsystem.logging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.Tabs;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.typeahead.Typeahead;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_LoggingProfileView extends LoggingProfileView {

    private final Metadata metadata33;
    private final Metadata metadata29;
    private final Metadata metadata34;
    private final Metadata metadata27;
    private final Metadata metadata26;
    private final Metadata metadata23;
    private final Metadata metadata31;
    private final Metadata metadata30;
    private final Metadata metadata25;
    private final Metadata metadata24;
    private final Metadata metadata32;
    private final Metadata metadata28;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_LoggingProfileView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata33Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/pattern-formatter=*");
        this.metadata33 = mbuiContext.metadataRegistry().lookup(metadata33Template);
        AddressTemplate metadata29Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/size-rotating-file-handler=*");
        this.metadata29 = mbuiContext.metadataRegistry().lookup(metadata29Template);
        AddressTemplate metadata34Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/custom-formatter=*");
        this.metadata34 = mbuiContext.metadataRegistry().lookup(metadata34Template);
        AddressTemplate metadata27Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/periodic-rotating-file-handler=*");
        this.metadata27 = mbuiContext.metadataRegistry().lookup(metadata27Template);
        AddressTemplate metadata26Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/file-handler=*");
        this.metadata26 = mbuiContext.metadataRegistry().lookup(metadata26Template);
        AddressTemplate metadata23Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/root-logger=ROOT");
        this.metadata23 = mbuiContext.metadataRegistry().lookup(metadata23Template);
        AddressTemplate metadata31Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/custom-handler=*");
        this.metadata31 = mbuiContext.metadataRegistry().lookup(metadata31Template);
        AddressTemplate metadata30Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/async-handler=*");
        this.metadata30 = mbuiContext.metadataRegistry().lookup(metadata30Template);
        AddressTemplate metadata25Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/console-handler=*");
        this.metadata25 = mbuiContext.metadataRegistry().lookup(metadata25Template);
        AddressTemplate metadata24Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/logger=*");
        this.metadata24 = mbuiContext.metadataRegistry().lookup(metadata24Template);
        AddressTemplate metadata32Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/syslog-handler=*");
        this.metadata32 = mbuiContext.metadataRegistry().lookup(metadata32Template);
        AddressTemplate metadata28Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/periodic-size-rotating-file-handler=*");
        this.metadata28 = mbuiContext.metadataRegistry().lookup(metadata28Template);
        this.handlebarElements = new HashMap<>();

        rootLoggerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("logging-profile-root-logger-form", metadata23)
            .include("level", "handlers", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveRootLogger(form, changedValues))
            .build();
        loggerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-profile-categories-form", metadata24)
            .include("category", "level", "handlers", "use-parent-handlers", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveLogger(form, changedValues))
            .build();
        consoleHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-profile-handler-console-form", metadata25)
            .include("level", "target", "autoflush", "formatter", "named-formatter", "enabled", "encoding", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveConsoleHandler(form, changedValues))
            .build();
        List<AddressTemplate> consoleHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-formatter=*"));
        consoleHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new Typeahead(
            consoleHandlerFormTemplates, mbuiContext.statementContext()));
        fileHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-profile-handler-file-form", metadata26)
            .customFormItem("file", (attributeDescription) -> new FileFormItem())
            .include("level")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveFileHandler(form, changedValues))
            .build();
        List<AddressTemplate> fileHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-formatter=*"));
        fileHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new Typeahead(
            fileHandlerFormTemplates, mbuiContext.statementContext()));
        periodicHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-profile-handler-periodic-rotating-file-form", metadata27)
            .customFormItem("file", (attributeDescription) -> new FileFormItem())
            .include("suffix")
            .include("level")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> savePeriodicHandler(form, changedValues))
            .build();
        List<AddressTemplate> periodicHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-formatter=*"));
        periodicHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new Typeahead(
            periodicHandlerFormTemplates, mbuiContext.statementContext()));
        periodicSizeHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-profile-handler-periodic-size-rotating-file-form", metadata28)
            .customFormItem("file", (attributeDescription) -> new FileFormItem())
            .include("suffix")
            .include("level")
            .include("rotate-size")
            .include("rotate-on-boot")
            .include("max-backup-index")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> savePeriodicSizeHandler(form, changedValues))
            .build();
        List<AddressTemplate> periodicSizeHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-formatter=*"));
        periodicSizeHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new Typeahead(
            periodicSizeHandlerFormTemplates, mbuiContext.statementContext()));
        sizeHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-profile-handler-size-rotating-file-form", metadata29)
            .customFormItem("file", (attributeDescription) -> new FileFormItem())
            .include("suffix")
            .include("level")
            .include("rotate-size")
            .include("rotate-on-boot")
            .include("max-backup-index")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveSizeHandler(form, changedValues))
            .build();
        List<AddressTemplate> sizeHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-formatter=*"));
        sizeHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new Typeahead(
            sizeHandlerFormTemplates, mbuiContext.statementContext()));
        asyncHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-profile-handler-async-form", metadata30)
            .include("level", "subhandlers", "queue-length", "overflow-action", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveAsyncHandler(form, changedValues))
            .build();
        List<AddressTemplate> asyncHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/console-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/periodic-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/periodic-size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/syslog-handler=*"));
        asyncHandlerForm.getFormItem("subhandlers").registerSuggestHandler(new Typeahead(
            asyncHandlerFormTemplates, mbuiContext.statementContext()));
        customHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-profile-handler-custom-form", metadata31)
            .include("level", "module", "class", "properties", "formatter", "named-formatter", "enabled", "encoding", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveCustomHandler(form, changedValues))
            .build();
        List<AddressTemplate> customHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-formatter=*"));
        customHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new Typeahead(
            customHandlerFormTemplates, mbuiContext.statementContext()));
        syslogHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-profile-handler-syslog-form", metadata32)
            .include("level", "syslog-format", "hostname", "server-address", "port", "app-name", "facility", "enabled")
            .unsorted()
            .onSave((form, changedValues) -> saveSyslogHandler(form, changedValues))
            .build();
        customFormatterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-profile-formatter-custom-form", metadata34)
            .include("class", "module", "properties")
            .unsorted()
            .onSave((form, changedValues) -> saveCustomFormatter(form, changedValues))
            .build();
        patternFormatterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-profile-formatter-pattern-form", metadata33)
            .include("color-map", "pattern")
            .unsorted()
            .onSave((form, changedValues) -> savePatternFormatter(form, changedValues))
            .build();

        Options<org.jboss.hal.dmr.model.NamedNode> loggerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata24)
            .button(mbuiContext.resources().constants().add(), (event, api) -> addLogger())
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> removeLogger(api))
            .columns("category", "level")
            .build();
        loggerTable = new ModelNodeTable<>("logging-profile-categories-table", loggerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> consoleHandlerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata25)
            .button(mbuiContext.resources().constants().add(), (event, api) -> addConsoleHandler())
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> removeConsoleHandler(api))
            .columns("name", "level", "target")
            .build();
        consoleHandlerTable = new ModelNodeTable<>("logging-profile-handler-console-table", consoleHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> fileHandlerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata26)
            .button(mbuiContext.resources().constants().add(), (event, api) -> addFileHandler())
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> removeFileHandler(api))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        fileHandlerTable = new ModelNodeTable<>("logging-profile-handler-file-table", fileHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> periodicHandlerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata27)
            .button(mbuiContext.resources().constants().add(), (event, api) -> addPeriodicHandler())
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> removePeriodicHandler(api))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        periodicHandlerTable = new ModelNodeTable<>("logging-profile-handler-periodic-rotating-file-table", periodicHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> periodicSizeHandlerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata28)
            .button(mbuiContext.resources().constants().add(), (event, api) -> addPeriodicSizeHandler())
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> removePeriodicSizeHandler(api))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        periodicSizeHandlerTable = new ModelNodeTable<>("logging-profile-handler-periodic-size-rotating-file-table", periodicSizeHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> sizeHandlerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata29)
            .button(mbuiContext.resources().constants().add(), (event, api) -> addSizeHandler())
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> removeSizeHandler(api))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        sizeHandlerTable = new ModelNodeTable<>("logging-profile-handler-size-rotating-file-table", sizeHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> asyncHandlerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata30)
            .button(mbuiContext.resources().constants().add(), (event, api) -> addAsyncHandler())
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> removeAsyncHandler(api))
            .columns("name", "level")
            .build();
        asyncHandlerTable = new ModelNodeTable<>("logging-profile-handler-async-table", asyncHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> customHandlerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata31)
            .button(mbuiContext.resources().constants().add(), (event, api) -> addCustomHandler())
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> removeCustomHandler(api))
            .columns("name", "level")
            .build();
        customHandlerTable = new ModelNodeTable<>("logging-profile-handler-custom-table", customHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> syslogHandlerTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata32)
            .button(mbuiContext.resources().constants().add(), (event, api) -> addSyslogHandler())
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> removeSyslogHandler(api))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("level")
            .build();
        syslogHandlerTable = new ModelNodeTable<>("logging-profile-handler-syslog-table", syslogHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> customFormatterTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata34)
            .button(mbuiContext.resources().constants().add(), (event, api) -> addCustomFormatter())
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> removeCustomFormatter(api))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        customFormatterTable = new ModelNodeTable<>("logging-profile-formatter-custom-table", customFormatterTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> patternFormatterTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata33)
            .button(mbuiContext.resources().constants().add(), (event, api) -> addPatternFormatter())
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> removePatternFormatter(api))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("pattern")
            .build();
        patternFormatterTable = new ModelNodeTable<>("logging-profile-formatter-pattern-table", patternFormatterTableOptions);

        registerAttachable(rootLoggerForm);
        registerAttachable(loggerTable);
        registerAttachable(loggerForm);
        registerAttachable(consoleHandlerTable);
        registerAttachable(consoleHandlerForm);
        registerAttachable(fileHandlerTable);
        registerAttachable(fileHandlerForm);
        registerAttachable(periodicHandlerTable);
        registerAttachable(periodicHandlerForm);
        registerAttachable(periodicSizeHandlerTable);
        registerAttachable(periodicSizeHandlerForm);
        registerAttachable(sizeHandlerTable);
        registerAttachable(sizeHandlerForm);
        registerAttachable(asyncHandlerTable);
        registerAttachable(asyncHandlerForm);
        registerAttachable(customHandlerTable);
        registerAttachable(customHandlerForm);
        registerAttachable(syslogHandlerTable);
        registerAttachable(syslogHandlerForm);
        registerAttachable(customFormatterTable);
        registerAttachable(customFormatterForm);
        registerAttachable(patternFormatterTable);
        registerAttachable(patternFormatterForm);


        navigation = new VerticalNavigation();
        Elements.Builder loggingProfileRootLoggerItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1 id=\"logging-profile-root-logger-header\">Root Logger</h1><p id=\"logging-profile-root-logger-description\">{{metadata23.getDescription().getDescription()}}</p>"))
                    .rememberAs("html61")
                .end()
                .add(rootLoggerForm)
            .end();
        Element loggingProfileRootLoggerItemElement = loggingProfileRootLoggerItemBuilder.build();
        handlebarElements.put("html61", loggingProfileRootLoggerItemBuilder.referenceFor("html61"));
        navigation.addPrimary("logging-profile-root-logger-item", "Root Logger", "fa fa-sitemap", loggingProfileRootLoggerItemElement);
        Elements.Builder loggingProfileCategoriesItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Categories</h1><p>{{metadata24.getDescription().getDescription()}}</p>"))
                    .rememberAs("html63")
                .end()
                .add(loggerTable)
                .add(loggerForm)
            .end();
        Element loggingProfileCategoriesItemElement = loggingProfileCategoriesItemBuilder.build();
        handlebarElements.put("html63", loggingProfileCategoriesItemBuilder.referenceFor("html63"));
        navigation.addPrimary("logging-profile-categories-item", "Categories", "pficon pficon-repository", loggingProfileCategoriesItemElement);
        navigation.addPrimary("logging-profile-handler-item", "Handler", "fa fa-cogs");
        Elements.Builder loggingProfileHandlerConsoleItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Console Handler</h1><p>{{metadata25.getDescription().getDescription()}}</p>"))
                    .rememberAs("html66")
                .end()
                .add(consoleHandlerTable)
                .add(consoleHandlerForm)
            .end();
        Element loggingProfileHandlerConsoleItemElement = loggingProfileHandlerConsoleItemBuilder.build();
        handlebarElements.put("html66", loggingProfileHandlerConsoleItemBuilder.referenceFor("html66"));
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-console-item", "Console Handler", loggingProfileHandlerConsoleItemElement);
        Elements.Builder loggingProfileHandlerFileItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>File Handler</h1><p>{{metadata26.getDescription().getDescription()}}</p>"))
                    .rememberAs("html69")
                .end()
                .add(fileHandlerTable)
                .add(fileHandlerForm)
            .end();
        Element loggingProfileHandlerFileItemElement = loggingProfileHandlerFileItemBuilder.build();
        handlebarElements.put("html69", loggingProfileHandlerFileItemBuilder.referenceFor("html69"));
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-file-item", "File Handler", loggingProfileHandlerFileItemElement);
        Elements.Builder loggingProfileHandlerPeriodicRotatingFileItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Periodic Handler</h1><p>{{metadata27.getDescription().getDescription()}}</p>"))
                    .rememberAs("html72")
                .end()
                .add(periodicHandlerTable)
                .add(periodicHandlerForm)
            .end();
        Element loggingProfileHandlerPeriodicRotatingFileItemElement = loggingProfileHandlerPeriodicRotatingFileItemBuilder.build();
        handlebarElements.put("html72", loggingProfileHandlerPeriodicRotatingFileItemBuilder.referenceFor("html72"));
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-periodic-rotating-file-item", "Periodic Handler", loggingProfileHandlerPeriodicRotatingFileItemElement);
        Elements.Builder loggingProfileHandlerPeriodicSizeRotatingFileItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Periodic Size Handler</h1><p>{{metadata28.getDescription().getDescription()}}</p>"))
                    .rememberAs("html75")
                .end()
                .add(periodicSizeHandlerTable)
                .add(periodicSizeHandlerForm)
            .end();
        Element loggingProfileHandlerPeriodicSizeRotatingFileItemElement = loggingProfileHandlerPeriodicSizeRotatingFileItemBuilder.build();
        handlebarElements.put("html75", loggingProfileHandlerPeriodicSizeRotatingFileItemBuilder.referenceFor("html75"));
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-periodic-size-rotating-file-item", "Periodic Size Handler", loggingProfileHandlerPeriodicSizeRotatingFileItemElement);
        Elements.Builder loggingProfileHandlerSizeRotatingFileItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Size Handler</h1><p>{{metadata29.getDescription().getDescription()}}</p>"))
                    .rememberAs("html78")
                .end()
                .add(sizeHandlerTable)
                .add(sizeHandlerForm)
            .end();
        Element loggingProfileHandlerSizeRotatingFileItemElement = loggingProfileHandlerSizeRotatingFileItemBuilder.build();
        handlebarElements.put("html78", loggingProfileHandlerSizeRotatingFileItemBuilder.referenceFor("html78"));
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-size-rotating-file-item", "Size Handler", loggingProfileHandlerSizeRotatingFileItemElement);
        Elements.Builder loggingProfileHandlerAsyncItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Async Handler</h1><p>{{metadata30.getDescription().getDescription()}}</p>"))
                    .rememberAs("html81")
                .end()
                .add(asyncHandlerTable)
                .add(asyncHandlerForm)
            .end();
        Element loggingProfileHandlerAsyncItemElement = loggingProfileHandlerAsyncItemBuilder.build();
        handlebarElements.put("html81", loggingProfileHandlerAsyncItemBuilder.referenceFor("html81"));
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-async-item", "Async Handler", loggingProfileHandlerAsyncItemElement);
        Elements.Builder loggingProfileHandlerCustomItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Handler</h1><p>{{metadata31.getDescription().getDescription()}}</p>"))
                    .rememberAs("html84")
                .end()
                .add(customHandlerTable)
                .add(customHandlerForm)
            .end();
        Element loggingProfileHandlerCustomItemElement = loggingProfileHandlerCustomItemBuilder.build();
        handlebarElements.put("html84", loggingProfileHandlerCustomItemBuilder.referenceFor("html84"));
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-custom-item", "Custom Handler", loggingProfileHandlerCustomItemElement);
        Elements.Builder loggingProfileHandlerSyslogItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Syslog Handler</h1><p>{{metadata32.getDescription().getDescription()}}</p>"))
                    .rememberAs("html87")
                .end()
                .add(syslogHandlerTable)
                .add(syslogHandlerForm)
            .end();
        Element loggingProfileHandlerSyslogItemElement = loggingProfileHandlerSyslogItemBuilder.build();
        handlebarElements.put("html87", loggingProfileHandlerSyslogItemBuilder.referenceFor("html87"));
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-syslog-item", "Syslog Handler", loggingProfileHandlerSyslogItemElement);
        navigation.addPrimary("logging-profile-formatter-item", "Formatter", "fa fa-paint-brush");
        Elements.Builder loggingProfileFormatterPatternItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Pattern Formatter</h1><p>{{metadata33.getDescription().getDescription()}}</p>"))
                    .rememberAs("html90")
                .end()
                .add(patternFormatterTable)
                .add(patternFormatterForm)
            .end();
        Element loggingProfileFormatterPatternItemElement = loggingProfileFormatterPatternItemBuilder.build();
        handlebarElements.put("html90", loggingProfileFormatterPatternItemBuilder.referenceFor("html90"));
        navigation.addSecondary("logging-profile-formatter-item", "logging-profile-formatter-pattern-item", "Pattern Formatter", loggingProfileFormatterPatternItemElement);
        Elements.Builder loggingProfileFormatterCustomItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Formatter</h1><p>{{metadata34.getDescription().getDescription()}}</p>"))
                    .rememberAs("html93")
                .end()
                .add(customFormatterTable)
                .add(customFormatterForm)
            .end();
        Element loggingProfileFormatterCustomItemElement = loggingProfileFormatterCustomItemBuilder.build();
        handlebarElements.put("html93", loggingProfileFormatterCustomItemBuilder.referenceFor("html93"));
        navigation.addSecondary("logging-profile-formatter-item", "logging-profile-formatter-custom-item", "Custom Formatter", loggingProfileFormatterCustomItemElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        Element root = layoutBuilder.build();
        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

        loggerTable.api().bindForm(loggerForm);
        consoleHandlerTable.api().bindForm(consoleHandlerForm);
        fileHandlerTable.api().bindForm(fileHandlerForm);
        periodicHandlerTable.api().bindForm(periodicHandlerForm);
        periodicSizeHandlerTable.api().bindForm(periodicSizeHandlerForm);
        sizeHandlerTable.api().bindForm(sizeHandlerForm);
        asyncHandlerTable.api().bindForm(asyncHandlerForm);
        customHandlerTable.api().bindForm(customHandlerForm);
        syslogHandlerTable.api().bindForm(syslogHandlerForm);
        customFormatterTable.api().bindForm(customFormatterForm);
        patternFormatterTable.api().bindForm(patternFormatterForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html61"), "{{metadata23.getDescription().getDescription()}}", String.valueOf(metadata23.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html63"), "{{metadata24.getDescription().getDescription()}}", String.valueOf(metadata24.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html66"), "{{metadata25.getDescription().getDescription()}}", String.valueOf(metadata25.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html69"), "{{metadata26.getDescription().getDescription()}}", String.valueOf(metadata26.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html72"), "{{metadata27.getDescription().getDescription()}}", String.valueOf(metadata27.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html75"), "{{metadata28.getDescription().getDescription()}}", String.valueOf(metadata28.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html78"), "{{metadata29.getDescription().getDescription()}}", String.valueOf(metadata29.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html81"), "{{metadata30.getDescription().getDescription()}}", String.valueOf(metadata30.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html84"), "{{metadata31.getDescription().getDescription()}}", String.valueOf(metadata31.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html87"), "{{metadata32.getDescription().getDescription()}}", String.valueOf(metadata32.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html90"), "{{metadata33.getDescription().getDescription()}}", String.valueOf(metadata33.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html93"), "{{metadata34.getDescription().getDescription()}}", String.valueOf(metadata34.getDescription().getDescription()));
    }
}
