package org.jboss.hal.client.runtime.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.Tabs;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.typeahead.Typeahead;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_ServerView extends ServerView {

    private final Metadata metadata59;
    private final Metadata metadata60;
    private final Metadata metadata58;
    private final Metadata metadata62;
    private final Metadata metadata61;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_ServerView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata59Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/interface=*");
        this.metadata59 = mbuiContext.metadataRegistry().lookup(metadata59Template);
        AddressTemplate metadata60Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/jvm=*");
        this.metadata60 = mbuiContext.metadataRegistry().lookup(metadata60Template);
        AddressTemplate metadata58Template = AddressTemplate.of("/{selected.host}/{selected.server-config}");
        this.metadata58 = mbuiContext.metadataRegistry().lookup(metadata58Template);
        AddressTemplate metadata62Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/system-property=*");
        this.metadata62 = mbuiContext.metadataRegistry().lookup(metadata62Template);
        AddressTemplate metadata61Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/path=*");
        this.metadata61 = mbuiContext.metadataRegistry().lookup(metadata61Template);
        this.handlebarElements = new HashMap<>();

        serverConfigurationForm = new ModelNodeForm.Builder<org.jboss.hal.core.runtime.server.Server>("server-configuration-form", metadata58)
            .includeRuntime()
            .include("name", "group", "auto-start", "update-auto-start-with-server-status", "socket-binding-group", "socket-binding-port-offset", "socket-binding-default-interface", "status")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm(changedValues, metadata58Template.resolve(mbuiContext.statementContext()), "Server Configuration"))
            .build();
        serverInterfaceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("server-interface-form", metadata59)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata59Template.resolve(mbuiContext.statementContext(), name),
                    "Interface", name);
            })
            .build();
        serverJvmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("server-jvm-form", metadata60)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata60Template.resolve(mbuiContext.statementContext(), name),
                    "Jvm", name);
            })
            .build();
        serverPathForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("server-path-form", metadata61)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata61Template.resolve(mbuiContext.statementContext(), name),
                    "Path", name);
            })
            .build();
        serverSystemPropertyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("server-system-property-form", metadata62)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm(changedValues, metadata62Template.resolve(mbuiContext.statementContext(), name),
                    "System Property", name);
            })
            .build();

        Options<org.jboss.hal.dmr.model.NamedNode> serverInterfaceTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata59)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-interface-table", Ids.ADD_SUFFIX), "Interface",
                metadata59Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Interface", metadata59Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        serverInterfaceTable = new ModelNodeTable<>("server-interface-table", serverInterfaceTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> serverJvmTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata60)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-jvm-table", Ids.ADD_SUFFIX), "Jvm",
                metadata60Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Jvm", metadata60Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        serverJvmTable = new ModelNodeTable<>("server-jvm-table", serverJvmTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> serverPathTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata61)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-path-table", Ids.ADD_SUFFIX), "Path",
                metadata61Template,
                () -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Path", metadata61Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "path")
            .build();
        serverPathTable = new ModelNodeTable<>("server-path-table", serverPathTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> serverSystemPropertyTableOptions = new ModelNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata62)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-system-property-table", Ids.ADD_SUFFIX), "System Property",
                metadata62Template,
                () -> presenter.reload(),
                "value"))
            .button(mbuiContext.tableButtonFactory().remove("System Property", metadata62Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("value")
            .build();
        serverSystemPropertyTable = new ModelNodeTable<>("server-system-property-table", serverSystemPropertyTableOptions);

        registerAttachable(serverConfigurationForm);
        registerAttachable(serverInterfaceTable);
        registerAttachable(serverInterfaceForm);
        registerAttachable(serverJvmTable);
        registerAttachable(serverJvmForm);
        registerAttachable(serverPathTable);
        registerAttachable(serverPathForm);
        registerAttachable(serverSystemPropertyTable);
        registerAttachable(serverSystemPropertyForm);


        navigation = new VerticalNavigation();
        Elements.Builder serverConfigurationItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Server Configuration</h1><p>{{metadata58.getDescription().getDescription()}}</p>"))
                    .rememberAs("html168")
                .end()
                .add(serverConfigurationForm)
            .end();
        Element serverConfigurationItemElement = serverConfigurationItemBuilder.build();
        handlebarElements.put("html168", serverConfigurationItemBuilder.referenceFor("html168"));
        navigation.addPrimary("server-configuration-item", "Configuration", "pficon pficon-cluster", serverConfigurationItemElement);
        Elements.Builder serverInterfaceItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Interfaces</h1><p>{{metadata59.getDescription().getDescription()}}</p>"))
                    .rememberAs("html170")
                .end()
                .add(serverInterfaceTable)
                .add(serverInterfaceForm)
            .end();
        Element serverInterfaceItemElement = serverInterfaceItemBuilder.build();
        handlebarElements.put("html170", serverInterfaceItemBuilder.referenceFor("html170"));
        navigation.addPrimary("server-interface-item", "Interfaces", "fa fa-exchange", serverInterfaceItemElement);
        Elements.Builder serverJvmItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JVMs</h1><p>{{metadata60.getDescription().getDescription()}}</p>"))
                    .rememberAs("html173")
                .end()
                .add(serverJvmTable)
                .add(serverJvmForm)
            .end();
        Element serverJvmItemElement = serverJvmItemBuilder.build();
        handlebarElements.put("html173", serverJvmItemBuilder.referenceFor("html173"));
        navigation.addPrimary("server-jvm-item", "JVMs", "fa fa-coffee", serverJvmItemElement);
        Elements.Builder serverPathItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Paths</h1><p>{{metadata61.getDescription().getDescription()}}</p>"))
                    .rememberAs("html176")
                .end()
                .add(serverPathTable)
                .add(serverPathForm)
            .end();
        Element serverPathItemElement = serverPathItemBuilder.build();
        handlebarElements.put("html176", serverPathItemBuilder.referenceFor("html176"));
        navigation.addPrimary("server-path-item", "Paths", "fa fa-folder-open", serverPathItemElement);
        Elements.Builder serverSystemPropertyItemBuilder = new Elements.Builder()
            .div()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>System Properties</h1><p>{{metadata62.getDescription().getDescription()}}</p>"))
                    .rememberAs("html179")
                .end()
                .add(serverSystemPropertyTable)
                .add(serverSystemPropertyForm)
            .end();
        Element serverSystemPropertyItemElement = serverSystemPropertyItemBuilder.build();
        handlebarElements.put("html179", serverSystemPropertyItemBuilder.referenceFor("html179"));
        navigation.addPrimary("server-system-property-item", "System Properties", "fa fa-list-ul", serverSystemPropertyItemElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

        serverInterfaceTable.api().bindForm(serverInterfaceForm);
        serverJvmTable.api().bindForm(serverJvmForm);
        serverPathTable.api().bindForm(serverPathForm);
        serverSystemPropertyTable.api().bindForm(serverSystemPropertyForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html168"), "{{metadata58.getDescription().getDescription()}}", String.valueOf(metadata58.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html170"), "{{metadata59.getDescription().getDescription()}}", String.valueOf(metadata59.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html173"), "{{metadata60.getDescription().getDescription()}}", String.valueOf(metadata60.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html176"), "{{metadata61.getDescription().getDescription()}}", String.valueOf(metadata61.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html179"), "{{metadata62.getDescription().getDescription()}}", String.valueOf(metadata62.getDescription().getDescription()));
    }
}
