/*
 * Copyright 2015-2016 Red Hat, Inc, and individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.hal.ballroom.form;

import elemental.client.Browser;

/**
 * @author Harald Pehl
 */
public class PasswordItem extends TextBoxItem {

    public PasswordItem(final String name, final String label) {
        super(name, label);
    }

    @Override
    protected InputElement<String> newInputElement(CreationContext<?> context) {
        elemental.html.InputElement element = Browser.getDocument().createInputElement();
        element.setType("password"); //NON-NLS
        TextBoxElement passwordElement = new TextBoxElement(element);
        setupInputElement(passwordElement);
        return passwordElement;
    }

    @Override
    String asString(final String value) {
        int len = value.length();
        String val = "";
        for (int i = 0; i < len; i++)
            val += "*";
        return val;
    }
}
