package org.jboss.hal.client.bootstrap;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.web.bindery.event.shared.HandlerRegistration;

import com.google.gwt.event.shared.HasHandlers;

public class ApplicationReadyEvent extends GwtEvent<ApplicationReadyEvent.ApplicationReadyHandler> { 


  public ApplicationReadyEvent() {
    // Possibly for serialization.
  }

  public static void fire(HasHandlers source) {
    ApplicationReadyEvent eventInstance = new ApplicationReadyEvent();
    source.fireEvent(eventInstance);
  }

  public static void fire(HasHandlers source, ApplicationReadyEvent eventInstance) {
    source.fireEvent(eventInstance);
  }

  public interface HasApplicationReadyHandlers extends HasHandlers {
    HandlerRegistration addApplicationReadyHandler(ApplicationReadyHandler handler);
  }

  public interface ApplicationReadyHandler extends EventHandler {
    public void onApplicationReady(ApplicationReadyEvent event);
  }

  private static final Type<ApplicationReadyHandler> TYPE = new Type<ApplicationReadyHandler>();

  public static Type<ApplicationReadyHandler> getType() {
    return TYPE;
  }

  @Override
  public Type<ApplicationReadyHandler> getAssociatedType() {
    return TYPE;
  }

  @Override
  protected void dispatch(ApplicationReadyHandler handler) {
    handler.onApplicationReady(this);
  }

  @Override
  public boolean equals(Object obj) {
    return super.equals(obj);
  }

  @Override
  public int hashCode() {
    return super.hashCode();
  }

  @Override
  public String toString() {
    return "ApplicationReadyEvent["
    + "]";
  }
}
