package org.jboss.hal.client.configuration.subsystem.io;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.FailSafeForm;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.table.NamedNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_IOView extends IOView {

    private final Metadata metadata21;
    private final Metadata metadata22;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_IOView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata21Template = AddressTemplate.of("/{selected.profile}/subsystem=io/worker=*");
        this.metadata21 = mbuiContext.metadataRegistry().lookup(metadata21Template);
        AddressTemplate metadata22Template = AddressTemplate.of("/{selected.profile}/subsystem=io/buffer-pool=*");
        this.metadata22 = mbuiContext.metadataRegistry().lookup(metadata22Template);
        this.handlebarElements = new HashMap<>();

        bufferPoolForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("io-buffer-pool-form", metadata22)
            .include("buffer-size", "buffers-per-slice", "direct-buffers")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Buffer Pool", name, metadata22Template.resolve(mbuiContext.statementContext(), name), changedValues);
            })
            .build();
        workerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("io-worker-form", metadata21)
            .include("io-threads", "stack-size", "task-keepalive", "task-max-threads")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Worker", name, metadata21Template.resolve(mbuiContext.statementContext(), name), changedValues);
            })
            .build();

        Options<org.jboss.hal.dmr.model.NamedNode> bufferPoolTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata22)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("io-buffer-pool-table", Ids.ADD_SUFFIX), "Buffer Pool",
                metadata22Template, asList("buffer-size", "buffers-per-slice", "direct-buffers"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Buffer Pool", metadata22Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        bufferPoolTable = new NamedNodeTable<>("io-buffer-pool-table", bufferPoolTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> workerTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata21)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("io-worker-table", Ids.ADD_SUFFIX), "Worker",
                metadata21Template, asList("io-threads", "stack-size", "task-keepalive", "task-max-threads"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Worker", metadata21Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        workerTable = new NamedNodeTable<>("io-worker-table", workerTableOptions);

        navigation = new VerticalNavigation();
        Elements.Builder ioWorkerItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Worker</h1><p>{{metadata21.getDescription().getDescription()}}</p>"))
                    .rememberAs("html57")
                .end()
                .add(workerTable)
                .add(workerForm)
            .end();
        Element ioWorkerItemElement = ioWorkerItemBuilder.build();
        handlebarElements.put("html57", ioWorkerItemBuilder.referenceFor("html57"));
        navigation.addPrimary("io-worker-item", "Worker", "fa fa-cogs", ioWorkerItemElement);
        Elements.Builder ioBufferPoolItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Buffer Pool</h1><p>{{metadata22.getDescription().getDescription()}}</p>"))
                    .rememberAs("html60")
                .end()
                .add(bufferPoolTable)
                .add(bufferPoolForm)
            .end();
        Element ioBufferPoolItemElement = ioBufferPoolItemBuilder.build();
        handlebarElements.put("html60", ioBufferPoolItemBuilder.referenceFor("html60"));
        navigation.addPrimary("io-buffer-pool-item", "Buffer Pool", "pficon pficon-repository", ioBufferPoolItemElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        registerAttachable(navigation);
        registerAttachable(bufferPoolTable);
        registerAttachable(bufferPoolForm);
        registerAttachable(workerTable);
        registerAttachable(workerForm);

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            bufferPoolTable.bindForm(bufferPoolForm);
            workerTable.bindForm(workerForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html57"), "{{metadata21.getDescription().getDescription()}}", String.valueOf(metadata21.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html60"), "{{metadata22.getDescription().getDescription()}}", String.valueOf(metadata22.getDescription().getDescription()));
    }
}
