package org.jboss.hal.client.configuration.subsystem.messaging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.FailSafeForm;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.table.NamedNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_ConnectionView extends ConnectionView {

    private final Metadata metadata63;
    private final Metadata metadata62;
    private final Metadata metadata64;
    private final Metadata metadata60;
    private final Metadata metadata58;
    private final Metadata metadata55;
    private final Metadata metadata61;
    private final Metadata metadata59;
    private final Metadata metadata56;
    private final Metadata metadata57;
    private final Metadata metadata54;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_ConnectionView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata63Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/connection-factory=*");
        this.metadata63 = mbuiContext.metadataRegistry().lookup(metadata63Template);
        AddressTemplate metadata62Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/connector-service=*");
        this.metadata62 = mbuiContext.metadataRegistry().lookup(metadata62Template);
        AddressTemplate metadata64Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/pooled-connection-factory=*");
        this.metadata64 = mbuiContext.metadataRegistry().lookup(metadata64Template);
        AddressTemplate metadata60Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/http-connector=*");
        this.metadata60 = mbuiContext.metadataRegistry().lookup(metadata60Template);
        AddressTemplate metadata58Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/connector=*");
        this.metadata58 = mbuiContext.metadataRegistry().lookup(metadata58Template);
        AddressTemplate metadata55Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/in-vm-acceptor=*");
        this.metadata55 = mbuiContext.metadataRegistry().lookup(metadata55Template);
        AddressTemplate metadata61Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/remote-connector=*");
        this.metadata61 = mbuiContext.metadataRegistry().lookup(metadata61Template);
        AddressTemplate metadata59Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/in-vm-connector=*");
        this.metadata59 = mbuiContext.metadataRegistry().lookup(metadata59Template);
        AddressTemplate metadata56Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/http-acceptor=*");
        this.metadata56 = mbuiContext.metadataRegistry().lookup(metadata56Template);
        AddressTemplate metadata57Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/remote-acceptor=*");
        this.metadata57 = mbuiContext.metadataRegistry().lookup(metadata57Template);
        AddressTemplate metadata54Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/acceptor=*");
        this.metadata54 = mbuiContext.metadataRegistry().lookup(metadata54Template);
        this.handlebarElements = new HashMap<>();

        acceptorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("messaging-acceptor-form", metadata54)
            .include("factory-class", "socket-binding", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.ACCEPTOR, form, changedValues))
            .build();
        acceptorForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        inVmAcceptorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("messaging-in-vm-acceptor-form", metadata55)
            .include("server-id", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.IN_VM_ACCEPTOR, form, changedValues))
            .build();
        httpAcceptorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("messaging-http-acceptor-form", metadata56)
            .include("http-listener", "upgrade-legacy", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.HTTP_ACCEPTOR, form, changedValues))
            .build();
        httpAcceptorForm.getFormItem("http-listener").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=undertow/server=*/http-listener=*")));
        remoteAcceptorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("messaging-remote-acceptor-form", metadata57)
            .include("socket-binding", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.REMOTE_ACCEPTOR, form, changedValues))
            .build();
        remoteAcceptorForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        connectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("messaging-connector-form", metadata58)
            .include("factory-class", "socket-binding", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.CONNECTOR, form, changedValues))
            .build();
        connectorForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        inVmConnectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("messaging-in-vm-connector-form", metadata59)
            .include("server-id", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.IN_VM_CONNECTOR, form, changedValues))
            .build();
        httpConnectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("messaging-http-connector-form", metadata60)
            .include("endpoint", "socket-binding", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.HTTP_CONNECTOR, form, changedValues))
            .build();
        httpConnectorForm.getFormItem("endpoint").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/http-acceptor=*")));
        httpConnectorForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        remoteConnectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("messaging-remote-connector-form", metadata61)
            .include("socket-binding", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.REMOTE_CONNECTOR, form, changedValues))
            .build();
        remoteConnectorForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        connectorServiceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("messaging-connector-service-form", metadata62)
            .include("factory-class", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.CONNECTOR_SERVICE, form, changedValues))
            .build();
        connectionFactoryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("messaging-connection-factory-form", metadata63)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.CONNECTION_FACTORY, form, changedValues))
            .build();
        pooledConnectionFactoryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("messaging-pooled-connection-factory-form", metadata64)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.POOLED_CONNECTION_FACTORY, form, changedValues))
            .build();

        Options<org.jboss.hal.dmr.model.NamedNode> acceptorTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata54)
            .button(mbuiContext.resources().constants().add(), (event, api) -> presenter.add(ServerSubResource.ACCEPTOR))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> presenter.remove(ServerSubResource.ACCEPTOR, api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        acceptorTable = new NamedNodeTable<>("messaging-acceptor-table", acceptorTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> inVmAcceptorTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata55)
            .button(mbuiContext.resources().constants().add(), (event, api) -> presenter.add(ServerSubResource.IN_VM_ACCEPTOR))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> presenter.remove(ServerSubResource.IN_VM_ACCEPTOR, api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("server-id")
            .build();
        inVmAcceptorTable = new NamedNodeTable<>("messaging-in-vm-acceptor-table", inVmAcceptorTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> httpAcceptorTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata56)
            .button(mbuiContext.resources().constants().add(), (event, api) -> presenter.addHttp(ServerSubResource.HTTP_ACCEPTOR))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> presenter.remove(ServerSubResource.HTTP_ACCEPTOR, api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        httpAcceptorTable = new NamedNodeTable<>("messaging-http-acceptor-table", httpAcceptorTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> remoteAcceptorTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata57)
            .button(mbuiContext.resources().constants().add(), (event, api) -> presenter.addRemote(ServerSubResource.REMOTE_ACCEPTOR))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> presenter.remove(ServerSubResource.REMOTE_ACCEPTOR, api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        remoteAcceptorTable = new NamedNodeTable<>("messaging-remote-acceptor-table", remoteAcceptorTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> connectorTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata58)
            .button(mbuiContext.resources().constants().add(), (event, api) -> presenter.add(ServerSubResource.CONNECTOR))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> presenter.remove(ServerSubResource.CONNECTOR, api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        connectorTable = new NamedNodeTable<>("messaging-connector-table", connectorTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> inVmConnectorTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata59)
            .button(mbuiContext.resources().constants().add(), (event, api) -> presenter.add(ServerSubResource.IN_VM_CONNECTOR))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> presenter.remove(ServerSubResource.IN_VM_CONNECTOR, api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("server-id")
            .build();
        inVmConnectorTable = new NamedNodeTable<>("messaging-in-vm-connector-table", inVmConnectorTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> httpConnectorTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata60)
            .button(mbuiContext.resources().constants().add(), (event, api) -> presenter.addHttp(ServerSubResource.HTTP_CONNECTOR))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> presenter.remove(ServerSubResource.HTTP_CONNECTOR, api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        httpConnectorTable = new NamedNodeTable<>("messaging-http-connector-table", httpConnectorTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> remoteConnectorTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata61)
            .button(mbuiContext.resources().constants().add(), (event, api) -> presenter.addRemote(ServerSubResource.REMOTE_CONNECTOR))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> presenter.remove(ServerSubResource.REMOTE_CONNECTOR, api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        remoteConnectorTable = new NamedNodeTable<>("messaging-remote-connector-table", remoteConnectorTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> connectorServiceTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata62)
            .button(mbuiContext.resources().constants().add(), (event, api) -> presenter.add(ServerSubResource.CONNECTOR_SERVICE))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> presenter.remove(ServerSubResource.CONNECTOR_SERVICE, api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        connectorServiceTable = new NamedNodeTable<>("messaging-connector-service-table", connectorServiceTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> connectionFactoryTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata63)
            .button(mbuiContext.resources().constants().add(), (event, api) -> presenter.add(ServerSubResource.CONNECTION_FACTORY))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> presenter.remove(ServerSubResource.CONNECTION_FACTORY, api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        connectionFactoryTable = new NamedNodeTable<>("messaging-connection-factory-table", connectionFactoryTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> pooledConnectionFactoryTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata64)
            .button(mbuiContext.resources().constants().add(), (event, api) -> presenter.add(ServerSubResource.POOLED_CONNECTION_FACTORY))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> presenter.remove(ServerSubResource.POOLED_CONNECTION_FACTORY, api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        pooledConnectionFactoryTable = new NamedNodeTable<>("messaging-pooled-connection-factory-table", pooledConnectionFactoryTableOptions);

        navigation = new VerticalNavigation();
        navigation.addPrimary("messaging-acceptor-group-entry", "Acceptor", "fa fa-sign-in");
        Elements.Builder messagingAcceptorEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Generic Acceptor</h1><p>{{metadata54.getDescription().getDescription()}}</p>"))
                    .rememberAs("html156")
                .end()
                .add(acceptorTable)
                .add(acceptorForm)
            .end();
        Element messagingAcceptorEntryElement = messagingAcceptorEntryBuilder.build();
        handlebarElements.put("html156", messagingAcceptorEntryBuilder.referenceFor("html156"));
        navigation.addSecondary("messaging-acceptor-group-entry", "messaging-acceptor-entry", "Generic", messagingAcceptorEntryElement);
        Elements.Builder messagingInVmAcceptorEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>In VM Acceptor</h1><p>{{metadata55.getDescription().getDescription()}}</p>"))
                    .rememberAs("html159")
                .end()
                .add(inVmAcceptorTable)
                .add(inVmAcceptorForm)
            .end();
        Element messagingInVmAcceptorEntryElement = messagingInVmAcceptorEntryBuilder.build();
        handlebarElements.put("html159", messagingInVmAcceptorEntryBuilder.referenceFor("html159"));
        navigation.addSecondary("messaging-acceptor-group-entry", "messaging-in-vm-acceptor-entry", "In VM", messagingInVmAcceptorEntryElement);
        Elements.Builder messagingHttpAcceptorEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>HTTP Acceptor</h1><p>{{metadata56.getDescription().getDescription()}}</p>"))
                    .rememberAs("html162")
                .end()
                .add(httpAcceptorTable)
                .add(httpAcceptorForm)
            .end();
        Element messagingHttpAcceptorEntryElement = messagingHttpAcceptorEntryBuilder.build();
        handlebarElements.put("html162", messagingHttpAcceptorEntryBuilder.referenceFor("html162"));
        navigation.addSecondary("messaging-acceptor-group-entry", "messaging-http-acceptor-entry", "HTTP", messagingHttpAcceptorEntryElement);
        Elements.Builder messagingRemoteAcceptorEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remote Acceptor</h1><p>{{metadata57.getDescription().getDescription()}}</p>"))
                    .rememberAs("html165")
                .end()
                .add(remoteAcceptorTable)
                .add(remoteAcceptorForm)
            .end();
        Element messagingRemoteAcceptorEntryElement = messagingRemoteAcceptorEntryBuilder.build();
        handlebarElements.put("html165", messagingRemoteAcceptorEntryBuilder.referenceFor("html165"));
        navigation.addSecondary("messaging-acceptor-group-entry", "messaging-remote-acceptor-entry", "Remote", messagingRemoteAcceptorEntryElement);
        navigation.addPrimary("messaging-connector-group-entry", "Connector", "fa fa-link");
        Elements.Builder messagingConnectorEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Generic Connector</h1><p>{{metadata58.getDescription().getDescription()}}</p>"))
                    .rememberAs("html168")
                .end()
                .add(connectorTable)
                .add(connectorForm)
            .end();
        Element messagingConnectorEntryElement = messagingConnectorEntryBuilder.build();
        handlebarElements.put("html168", messagingConnectorEntryBuilder.referenceFor("html168"));
        navigation.addSecondary("messaging-connector-group-entry", "messaging-connector-entry", "Generic", messagingConnectorEntryElement);
        Elements.Builder messagingInVmConnectorEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>In VM Connector</h1><p>{{metadata59.getDescription().getDescription()}}</p>"))
                    .rememberAs("html171")
                .end()
                .add(inVmConnectorTable)
                .add(inVmConnectorForm)
            .end();
        Element messagingInVmConnectorEntryElement = messagingInVmConnectorEntryBuilder.build();
        handlebarElements.put("html171", messagingInVmConnectorEntryBuilder.referenceFor("html171"));
        navigation.addSecondary("messaging-connector-group-entry", "messaging-in-vm-connector-entry", "In VM", messagingInVmConnectorEntryElement);
        Elements.Builder messagingHttpConnectorEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>HTTP Connector</h1><p>{{metadata60.getDescription().getDescription()}}</p>"))
                    .rememberAs("html174")
                .end()
                .add(httpConnectorTable)
                .add(httpConnectorForm)
            .end();
        Element messagingHttpConnectorEntryElement = messagingHttpConnectorEntryBuilder.build();
        handlebarElements.put("html174", messagingHttpConnectorEntryBuilder.referenceFor("html174"));
        navigation.addSecondary("messaging-connector-group-entry", "messaging-http-connector-entry", "HTTP", messagingHttpConnectorEntryElement);
        Elements.Builder messagingRemoteConnectorEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remote Connector</h1><p>{{metadata61.getDescription().getDescription()}}</p>"))
                    .rememberAs("html177")
                .end()
                .add(remoteConnectorTable)
                .add(remoteConnectorForm)
            .end();
        Element messagingRemoteConnectorEntryElement = messagingRemoteConnectorEntryBuilder.build();
        handlebarElements.put("html177", messagingRemoteConnectorEntryBuilder.referenceFor("html177"));
        navigation.addSecondary("messaging-connector-group-entry", "messaging-remote-connector-entry", "Remote", messagingRemoteConnectorEntryElement);
        Elements.Builder messagingConnectorServiceEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Connector Service</h1><p>{{metadata62.getDescription().getDescription()}}</p>"))
                    .rememberAs("html180")
                .end()
                .add(connectorServiceTable)
                .add(connectorServiceForm)
            .end();
        Element messagingConnectorServiceEntryElement = messagingConnectorServiceEntryBuilder.build();
        handlebarElements.put("html180", messagingConnectorServiceEntryBuilder.referenceFor("html180"));
        navigation.addPrimary("messaging-connector-service-entry", "Connector Service", "pficon pficon-service", messagingConnectorServiceEntryElement);
        Elements.Builder messagingConnectionFactoryEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Connection Factory</h1><p>{{metadata63.getDescription().getDescription()}}</p>"))
                    .rememberAs("html183")
                .end()
                .add(connectionFactoryTable)
                .add(connectionFactoryForm)
            .end();
        Element messagingConnectionFactoryEntryElement = messagingConnectionFactoryEntryBuilder.build();
        handlebarElements.put("html183", messagingConnectionFactoryEntryBuilder.referenceFor("html183"));
        navigation.addPrimary("messaging-connection-factory-entry", "Connection Factory", "fa fa-cubes", messagingConnectionFactoryEntryElement);
        Elements.Builder messagingPooledConnectionFactoryEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Pooled Connection Factory</h1><p>{{metadata64.getDescription().getDescription()}}</p>"))
                    .rememberAs("html186")
                .end()
                .add(pooledConnectionFactoryTable)
                .add(pooledConnectionFactoryForm)
            .end();
        Element messagingPooledConnectionFactoryEntryElement = messagingPooledConnectionFactoryEntryBuilder.build();
        handlebarElements.put("html186", messagingPooledConnectionFactoryEntryBuilder.referenceFor("html186"));
        navigation.addPrimary("messaging-pooled-connection-factory-entry", "Pooled Connection Factory", "pficon pficon-replicator", messagingPooledConnectionFactoryEntryElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        registerAttachable(navigation);
        registerAttachable(acceptorTable);
        registerAttachable(acceptorForm);
        registerAttachable(inVmAcceptorTable);
        registerAttachable(inVmAcceptorForm);
        registerAttachable(httpAcceptorTable);
        registerAttachable(httpAcceptorForm);
        registerAttachable(remoteAcceptorTable);
        registerAttachable(remoteAcceptorForm);
        registerAttachable(connectorTable);
        registerAttachable(connectorForm);
        registerAttachable(inVmConnectorTable);
        registerAttachable(inVmConnectorForm);
        registerAttachable(httpConnectorTable);
        registerAttachable(httpConnectorForm);
        registerAttachable(remoteConnectorTable);
        registerAttachable(remoteConnectorForm);
        registerAttachable(connectorServiceTable);
        registerAttachable(connectorServiceForm);
        registerAttachable(connectionFactoryTable);
        registerAttachable(connectionFactoryForm);
        registerAttachable(pooledConnectionFactoryTable);
        registerAttachable(pooledConnectionFactoryForm);

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            acceptorTable.bindForm(acceptorForm);
            inVmAcceptorTable.bindForm(inVmAcceptorForm);
            httpAcceptorTable.bindForm(httpAcceptorForm);
            remoteAcceptorTable.bindForm(remoteAcceptorForm);
            connectorTable.bindForm(connectorForm);
            inVmConnectorTable.bindForm(inVmConnectorForm);
            httpConnectorTable.bindForm(httpConnectorForm);
            remoteConnectorTable.bindForm(remoteConnectorForm);
            connectorServiceTable.bindForm(connectorServiceForm);
            connectionFactoryTable.bindForm(connectionFactoryForm);
            pooledConnectionFactoryTable.bindForm(pooledConnectionFactoryForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html156"), "{{metadata54.getDescription().getDescription()}}", String.valueOf(metadata54.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html159"), "{{metadata55.getDescription().getDescription()}}", String.valueOf(metadata55.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html162"), "{{metadata56.getDescription().getDescription()}}", String.valueOf(metadata56.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html165"), "{{metadata57.getDescription().getDescription()}}", String.valueOf(metadata57.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html168"), "{{metadata58.getDescription().getDescription()}}", String.valueOf(metadata58.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html171"), "{{metadata59.getDescription().getDescription()}}", String.valueOf(metadata59.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html174"), "{{metadata60.getDescription().getDescription()}}", String.valueOf(metadata60.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html177"), "{{metadata61.getDescription().getDescription()}}", String.valueOf(metadata61.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html180"), "{{metadata62.getDescription().getDescription()}}", String.valueOf(metadata62.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html183"), "{{metadata63.getDescription().getDescription()}}", String.valueOf(metadata63.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html186"), "{{metadata64.getDescription().getDescription()}}", String.valueOf(metadata64.getDescription().getDescription()));
    }
}
