package org.jboss.hal.client.configuration.subsystem.messaging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.FailSafeForm;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.table.NamedNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_ServerView extends ServerView {

    private final Metadata metadata74;
    private final Metadata metadata73;
    private final Metadata metadata75;
    private final Metadata metadata72;
    private final Metadata metadata76;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_ServerView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata74Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/path=bindings-directory");
        this.metadata74 = mbuiContext.metadataRegistry().lookup(metadata74Template);
        AddressTemplate metadata73Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/path=paging-directory");
        this.metadata73 = mbuiContext.metadataRegistry().lookup(metadata73Template);
        AddressTemplate metadata75Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/path=large-messages-directory");
        this.metadata75 = mbuiContext.metadataRegistry().lookup(metadata75Template);
        AddressTemplate metadata72Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*");
        this.metadata72 = mbuiContext.metadataRegistry().lookup(metadata72Template);
        AddressTemplate metadata76Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/path=journal-directory");
        this.metadata76 = mbuiContext.metadataRegistry().lookup(metadata76Template);
        this.handlebarElements = new HashMap<>();

        form = new GroupedForm.Builder<org.jboss.hal.dmr.model.NamedNode>("messaging-server-form", metadata72)
            .attributeGroup("management").end()
            .attributeGroup("security").end()
            .attributeGroup("journal").end()
            .attributeGroup("cluster").end()
            .attributeGroup("message-expiry").end()
            .attributeGroup("transaction").end()
            .attributeGroup("statistics").end()
            .attributeGroup("debug").end()
            .onSave((form, changedValues) -> presenter.saveServer(changedValues))
            .build();
        Form<org.jboss.hal.dmr.ModelNode> failSafe_pagingDirectoryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>(Ids.build("messaging-server-paging-directory-form", Ids.FORM_SUFFIX), metadata73)
            .onSave((form, changedValues) -> saveSingletonForm("Paging Directory", metadata73Template.resolve(mbuiContext.statementContext()), changedValues))
            .build();
        pagingDirectoryForm = new FailSafeForm<>(mbuiContext.dispatcher(),
                () -> new Operation.Builder(READ_RESOURCE_OPERATION, metadata73Template.resolve(mbuiContext.statementContext())).build(),
                failSafe_pagingDirectoryForm,
                () -> addSingleton("messaging-server-paging-directory-form", "Paging Directory", metadata73Template));
        Form<org.jboss.hal.dmr.ModelNode> failSafe_bindingsDirectoryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>(Ids.build("messaging-server-bindings-directory-form", Ids.FORM_SUFFIX), metadata74)
            .onSave((form, changedValues) -> saveSingletonForm("Bindings Directory", metadata74Template.resolve(mbuiContext.statementContext()), changedValues))
            .build();
        bindingsDirectoryForm = new FailSafeForm<>(mbuiContext.dispatcher(),
                () -> new Operation.Builder(READ_RESOURCE_OPERATION, metadata74Template.resolve(mbuiContext.statementContext())).build(),
                failSafe_bindingsDirectoryForm,
                () -> addSingleton("messaging-server-bindings-directory-form", "Bindings Directory", metadata74Template));
        Form<org.jboss.hal.dmr.ModelNode> failSafe_largeMessagesDirectoryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>(Ids.build("messaging-server-large-messages-directory-form", Ids.FORM_SUFFIX), metadata75)
            .onSave((form, changedValues) -> saveSingletonForm("Large Messages Directory", metadata75Template.resolve(mbuiContext.statementContext()), changedValues))
            .build();
        largeMessagesDirectoryForm = new FailSafeForm<>(mbuiContext.dispatcher(),
                () -> new Operation.Builder(READ_RESOURCE_OPERATION, metadata75Template.resolve(mbuiContext.statementContext())).build(),
                failSafe_largeMessagesDirectoryForm,
                () -> addSingleton("messaging-server-large-messages-directory-form", "Large Messages Directory", metadata75Template));
        Form<org.jboss.hal.dmr.ModelNode> failSafe_journalDirectoryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>(Ids.build("messaging-server-journal-directory-form", Ids.FORM_SUFFIX), metadata76)
            .onSave((form, changedValues) -> saveSingletonForm("Journal Directory", metadata76Template.resolve(mbuiContext.statementContext()), changedValues))
            .build();
        journalDirectoryForm = new FailSafeForm<>(mbuiContext.dispatcher(),
                () -> new Operation.Builder(READ_RESOURCE_OPERATION, metadata76Template.resolve(mbuiContext.statementContext())).build(),
                failSafe_journalDirectoryForm,
                () -> addSingleton("messaging-server-journal-directory-form", "Journal Directory", metadata76Template));


        verticalNavigation = new VerticalNavigation();
        Elements.Builder messagingServerEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Messaging Server</h1><p>{{metadata72.getDescription().getDescription()}}</p>"))
                    .rememberAs("html210")
                .end()
                .add(form)
            .end();
        Element messagingServerEntryElement = messagingServerEntryBuilder.build();
        handlebarElements.put("html210", messagingServerEntryBuilder.referenceFor("html210"));
        verticalNavigation.addPrimary("messaging-server-entry", "Configuration", "pficon pficon-settings", messagingServerEntryElement);
        verticalNavigation.addPrimary("messaging-server-directory-entry", "Directories", "pficon pficon-repository");
        Elements.Builder messagingServerPagingDirectoryEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Paging Directory</h1><p>{{metadata73.getDescription().getDescription()}}</p>"))
                    .rememberAs("html212")
                .end()
                .add(pagingDirectoryForm)
            .end();
        Element messagingServerPagingDirectoryEntryElement = messagingServerPagingDirectoryEntryBuilder.build();
        handlebarElements.put("html212", messagingServerPagingDirectoryEntryBuilder.referenceFor("html212"));
        verticalNavigation.addSecondary("messaging-server-directory-entry", "messaging-server-paging-directory-entry", "Paging", messagingServerPagingDirectoryEntryElement);
        Elements.Builder messagingServerBindingsDirectoryEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Bindings Directory</h1><p>{{metadata74.getDescription().getDescription()}}</p>"))
                    .rememberAs("html214")
                .end()
                .add(bindingsDirectoryForm)
            .end();
        Element messagingServerBindingsDirectoryEntryElement = messagingServerBindingsDirectoryEntryBuilder.build();
        handlebarElements.put("html214", messagingServerBindingsDirectoryEntryBuilder.referenceFor("html214"));
        verticalNavigation.addSecondary("messaging-server-directory-entry", "messaging-server-bindings-directory-entry", "Bindings", messagingServerBindingsDirectoryEntryElement);
        Elements.Builder messagingServerLargeMessagesDirectoryEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Large Messages Directory</h1><p>{{metadata75.getDescription().getDescription()}}</p>"))
                    .rememberAs("html216")
                .end()
                .add(largeMessagesDirectoryForm)
            .end();
        Element messagingServerLargeMessagesDirectoryEntryElement = messagingServerLargeMessagesDirectoryEntryBuilder.build();
        handlebarElements.put("html216", messagingServerLargeMessagesDirectoryEntryBuilder.referenceFor("html216"));
        verticalNavigation.addSecondary("messaging-server-directory-entry", "messaging-server-large-messages-directory-entry", "Large Messages", messagingServerLargeMessagesDirectoryEntryElement);
        Elements.Builder messagingServerJournalDirectoryEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Journal Directory</h1><p>{{metadata76.getDescription().getDescription()}}</p>"))
                    .rememberAs("html218")
                .end()
                .add(journalDirectoryForm)
            .end();
        Element messagingServerJournalDirectoryEntryElement = messagingServerJournalDirectoryEntryBuilder.build();
        handlebarElements.put("html218", messagingServerJournalDirectoryEntryBuilder.referenceFor("html218"));
        verticalNavigation.addSecondary("messaging-server-directory-entry", "messaging-server-journal-directory-entry", "Journal", messagingServerJournalDirectoryEntryElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(verticalNavigation.panes())
                .end()
            .end();

        registerAttachable(verticalNavigation);
        registerAttachable(form);
        registerAttachable(pagingDirectoryForm);
        registerAttachable(bindingsDirectoryForm);
        registerAttachable(largeMessagesDirectoryForm);
        registerAttachable(journalDirectoryForm);

        Element root = layoutBuilder.build();
        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();


        TemplateUtil.replaceHandlebar(handlebarElements.get("html210"), "{{metadata72.getDescription().getDescription()}}", String.valueOf(metadata72.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html212"), "{{metadata73.getDescription().getDescription()}}", String.valueOf(metadata73.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html214"), "{{metadata74.getDescription().getDescription()}}", String.valueOf(metadata74.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html216"), "{{metadata75.getDescription().getDescription()}}", String.valueOf(metadata75.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html218"), "{{metadata76.getDescription().getDescription()}}", String.valueOf(metadata76.getDescription().getDescription()));
    }
}
