package org.jboss.hal.client.configuration.subsystem.remoting;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.FailSafeForm;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.table.NamedNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_RemotingView extends RemotingView {

    private final Metadata metadata83;
    private final Metadata metadata81;
    private final Metadata metadata80;
    private final Metadata metadata79;
    private final Metadata metadata82;
    private final Metadata metadata84;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_RemotingView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata83Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/outbound-connection=*");
        this.metadata83 = mbuiContext.metadataRegistry().lookup(metadata83Template);
        AddressTemplate metadata81Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/http-connector=*");
        this.metadata81 = mbuiContext.metadataRegistry().lookup(metadata81Template);
        AddressTemplate metadata80Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/connector=*");
        this.metadata80 = mbuiContext.metadataRegistry().lookup(metadata80Template);
        AddressTemplate metadata79Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/configuration=endpoint");
        this.metadata79 = mbuiContext.metadataRegistry().lookup(metadata79Template);
        AddressTemplate metadata82Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/local-outbound-connection=*");
        this.metadata82 = mbuiContext.metadataRegistry().lookup(metadata82Template);
        AddressTemplate metadata84Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/remote-outbound-connection=*");
        this.metadata84 = mbuiContext.metadataRegistry().lookup(metadata84Template);
        this.handlebarElements = new HashMap<>();

        endpointConfigurationForm = new GroupedForm.Builder<org.jboss.hal.dmr.ModelNode>("remoting-endpoint-configuration", metadata79)
            .customGroup("remoting-endpoint-configuration-attributes", mbuiContext.resources().constants().attributes())
                .include("buffer-region-size", "heartbeat-interval", "receive-buffer-size", "receive-window-size", "send-buffer-size", "server-name", "transmit-window-size", "worker")
            .end()
            .customGroup("remoting-endpoint-configuration-security", mbuiContext.resources().constants().security())
                .include("auth-realm", "authentication-retries", "authorize-id", "sasl-protocol")
            .end()
            .customGroup("remoting-endpoint-configuration-channels", "Channels")
                .include("max-inbound-channels", "max-inbound-message-size", "max-inbound-messages", "max-outbound-channels", "max-outbound-message-size", "max-outbound-messages")
            .end()
            .onSave((form, changedValues) -> saveSingletonForm("Endpoint Configuration", metadata79Template.resolve(mbuiContext.statementContext()), changedValues))
            .build();
        localOutboundForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("remoting-local-outbound-form", metadata82)
            .unboundFormItem(new org.jboss.hal.ballroom.form.PropertiesItem("property"), 0)
            .include("outbound-socket-binding-ref")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveLocalOutbound(form, changedValues))
            .build();
        localOutboundForm.getFormItem("outbound-socket-binding-ref").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/local-destination-outbound-socket-binding=*")));
        outboundForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("remoting-outbound-form", metadata83)
            .unboundFormItem(new org.jboss.hal.ballroom.form.PropertiesItem("property"), 0)
            .include("uri")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveOutbound(form, changedValues))
            .build();
        remoteOutboundForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("remoting-remote-outbound-form", metadata84)
            .include("outbound-socket-binding-ref")
            .unboundFormItem(new org.jboss.hal.ballroom.form.PropertiesItem("property"), 1)
            .include("protocol")
            .include("security-realm")
            .include("username")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveRemoteOutbound(form, changedValues))
            .build();
        remoteOutboundForm.getFormItem("outbound-socket-binding-ref").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/remote-destination-outbound-socket-binding=*")));

        Options<org.jboss.hal.dmr.model.NamedNode> connectorTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata80)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("remoting-connector-table", Ids.ADD_SUFFIX), "Connector",
                metadata80Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Connector", metadata80Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        connectorTable = new NamedNodeTable<>("remoting-connector-table", connectorTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> httpConnectorTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata81)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("remoting-http-connector-table", Ids.ADD_SUFFIX), "HTTP Connector",
                metadata81Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("HTTP Connector", metadata81Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        httpConnectorTable = new NamedNodeTable<>("remoting-http-connector-table", httpConnectorTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> localOutboundTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata82)
            .button(mbuiContext.resources().constants().add(), (event, api) -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("remoting-local-outbound-table", Ids.ADD_SUFFIX),
                    mbuiContext.resources().messages().addResourceTitle("Local Outbound"),
                    metadata82,
                    asList("outbound-socket-binding-ref"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata82Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("Local Outbound", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.getForm().getFormItem("outbound-socket-binding-ref").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/local-destination-outbound-socket-binding=*")));
                dialog.show();
            })
            .button(mbuiContext.tableButtonFactory().remove("Local Outbound", metadata82Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        localOutboundTable = new NamedNodeTable<>("remoting-local-outbound-table", localOutboundTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> outboundTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata83)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("remoting-outbound-table", Ids.ADD_SUFFIX), "Outbound",
                metadata83Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Outbound", metadata83Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        outboundTable = new NamedNodeTable<>("remoting-outbound-table", outboundTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> remoteOutboundTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata84)
            .button(mbuiContext.resources().constants().add(), (event, api) -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("remoting-remote-outbound-table", Ids.ADD_SUFFIX),
                    mbuiContext.resources().messages().addResourceTitle("Remote Outbound"),
                    metadata84,
                    asList("outbound-socket-binding-ref"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata84Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("Remote Outbound", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.getForm().getFormItem("outbound-socket-binding-ref").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/remote-destination-outbound-socket-binding=*")));
                dialog.show();
            })
            .button(mbuiContext.tableButtonFactory().remove("Remote Outbound", metadata84Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        remoteOutboundTable = new NamedNodeTable<>("remoting-remote-outbound-table", remoteOutboundTableOptions);

        navigation = new VerticalNavigation();
        Elements.Builder remotingEndpointConfigurationItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Endpoint Configuration</h1><p>{{metadata79.getDescription().getDescription()}}</p>"))
                    .rememberAs("html226")
                .end()
                .add(endpointConfigurationForm)
            .end();
        Element remotingEndpointConfigurationItemElement = remotingEndpointConfigurationItemBuilder.build();
        handlebarElements.put("html226", remotingEndpointConfigurationItemBuilder.referenceFor("html226"));
        navigation.addPrimary("remoting-endpoint-configuration-item", "Endpoint Configuration", "pficon pficon-settings", remotingEndpointConfigurationItemElement);
        navigation.addPrimary("remoting-remote-connector-item", "Remote Connector", "pficon pficon-network");
        Elements.Builder remotingConnectorSubItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Connector</h1><p>{{metadata80.getDescription().getDescription()}}</p>"))
                    .rememberAs("html228")
                .end()
                .add(connectorTable)
            .end();
        Element remotingConnectorSubItemElement = remotingConnectorSubItemBuilder.build();
        handlebarElements.put("html228", remotingConnectorSubItemBuilder.referenceFor("html228"));
        navigation.addSecondary("remoting-remote-connector-item", "remoting-connector-sub-item", "Connector", remotingConnectorSubItemElement);
        Elements.Builder remotingHttpConnectorSubItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>HTTP Connector</h1><p>{{metadata81.getDescription().getDescription()}}</p>"))
                    .rememberAs("html230")
                .end()
                .add(httpConnectorTable)
            .end();
        Element remotingHttpConnectorSubItemElement = remotingHttpConnectorSubItemBuilder.build();
        handlebarElements.put("html230", remotingHttpConnectorSubItemBuilder.referenceFor("html230"));
        navigation.addSecondary("remoting-remote-connector-item", "remoting-http-connector-sub-item", "HTTP Connector", remotingHttpConnectorSubItemElement);
        navigation.addPrimary("remoting-outbound-connection-item", "Outbound Connection", "pficon pficon-service");
        Elements.Builder remotingLocalOutboundSubItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Local Outbound</h1><p>{{metadata82.getDescription().getDescription()}}</p>"))
                    .rememberAs("html232")
                .end()
                .add(localOutboundTable)
                .add(localOutboundForm)
            .end();
        Element remotingLocalOutboundSubItemElement = remotingLocalOutboundSubItemBuilder.build();
        handlebarElements.put("html232", remotingLocalOutboundSubItemBuilder.referenceFor("html232"));
        navigation.addSecondary("remoting-outbound-connection-item", "remoting-local-outbound-sub-item", "Local Outbound", remotingLocalOutboundSubItemElement);
        Elements.Builder remotingOutboundSubItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Outbound</h1><p>{{metadata83.getDescription().getDescription()}}</p>"))
                    .rememberAs("html235")
                .end()
                .add(outboundTable)
                .add(outboundForm)
            .end();
        Element remotingOutboundSubItemElement = remotingOutboundSubItemBuilder.build();
        handlebarElements.put("html235", remotingOutboundSubItemBuilder.referenceFor("html235"));
        navigation.addSecondary("remoting-outbound-connection-item", "remoting-outbound-sub-item", "Outbound", remotingOutboundSubItemElement);
        Elements.Builder remotingRemoteOutboundSubItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remote Outbound</h1><p>{{metadata84.getDescription().getDescription()}}</p>"))
                    .rememberAs("html238")
                .end()
                .add(remoteOutboundTable)
                .add(remoteOutboundForm)
            .end();
        Element remotingRemoteOutboundSubItemElement = remotingRemoteOutboundSubItemBuilder.build();
        handlebarElements.put("html238", remotingRemoteOutboundSubItemBuilder.referenceFor("html238"));
        navigation.addSecondary("remoting-outbound-connection-item", "remoting-remote-outbound-sub-item", "Remote Outbound", remotingRemoteOutboundSubItemElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        registerAttachable(navigation);
        registerAttachable(endpointConfigurationForm);
        registerAttachable(connectorTable);
        registerAttachable(httpConnectorTable);
        registerAttachable(localOutboundTable);
        registerAttachable(localOutboundForm);
        registerAttachable(outboundTable);
        registerAttachable(outboundForm);
        registerAttachable(remoteOutboundTable);
        registerAttachable(remoteOutboundForm);

        Element root = layoutBuilder.build();
        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            localOutboundTable.bindForm(localOutboundForm);
            outboundTable.bindForm(outboundForm);
            remoteOutboundTable.bindForm(remoteOutboundForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html226"), "{{metadata79.getDescription().getDescription()}}", String.valueOf(metadata79.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html228"), "{{metadata80.getDescription().getDescription()}}", String.valueOf(metadata80.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html230"), "{{metadata81.getDescription().getDescription()}}", String.valueOf(metadata81.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html232"), "{{metadata82.getDescription().getDescription()}}", String.valueOf(metadata82.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html235"), "{{metadata83.getDescription().getDescription()}}", String.valueOf(metadata83.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html238"), "{{metadata84.getDescription().getDescription()}}", String.valueOf(metadata84.getDescription().getDescription()));
    }
}
