package org.jboss.hal.client.configuration.subsystem.security;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.FailSafeForm;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.table.NamedNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_SecurityView extends SecurityView {

    private final Metadata metadata98;
    private final Metadata metadata101;
    private final Metadata metadata99;
    private final Metadata metadata97;
    private final Metadata metadata102;
    private final Metadata metadata100;
    private final Metadata metadata96;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_SecurityView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata98Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-key-store=*");
        this.metadata98 = mbuiContext.metadataRegistry().lookup(metadata98Template);
        AddressTemplate metadata101Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-trust-store=*");
        this.metadata101 = mbuiContext.metadataRegistry().lookup(metadata101Template);
        AddressTemplate metadata99Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-realm=*");
        this.metadata99 = mbuiContext.metadataRegistry().lookup(metadata99Template);
        AddressTemplate metadata97Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-key-manager=*");
        this.metadata97 = mbuiContext.metadataRegistry().lookup(metadata97Template);
        AddressTemplate metadata102Template = AddressTemplate.of("/{selected.profile}/subsystem=security/vault=classic");
        this.metadata102 = mbuiContext.metadataRegistry().lookup(metadata102Template);
        AddressTemplate metadata100Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-trust-manager=*");
        this.metadata100 = mbuiContext.metadataRegistry().lookup(metadata100Template);
        AddressTemplate metadata96Template = AddressTemplate.of("/{selected.profile}/subsystem=security");
        this.metadata96 = mbuiContext.metadataRegistry().lookup(metadata96Template);
        this.handlebarElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("security-configuration-form", metadata96)
            .onSave((form, changedValues) -> saveSingletonForm("Configuration", metadata96Template.resolve(mbuiContext.statementContext()), changedValues))
            .build();
        keyManagerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("security-elytron-key-manager-form", metadata97)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Key Manager", name, metadata97Template.resolve(mbuiContext.statementContext(), name), changedValues);
            })
            .build();
        keyStoreForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("security-elytron-key-store-form", metadata98)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Key Store", name, metadata98Template.resolve(mbuiContext.statementContext(), name), changedValues);
            })
            .build();
        realmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("security-elytron-realm-form", metadata99)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Realm", name, metadata99Template.resolve(mbuiContext.statementContext(), name), changedValues);
            })
            .build();
        trustManagerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("security-elytron-trust-manager-form", metadata100)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Trust Manager", name, metadata100Template.resolve(mbuiContext.statementContext(), name), changedValues);
            })
            .build();
        trustStoreForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("security-elytron-trust-store-form", metadata101)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Trust Store", name, metadata101Template.resolve(mbuiContext.statementContext(), name), changedValues);
            })
            .build();
        Form<org.jboss.hal.dmr.ModelNode> failSafe_vaultForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>(Ids.build("security-vault-form", Ids.FORM_SUFFIX), metadata102)
            .onSave((form, changedValues) -> saveSingletonForm("Vault", metadata102Template.resolve(mbuiContext.statementContext()), changedValues))
            .build();
        vaultForm = new FailSafeForm<>(mbuiContext.dispatcher(),
                () -> new Operation.Builder(READ_RESOURCE_OPERATION, metadata102Template.resolve(mbuiContext.statementContext())).build(),
                failSafe_vaultForm,
                () -> addSingleton("security-vault-form", "Vault", metadata102Template));

        Options<org.jboss.hal.dmr.model.NamedNode> keyManagerTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata97)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-key-manager-table", Ids.ADD_SUFFIX), "Elytron Key Manager",
                metadata97Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Key Manager", metadata97Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();
        keyManagerTable = new NamedNodeTable<>("security-elytron-key-manager-table", keyManagerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> keyStoreTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata98)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-key-store-table", Ids.ADD_SUFFIX), "Elytron Key Store",
                metadata98Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Key Store", metadata98Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();
        keyStoreTable = new NamedNodeTable<>("security-elytron-key-store-table", keyStoreTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> realmTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata99)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-realm-table", Ids.ADD_SUFFIX), "Elytron Realm",
                metadata99Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Realm", metadata99Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jaas-config")
            .build();
        realmTable = new NamedNodeTable<>("security-elytron-realm-table", realmTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> trustManagerTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata100)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-trust-manager-table", Ids.ADD_SUFFIX), "Elytron Trust Manager",
                metadata100Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Trust Manager", metadata100Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();
        trustManagerTable = new NamedNodeTable<>("security-elytron-trust-manager-table", trustManagerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> trustStoreTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata101)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-trust-store-table", Ids.ADD_SUFFIX), "Elytron Trust Store",
                metadata101Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Trust Store", metadata101Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();
        trustStoreTable = new NamedNodeTable<>("security-elytron-trust-store-table", trustStoreTableOptions);

        navigation = new VerticalNavigation();
        Elements.Builder securityConfigurationItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>{{metadata96.getDescription().getDescription()}}</p>"))
                    .rememberAs("html274")
                .end()
                .add(configurationForm)
            .end();
        Element securityConfigurationItemElement = securityConfigurationItemBuilder.build();
        handlebarElements.put("html274", securityConfigurationItemBuilder.referenceFor("html274"));
        navigation.addPrimary("security-configuration-item", "Configuration", "pficon pficon-settings", securityConfigurationItemElement);
        Elements.Builder securityElytronKeyManagerItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Key Manager</h1><p>{{metadata97.getDescription().getDescription()}}</p>"))
                    .rememberAs("html276")
                .end()
                .add(keyManagerTable)
                .add(keyManagerForm)
            .end();
        Element securityElytronKeyManagerItemElement = securityElytronKeyManagerItemBuilder.build();
        handlebarElements.put("html276", securityElytronKeyManagerItemBuilder.referenceFor("html276"));
        navigation.addPrimary("security-elytron-key-manager-item", "Key Manager", "fa fa-key", securityElytronKeyManagerItemElement);
        Elements.Builder securityElytronKeyStoreItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Key Store</h1><p>{{metadata98.getDescription().getDescription()}}</p>"))
                    .rememberAs("html279")
                .end()
                .add(keyStoreTable)
                .add(keyStoreForm)
            .end();
        Element securityElytronKeyStoreItemElement = securityElytronKeyStoreItemBuilder.build();
        handlebarElements.put("html279", securityElytronKeyStoreItemBuilder.referenceFor("html279"));
        navigation.addPrimary("security-elytron-key-store-item", "Key Store", "fa fa-key", securityElytronKeyStoreItemElement);
        Elements.Builder securityElytronRealmItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Realm</h1><p>{{metadata99.getDescription().getDescription()}}</p>"))
                    .rememberAs("html282")
                .end()
                .add(realmTable)
                .add(realmForm)
            .end();
        Element securityElytronRealmItemElement = securityElytronRealmItemBuilder.build();
        handlebarElements.put("html282", securityElytronRealmItemBuilder.referenceFor("html282"));
        navigation.addPrimary("security-elytron-realm-item", "Realm", "fa fa-map", securityElytronRealmItemElement);
        Elements.Builder securityElytronTrustManagerItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Trust Manager</h1><p>{{metadata100.getDescription().getDescription()}}</p>"))
                    .rememberAs("html285")
                .end()
                .add(trustManagerTable)
                .add(trustManagerForm)
            .end();
        Element securityElytronTrustManagerItemElement = securityElytronTrustManagerItemBuilder.build();
        handlebarElements.put("html285", securityElytronTrustManagerItemBuilder.referenceFor("html285"));
        navigation.addPrimary("security-elytron-trust-manager-item", "Trust Manager", "fa fa-lock", securityElytronTrustManagerItemElement);
        Elements.Builder securityElytronTrustStoreItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Trust Store</h1><p>{{metadata101.getDescription().getDescription()}}</p>"))
                    .rememberAs("html288")
                .end()
                .add(trustStoreTable)
                .add(trustStoreForm)
            .end();
        Element securityElytronTrustStoreItemElement = securityElytronTrustStoreItemBuilder.build();
        handlebarElements.put("html288", securityElytronTrustStoreItemBuilder.referenceFor("html288"));
        navigation.addPrimary("security-elytron-trust-store-item", "Trust Store", "fa fa-lock", securityElytronTrustStoreItemElement);
        Elements.Builder securityVaultItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Vault</h1><p>{{metadata102.getDescription().getDescription()}}</p>"))
                    .rememberAs("html291")
                .end()
                .add(vaultForm)
            .end();
        Element securityVaultItemElement = securityVaultItemBuilder.build();
        handlebarElements.put("html291", securityVaultItemBuilder.referenceFor("html291"));
        navigation.addPrimary("security-vault-item", "Vault", "fa fa-shield", securityVaultItemElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(keyManagerTable);
        registerAttachable(keyManagerForm);
        registerAttachable(keyStoreTable);
        registerAttachable(keyStoreForm);
        registerAttachable(realmTable);
        registerAttachable(realmForm);
        registerAttachable(trustManagerTable);
        registerAttachable(trustManagerForm);
        registerAttachable(trustStoreTable);
        registerAttachable(trustStoreForm);
        registerAttachable(vaultForm);

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            keyManagerTable.bindForm(keyManagerForm);
            keyStoreTable.bindForm(keyStoreForm);
            realmTable.bindForm(realmForm);
            trustManagerTable.bindForm(trustManagerForm);
            trustStoreTable.bindForm(trustStoreForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html274"), "{{metadata96.getDescription().getDescription()}}", String.valueOf(metadata96.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html276"), "{{metadata97.getDescription().getDescription()}}", String.valueOf(metadata97.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html279"), "{{metadata98.getDescription().getDescription()}}", String.valueOf(metadata98.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html282"), "{{metadata99.getDescription().getDescription()}}", String.valueOf(metadata99.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html285"), "{{metadata100.getDescription().getDescription()}}", String.valueOf(metadata100.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html288"), "{{metadata101.getDescription().getDescription()}}", String.valueOf(metadata101.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html291"), "{{metadata102.getDescription().getDescription()}}", String.valueOf(metadata102.getDescription().getDescription()));
    }
}
