package org.jboss.hal.client.configuration.subsystem.undertow;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.FailSafeForm;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.table.NamedNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_FilterView extends FilterView {

    private final Metadata metadata107;
    private final Metadata metadata106;
    private final Metadata metadata109;
    private final Metadata metadata105;
    private final Metadata metadata111;
    private final Metadata metadata108;
    private final Metadata metadata112;
    private final Metadata metadata110;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_FilterView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata107Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/expression-filter=*");
        this.metadata107 = mbuiContext.metadataRegistry().lookup(metadata107Template);
        AddressTemplate metadata106Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/error-page=*");
        this.metadata106 = mbuiContext.metadataRegistry().lookup(metadata106Template);
        AddressTemplate metadata109Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/mod-cluster=*");
        this.metadata109 = mbuiContext.metadataRegistry().lookup(metadata109Template);
        AddressTemplate metadata105Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/custom-filter=*");
        this.metadata105 = mbuiContext.metadataRegistry().lookup(metadata105Template);
        AddressTemplate metadata111Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/response-header=*");
        this.metadata111 = mbuiContext.metadataRegistry().lookup(metadata111Template);
        AddressTemplate metadata108Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/gzip=*");
        this.metadata108 = mbuiContext.metadataRegistry().lookup(metadata108Template);
        AddressTemplate metadata112Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/rewrite=*");
        this.metadata112 = mbuiContext.metadataRegistry().lookup(metadata112Template);
        AddressTemplate metadata110Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/request-limit=*");
        this.metadata110 = mbuiContext.metadataRegistry().lookup(metadata110Template);
        this.handlebarElements = new HashMap<>();

        customFilterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("undertow-custom-filter-form", metadata105)
            .include("class-name")
            .include("module")
            .include("parameters")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 3)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Custom Filter", name, metadata105Template.resolve(mbuiContext.statementContext(), name), changedValues);
            })
            .build();
        errorPageForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("undertow-error-page-form", metadata106)
            .include("code")
            .include("path")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 2)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Error Page", name, metadata106Template.resolve(mbuiContext.statementContext(), name), changedValues);
            })
            .build();
        expressionFilterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("undertow-expression-filter-form", metadata107)
            .include("expression")
            .include("module")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 2)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Expression Filter", name, metadata107Template.resolve(mbuiContext.statementContext(), name), changedValues);
            })
            .build();
        gzipForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("undertow-gzip-form", metadata108)
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 0)
            .unsorted()
            .onSave((form, changedValues) -> noop())
            .build();
        modClusterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("undertow-mod-cluster-form", metadata109)
            .include("advertise-frequency")
            .include("advertise-path")
            .include("advertise-protocol")
            .include("advertise-socket-binding")
            .include("broken-node-timeout")
            .include("cached-connections-per-thread")
            .include("connection-idle-timeout")
            .include("connections-per-thread")
            .include("enable-http2")
            .include("health-check-interval")
            .include("http2-enable-push")
            .include("http2-header-table-size")
            .include("http2-initial-window-size")
            .include("http2-max-concurrent-streams")
            .include("http2-max-frame-size")
            .include("http2-max-header-list-size")
            .include("management-access-predicate")
            .include("management-socket-binding")
            .include("max-ajp-packet-size")
            .include("max-request-time")
            .include("max-retries")
            .include("request-queue-size")
            .include("security-key")
            .include("security-realm")
            .include("ssl-context")
            .include("use-alias")
            .include("worker")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 27)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Mod Cluster", name, metadata109Template.resolve(mbuiContext.statementContext(), name), changedValues);
            })
            .build();
        requestLimitForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("undertow-request-limit-form", metadata110)
            .include("max-concurrent-requests")
            .include("queue-size")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 2)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Request Limit", name, metadata110Template.resolve(mbuiContext.statementContext(), name), changedValues);
            })
            .build();
        responseHeaderForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("undertow-response-header-form", metadata111)
            .include("header-name")
            .include("header-value")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 2)
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveResponseHeader(form, changedValues))
            .build();
        rewriteForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("undertow-rewrite-form", metadata112)
            .include("redirect")
            .include("target")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 2)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Rewrite", name, metadata112Template.resolve(mbuiContext.statementContext(), name), changedValues);
            })
            .build();

        Options<org.jboss.hal.dmr.model.NamedNode> customFilterTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata105)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-custom-filter-table", Ids.ADD_SUFFIX), "Custom Filter",
                metadata105Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Custom Filter", metadata105Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        customFilterTable = new NamedNodeTable<>("undertow-custom-filter-table", customFilterTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> errorPageTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata106)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-error-page-table", Ids.ADD_SUFFIX), "Error Page",
                metadata106Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Error Page", metadata106Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("code")
            .build();
        errorPageTable = new NamedNodeTable<>("undertow-error-page-table", errorPageTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> expressionFilterTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata107)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-expression-filter-table", Ids.ADD_SUFFIX), "Expression Filter",
                metadata107Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Expression Filter", metadata107Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("expression")
            .build();
        expressionFilterTable = new NamedNodeTable<>("undertow-expression-filter-table", expressionFilterTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> gzipTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata108)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-gzip-table", Ids.ADD_SUFFIX), "GZip",
                metadata108Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("GZip", metadata108Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        gzipTable = new NamedNodeTable<>("undertow-gzip-table", gzipTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> modClusterTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata109)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-mod-cluster-table", Ids.ADD_SUFFIX), "Mod Cluster",
                metadata109Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Mod Cluster", metadata109Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("management-socket-binding")
            .build();
        modClusterTable = new NamedNodeTable<>("undertow-mod-cluster-table", modClusterTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> requestLimitTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata110)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-request-limit-table", Ids.ADD_SUFFIX), "Request Limit",
                metadata110Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Request Limit", metadata110Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("max-concurrent-requests")
            .build();
        requestLimitTable = new NamedNodeTable<>("undertow-request-limit-table", requestLimitTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> responseHeaderTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata111)
            .button(mbuiContext.resources().constants().add(), (event, api) -> presenter.addResponseHeader())
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> presenter.removeResponseHeader(api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.get("header-name").asString())
            .column("value", (cell, type, row, meta) -> row.get("header-value").asString())
            .build();
        responseHeaderTable = new NamedNodeTable<>("undertow-response-header-table", responseHeaderTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> rewriteTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata112)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-rewrite-table", Ids.ADD_SUFFIX), "Rewrite",
                metadata112Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Rewrite", metadata112Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("target")
            .build();
        rewriteTable = new NamedNodeTable<>("undertow-rewrite-table", rewriteTableOptions);

        navigation = new VerticalNavigation();
        Elements.Builder undertowCustomFilterItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Filter</h1><p>{{metadata105.getDescription().getDescription()}}</p>"))
                    .rememberAs("html308")
                .end()
                .add(customFilterTable)
                .add(customFilterForm)
            .end();
        Element undertowCustomFilterItemElement = undertowCustomFilterItemBuilder.build();
        handlebarElements.put("html308", undertowCustomFilterItemBuilder.referenceFor("html308"));
        navigation.addPrimary("undertow-custom-filter-item", "Custom Filter", "fa fa-file-o", undertowCustomFilterItemElement);
        Elements.Builder undertowErrorPageItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Error Page</h1><p>{{metadata106.getDescription().getDescription()}}</p>"))
                    .rememberAs("html311")
                .end()
                .add(errorPageTable)
                .add(errorPageForm)
            .end();
        Element undertowErrorPageItemElement = undertowErrorPageItemBuilder.build();
        handlebarElements.put("html311", undertowErrorPageItemBuilder.referenceFor("html311"));
        navigation.addPrimary("undertow-error-page-item", "Error Page", "fa fa-bug", undertowErrorPageItemElement);
        Elements.Builder undertowExpressionFilterItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Expression Filter</h1><p>{{metadata107.getDescription().getDescription()}}</p>"))
                    .rememberAs("html314")
                .end()
                .add(expressionFilterTable)
                .add(expressionFilterForm)
            .end();
        Element undertowExpressionFilterItemElement = undertowExpressionFilterItemBuilder.build();
        handlebarElements.put("html314", undertowExpressionFilterItemBuilder.referenceFor("html314"));
        navigation.addPrimary("undertow-expression-filter-item", "Expression Filter", "fa fa-terminal", undertowExpressionFilterItemElement);
        Elements.Builder undertowGzipItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>GZip</h1><p>{{metadata108.getDescription().getDescription()}}</p>"))
                    .rememberAs("html317")
                .end()
                .add(gzipTable)
                .add(gzipForm)
            .end();
        Element undertowGzipItemElement = undertowGzipItemBuilder.build();
        handlebarElements.put("html317", undertowGzipItemBuilder.referenceFor("html317"));
        navigation.addPrimary("undertow-gzip-item", "GZip", "fa fa-archive", undertowGzipItemElement);
        Elements.Builder undertowModClusterItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Mod Cluster</h1><p>{{metadata109.getDescription().getDescription()}}</p>"))
                    .rememberAs("html320")
                .end()
                .add(modClusterTable)
                .add(modClusterForm)
            .end();
        Element undertowModClusterItemElement = undertowModClusterItemBuilder.build();
        handlebarElements.put("html320", undertowModClusterItemBuilder.referenceFor("html320"));
        navigation.addPrimary("undertow-mod-cluster-item", "Mod Cluster Filter", "pficon pficon-cluster", undertowModClusterItemElement);
        Elements.Builder undertowRequestLimitItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Request Limit</h1><p>{{metadata110.getDescription().getDescription()}}</p>"))
                    .rememberAs("html323")
                .end()
                .add(requestLimitTable)
                .add(requestLimitForm)
            .end();
        Element undertowRequestLimitItemElement = undertowRequestLimitItemBuilder.build();
        handlebarElements.put("html323", undertowRequestLimitItemBuilder.referenceFor("html323"));
        navigation.addPrimary("undertow-request-limit-item", "Request Limit", "fa fa-ban", undertowRequestLimitItemElement);
        Elements.Builder undertowResponseHeaderItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Response Header</h1><p>{{metadata111.getDescription().getDescription()}}</p>"))
                    .rememberAs("html326")
                .end()
                .add(responseHeaderTable)
                .add(responseHeaderForm)
            .end();
        Element undertowResponseHeaderItemElement = undertowResponseHeaderItemBuilder.build();
        handlebarElements.put("html326", undertowResponseHeaderItemBuilder.referenceFor("html326"));
        navigation.addPrimary("undertow-response-header-item", "Response Header", "fa fa-exchange", undertowResponseHeaderItemElement);
        Elements.Builder undertowRewriteItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Rewrite</h1><p>{{metadata112.getDescription().getDescription()}}</p>"))
                    .rememberAs("html329")
                .end()
                .add(rewriteTable)
                .add(rewriteForm)
            .end();
        Element undertowRewriteItemElement = undertowRewriteItemBuilder.build();
        handlebarElements.put("html329", undertowRewriteItemBuilder.referenceFor("html329"));
        navigation.addPrimary("undertow-rewrite-item", "Rewrite", "fa fa-refresh", undertowRewriteItemElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        registerAttachable(navigation);
        registerAttachable(customFilterTable);
        registerAttachable(customFilterForm);
        registerAttachable(errorPageTable);
        registerAttachable(errorPageForm);
        registerAttachable(expressionFilterTable);
        registerAttachable(expressionFilterForm);
        registerAttachable(gzipTable);
        registerAttachable(gzipForm);
        registerAttachable(modClusterTable);
        registerAttachable(modClusterForm);
        registerAttachable(requestLimitTable);
        registerAttachable(requestLimitForm);
        registerAttachable(responseHeaderTable);
        registerAttachable(responseHeaderForm);
        registerAttachable(rewriteTable);
        registerAttachable(rewriteForm);

        Element root = layoutBuilder.build();
        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            customFilterTable.bindForm(customFilterForm);
            errorPageTable.bindForm(errorPageForm);
            expressionFilterTable.bindForm(expressionFilterForm);
            modClusterTable.bindForm(modClusterForm);
            requestLimitTable.bindForm(requestLimitForm);
            responseHeaderTable.bindForm(responseHeaderForm);
            rewriteTable.bindForm(rewriteForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html308"), "{{metadata105.getDescription().getDescription()}}", String.valueOf(metadata105.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html311"), "{{metadata106.getDescription().getDescription()}}", String.valueOf(metadata106.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html314"), "{{metadata107.getDescription().getDescription()}}", String.valueOf(metadata107.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html317"), "{{metadata108.getDescription().getDescription()}}", String.valueOf(metadata108.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html320"), "{{metadata109.getDescription().getDescription()}}", String.valueOf(metadata109.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html323"), "{{metadata110.getDescription().getDescription()}}", String.valueOf(metadata110.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html326"), "{{metadata111.getDescription().getDescription()}}", String.valueOf(metadata111.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html329"), "{{metadata112.getDescription().getDescription()}}", String.valueOf(metadata112.getDescription().getDescription()));
    }
}
