package org.jboss.hal.ballroom.form;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.web.bindery.event.shared.HandlerRegistration;

import com.google.gwt.event.shared.HasHandlers;

public class ResolveExpressionEvent extends GwtEvent<ResolveExpressionEvent.ResolveExpressionHandler> { 

  java.lang.String expression;

  protected ResolveExpressionEvent() {
    // Possibly for serialization.
  }

  public ResolveExpressionEvent(java.lang.String expression) {
    this.expression = expression;
  }

  public static void fire(HasHandlers source, java.lang.String expression) {
    ResolveExpressionEvent eventInstance = new ResolveExpressionEvent(expression);
    source.fireEvent(eventInstance);
  }

  public static void fire(HasHandlers source, ResolveExpressionEvent eventInstance) {
    source.fireEvent(eventInstance);
  }

  public interface HasResolveExpressionHandlers extends HasHandlers {
    HandlerRegistration addResolveExpressionHandler(ResolveExpressionHandler handler);
  }

  public interface ResolveExpressionHandler extends EventHandler {
    public void onResolveExpression(ResolveExpressionEvent event);
  }

  private static final Type<ResolveExpressionHandler> TYPE = new Type<ResolveExpressionHandler>();

  public static Type<ResolveExpressionHandler> getType() {
    return TYPE;
  }

  @Override
  public Type<ResolveExpressionHandler> getAssociatedType() {
    return TYPE;
  }

  @Override
  protected void dispatch(ResolveExpressionHandler handler) {
    handler.onResolveExpression(this);
  }

  public java.lang.String getExpression(){
    return expression;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj)
        return true;
    if (obj == null)
        return false;
    if (getClass() != obj.getClass())
        return false;
    ResolveExpressionEvent other = (ResolveExpressionEvent) obj;
    if (expression == null) {
      if (other.expression != null)
        return false;
    } else if (!expression.equals(other.expression))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    int hashCode = 23;
    hashCode = (hashCode * 37) + (expression == null ? 1 : expression.hashCode());
    return hashCode;
  }

  @Override
  public String toString() {
    return "ResolveExpressionEvent["
                 + expression
    + "]";
  }
}
