package org.jboss.hal.client.configuration.subsystem.ejb;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.FailSafeForm;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.table.NamedNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_EjbView extends EjbView {

    private final org.jboss.hal.config.Environment environment;
    private final Metadata metadata18;
    private final Metadata metadata15;
    private final Metadata metadata14;
    private final Metadata metadata17;
    private final Metadata metadata16;
    private final Metadata metadata11;
    private final Metadata metadata9;
    private final Metadata metadata13;
    private final Metadata metadata8;
    private final Metadata metadata12;
    private final Metadata metadata10;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_EjbView(MbuiContext mbuiContext, org.jboss.hal.config.Environment environment) {
        super(mbuiContext);

        this.environment = environment;
        AddressTemplate metadata18Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/mdb-delivery-group=*");
        this.metadata18 = mbuiContext.metadataRegistry().lookup(metadata18Template);
        AddressTemplate metadata15Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=iiop");
        this.metadata15 = mbuiContext.metadataRegistry().lookup(metadata15Template);
        AddressTemplate metadata14Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=async");
        this.metadata14 = mbuiContext.metadataRegistry().lookup(metadata14Template);
        AddressTemplate metadata17Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=timer-service");
        this.metadata17 = mbuiContext.metadataRegistry().lookup(metadata17Template);
        AddressTemplate metadata16Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=remote");
        this.metadata16 = mbuiContext.metadataRegistry().lookup(metadata16Template);
        AddressTemplate metadata11Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/strict-max-bean-instance-pool=*");
        this.metadata11 = mbuiContext.metadataRegistry().lookup(metadata11Template);
        AddressTemplate metadata9Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/thread-pool=*");
        this.metadata9 = mbuiContext.metadataRegistry().lookup(metadata9Template);
        AddressTemplate metadata13Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/passivation-store=*");
        this.metadata13 = mbuiContext.metadataRegistry().lookup(metadata13Template);
        AddressTemplate metadata8Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3");
        this.metadata8 = mbuiContext.metadataRegistry().lookup(metadata8Template);
        AddressTemplate metadata12Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/cache=*");
        this.metadata12 = mbuiContext.metadataRegistry().lookup(metadata12Template);
        AddressTemplate metadata10Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/remoting-profile=*");
        this.metadata10 = mbuiContext.metadataRegistry().lookup(metadata10Template);
        this.handlebarElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb-configuration-form", metadata8)
            .onSave((form, changedValues) -> saveSingletonForm("Container", metadata8Template.resolve(mbuiContext.statementContext()), changedValues))
            .build();
        threadPoolForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("ejb-thread-pool-form", metadata9)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Thread Pool", name, metadata9Template.resolve(mbuiContext.statementContext(), name), changedValues);
            })
            .build();
        remotingProfileForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("ejb-remoting-profile-form", metadata10)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Remoting Profile", name, metadata10Template.resolve(mbuiContext.statementContext(), name), changedValues);
            })
            .build();
        beanPoolForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("ejb-bean-pool-form", metadata11)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Bean Pool", name, metadata11Template.resolve(mbuiContext.statementContext(), name), changedValues);
            })
            .build();
        cacheForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("ejb-cache-form", metadata12)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Cache", name, metadata12Template.resolve(mbuiContext.statementContext(), name), changedValues);
            })
            .build();
        passivationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("ejb-passivation-form", metadata13)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Passivation", name, metadata13Template.resolve(mbuiContext.statementContext(), name), changedValues);
            })
            .build();
        serviceAsyncForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb-service-async-form", metadata14)
            .include("thread-pool-name")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Async", metadata14Template.resolve(mbuiContext.statementContext()), changedValues))
            .build();
        serviceAsyncForm.getFormItem("thread-pool-name").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=ejb3/thread-pool=*")));
        serviceIiopForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb-service-iiop-form", metadata15)
            .onSave((form, changedValues) -> saveSingletonForm("IIOP", metadata15Template.resolve(mbuiContext.statementContext()), changedValues))
            .build();
        serviceRemoteForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb-service-remote-form", metadata16)
            .include("cluster", "connector-ref", "thread-pool-name", "execute-in-worker")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Remote", metadata16Template.resolve(mbuiContext.statementContext()), changedValues))
            .build();
        serviceRemoteForm.getFormItem("cluster").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=infinispan/cache-container=*")));
        serviceRemoteForm.getFormItem("connector-ref").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=remoting/http-connector=*")));
        serviceRemoteForm.getFormItem("thread-pool-name").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=ejb3/thread-pool=*")));
        serviceTimerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb-service-timer-form", metadata17)
            .include("default-data-store", "thread-pool-name")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Timer", metadata17Template.resolve(mbuiContext.statementContext()), changedValues))
            .build();
        List<AddressTemplate> serviceTimerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=timer-service/database-data-store=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=timer-service/file-data-store=*"));
        serviceTimerForm.getFormItem("default-data-store").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), serviceTimerFormTemplates));
        serviceTimerForm.getFormItem("thread-pool-name").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=ejb3/thread-pool=*")));
        mdbDeliveryGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("ejb-mdb-delivery-group-form", metadata18)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("MDB Delivery Group", name, metadata18Template.resolve(mbuiContext.statementContext(), name), changedValues);
            })
            .build();

        Options<org.jboss.hal.dmr.model.NamedNode> threadPoolTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata9)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb-thread-pool-table", Ids.ADD_SUFFIX), "Thread Pool",
                metadata9Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Thread Pool", metadata9Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        threadPoolTable = new NamedNodeTable<>("ejb-thread-pool-table", threadPoolTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> remotingProfileTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata10)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb-remoting-profile-table", Ids.ADD_SUFFIX), "Remoting Profile",
                metadata10Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Remoting Profile", metadata10Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        remotingProfileTable = new NamedNodeTable<>("ejb-remoting-profile-table", remotingProfileTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> beanPoolTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata11)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb-bean-pool-table", Ids.ADD_SUFFIX), "Bean Pool",
                metadata11Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Bean Pool", metadata11Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        beanPoolTable = new NamedNodeTable<>("ejb-bean-pool-table", beanPoolTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> cacheTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata12)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb-cache-table", Ids.ADD_SUFFIX), "Cache",
                metadata12Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Cache", metadata12Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        cacheTable = new NamedNodeTable<>("ejb-cache-table", cacheTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> passivationTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata13)
            .button(mbuiContext.resources().constants().add(), (event, api) -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("ejb-passivation-table", Ids.ADD_SUFFIX),
                    mbuiContext.resources().messages().addResourceTitle("Passivation"),
                    metadata13,
                    asList("bean-cache", "cache-container", "max-size"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata13Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("Passivation", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.getForm().getFormItem("cache-container").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=infinispan/cache-container=*")));
                dialog.show();
            })
            .button(mbuiContext.tableButtonFactory().remove("Passivation", metadata13Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        passivationTable = new NamedNodeTable<>("ejb-passivation-table", passivationTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> mdbDeliveryGroupTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata18)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb-mdb-delivery-group-table", Ids.ADD_SUFFIX), "MDB Delivery Group",
                metadata18Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("MDB Delivery Group", metadata18Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        mdbDeliveryGroupTable = new NamedNodeTable<>("ejb-mdb-delivery-group-table", mdbDeliveryGroupTableOptions);

        navigation = new VerticalNavigation();
        navigation.addPrimary("ejb-container-item", "Container", "fa fa-cogs");
        Elements.Builder ejbConfigurationItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Container</h1><p>{{metadata8.getDescription().getDescription()}}</p>"))
                    .rememberAs("html23")
                .end()
                .add(configurationForm)
            .end();
        Element ejbConfigurationItemElement = ejbConfigurationItemBuilder.build();
        handlebarElements.put("html23", ejbConfigurationItemBuilder.referenceFor("html23"));
        navigation.addSecondary("ejb-container-item", "ejb-configuration-item", "Container", ejbConfigurationItemElement);
        Elements.Builder ejbThreadPoolItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Thread Pool</h1><p>{{metadata9.getDescription().getDescription()}}</p>"))
                    .rememberAs("html25")
                .end()
                .add(threadPoolTable)
                .add(threadPoolForm)
            .end();
        Element ejbThreadPoolItemElement = ejbThreadPoolItemBuilder.build();
        handlebarElements.put("html25", ejbThreadPoolItemBuilder.referenceFor("html25"));
        navigation.addSecondary("ejb-container-item", "ejb-thread-pool-item", "Thread Pool", ejbThreadPoolItemElement);
        Elements.Builder ejbRemotingProfileItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remoting Profile</h1><p>{{metadata10.getDescription().getDescription()}}</p>"))
                    .rememberAs("html28")
                .end()
                .add(remotingProfileTable)
                .add(remotingProfileForm)
            .end();
        Element ejbRemotingProfileItemElement = ejbRemotingProfileItemBuilder.build();
        handlebarElements.put("html28", ejbRemotingProfileItemBuilder.referenceFor("html28"));
        navigation.addSecondary("ejb-container-item", "ejb-remoting-profile-item", "Remoting Profile", ejbRemotingProfileItemElement);
        Elements.Builder ejbBeanPoolItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Bean Pool</h1><p>{{metadata11.getDescription().getDescription()}}</p>"))
                    .rememberAs("html31")
                .end()
                .add(beanPoolTable)
                .add(beanPoolForm)
            .end();
        Element ejbBeanPoolItemElement = ejbBeanPoolItemBuilder.build();
        handlebarElements.put("html31", ejbBeanPoolItemBuilder.referenceFor("html31"));
        navigation.addPrimary("ejb-bean-pool-item", "Bean Pool", "pficon pficon-repository", ejbBeanPoolItemElement);
        navigation.addPrimary("ejb-state-item", "State Management", "fa fa-list-ul");
        Elements.Builder ejbCacheItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Cache</h1><p>{{metadata12.getDescription().getDescription()}}</p>"))
                    .rememberAs("html34")
                .end()
                .add(cacheTable)
                .add(cacheForm)
            .end();
        Element ejbCacheItemElement = ejbCacheItemBuilder.build();
        handlebarElements.put("html34", ejbCacheItemBuilder.referenceFor("html34"));
        navigation.addSecondary("ejb-state-item", "ejb-cache-item", "Cache", ejbCacheItemElement);
        Elements.Builder ejbPassivationItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Passivation</h1><p>{{metadata13.getDescription().getDescription()}}</p>"))
                    .rememberAs("html37")
                .end()
                .add(passivationTable)
                .add(passivationForm)
            .end();
        Element ejbPassivationItemElement = ejbPassivationItemBuilder.build();
        handlebarElements.put("html37", ejbPassivationItemBuilder.referenceFor("html37"));
        navigation.addSecondary("ejb-state-item", "ejb-passivation-item", "Passivation", ejbPassivationItemElement);
        navigation.addPrimary("ejb-service-item", "Services", "pficon pficon-service");
        Elements.Builder ejbServiceAsyncItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Async</h1><p>{{metadata14.getDescription().getDescription()}}</p>"))
                    .rememberAs("html40")
                .end()
                .add(serviceAsyncForm)
            .end();
        Element ejbServiceAsyncItemElement = ejbServiceAsyncItemBuilder.build();
        handlebarElements.put("html40", ejbServiceAsyncItemBuilder.referenceFor("html40"));
        navigation.addSecondary("ejb-service-item", "ejb-service-async-item", "Async", ejbServiceAsyncItemElement);
        Elements.Builder ejbServiceIiopItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>IIOP</h1><p>{{metadata15.getDescription().getDescription()}}</p>"))
                    .rememberAs("html42")
                .end()
                .add(serviceIiopForm)
            .end();
        Element ejbServiceIiopItemElement = ejbServiceIiopItemBuilder.build();
        handlebarElements.put("html42", ejbServiceIiopItemBuilder.referenceFor("html42"));
        navigation.addSecondary("ejb-service-item", "ejb-service-iiop-item", "IIOP", ejbServiceIiopItemElement);
        Elements.Builder ejbServiceRemoteItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remote</h1><p>{{metadata16.getDescription().getDescription()}}</p>"))
                    .rememberAs("html44")
                .end()
                .add(serviceRemoteForm)
            .end();
        Element ejbServiceRemoteItemElement = ejbServiceRemoteItemBuilder.build();
        handlebarElements.put("html44", ejbServiceRemoteItemBuilder.referenceFor("html44"));
        navigation.addSecondary("ejb-service-item", "ejb-service-remote-item", "Remote", ejbServiceRemoteItemElement);
        Elements.Builder ejbServiceTimerItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Timer</h1><p>{{metadata17.getDescription().getDescription()}}</p>"))
                    .rememberAs("html46")
                .end()
                .add(serviceTimerForm)
            .end();
        Element ejbServiceTimerItemElement = ejbServiceTimerItemBuilder.build();
        handlebarElements.put("html46", ejbServiceTimerItemBuilder.referenceFor("html46"));
        navigation.addSecondary("ejb-service-item", "ejb-service-timer-item", "Timer", ejbServiceTimerItemElement);
        Elements.Builder ejbMdbDeliveryGroupItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>MDB Delivery Group</h1><p>{{metadata18.getDescription().getDescription()}}</p>"))
                    .rememberAs("html48")
                .end()
                .add(mdbDeliveryGroupTable)
                .add(mdbDeliveryGroupForm)
            .end();
        Element ejbMdbDeliveryGroupItemElement = ejbMdbDeliveryGroupItemBuilder.build();
        handlebarElements.put("html48", ejbMdbDeliveryGroupItemBuilder.referenceFor("html48"));
        navigation.addPrimary("ejb-mdb-delivery-group-item", "MDB Delivery", "fa fa-inbox", ejbMdbDeliveryGroupItemElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(threadPoolTable);
        registerAttachable(threadPoolForm);
        registerAttachable(remotingProfileTable);
        registerAttachable(remotingProfileForm);
        registerAttachable(beanPoolTable);
        registerAttachable(beanPoolForm);
        registerAttachable(cacheTable);
        registerAttachable(cacheForm);
        registerAttachable(passivationTable);
        registerAttachable(passivationForm);
        registerAttachable(serviceAsyncForm);
        registerAttachable(serviceIiopForm);
        registerAttachable(serviceRemoteForm);
        registerAttachable(serviceTimerForm);
        registerAttachable(mdbDeliveryGroupTable);
        registerAttachable(mdbDeliveryGroupForm);

        Element root = layoutBuilder.build();
        initElement(root);

        init();
    }

    @Override
    org.jboss.hal.config.Environment environment() {
    return environment;
    }

    @Override
    public void attach() {
        super.attach();

            threadPoolTable.bindForm(threadPoolForm);
            remotingProfileTable.bindForm(remotingProfileForm);
            beanPoolTable.bindForm(beanPoolForm);
            cacheTable.bindForm(cacheForm);
            passivationTable.bindForm(passivationForm);
            mdbDeliveryGroupTable.bindForm(mdbDeliveryGroupForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html23"), "{{metadata8.getDescription().getDescription()}}", String.valueOf(metadata8.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html25"), "{{metadata9.getDescription().getDescription()}}", String.valueOf(metadata9.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html28"), "{{metadata10.getDescription().getDescription()}}", String.valueOf(metadata10.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html31"), "{{metadata11.getDescription().getDescription()}}", String.valueOf(metadata11.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html34"), "{{metadata12.getDescription().getDescription()}}", String.valueOf(metadata12.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html37"), "{{metadata13.getDescription().getDescription()}}", String.valueOf(metadata13.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html40"), "{{metadata14.getDescription().getDescription()}}", String.valueOf(metadata14.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html42"), "{{metadata15.getDescription().getDescription()}}", String.valueOf(metadata15.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html44"), "{{metadata16.getDescription().getDescription()}}", String.valueOf(metadata16.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html46"), "{{metadata17.getDescription().getDescription()}}", String.valueOf(metadata17.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html48"), "{{metadata18.getDescription().getDescription()}}", String.valueOf(metadata18.getDescription().getDescription()));
    }
}
