/*
 * Copyright 2015-2016 Red Hat, Inc, and individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.hal.client.configuration.subsystem.resourceadapter;

import org.jboss.hal.ballroom.form.CreationContext;
import org.jboss.hal.ballroom.form.PropertiesItem;

/**
 * @author Harald Pehl
 */
class MappingsItem extends PropertiesItem {

    MappingsItem(final String name) {
        super(name);
    }

    @Override
    protected <C> void assembleUI(CreationContext<C> context) {
        super.assembleUI(context);
        errorText.setInnerHTML(MESSAGES.mappingHint().asString());
    }

    @Override
    public void clearError() {
        super.clearError();
        errorText.setInnerHTML(MESSAGES.mappingHint().asString());
    }
}
