package org.jboss.hal.client.runtime.group;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.FailSafeForm;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.table.NamedNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_ServerGroupView extends ServerGroupView {

    private final Metadata metadata116;
    private final Metadata metadata115;
    private final Metadata metadata117;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_ServerGroupView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata116Template = AddressTemplate.of("/{selected.group}/jvm=*");
        this.metadata116 = mbuiContext.metadataRegistry().lookup(metadata116Template);
        AddressTemplate metadata115Template = AddressTemplate.of("/{selected.group}");
        this.metadata115 = mbuiContext.metadataRegistry().lookup(metadata115Template);
        AddressTemplate metadata117Template = AddressTemplate.of("/{selected.group}/system-property=*");
        this.metadata117 = mbuiContext.metadataRegistry().lookup(metadata117Template);
        this.handlebarElements = new HashMap<>();

        serverGroupConfigurationForm = new ModelNodeForm.Builder<org.jboss.hal.core.runtime.group.ServerGroup>("server-group-configuration-form", metadata115)
            .includeRuntime()
            .include("profile", "socket-binding-group", "socket-binding-port-offset", "socket-binding-default-interface", "management-subsystem-endpoint")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Server Group Configuration", metadata115Template.resolve(mbuiContext.statementContext()), changedValues))
            .build();
        serverGroupJvmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("server-group-jvm-form", metadata116)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Jvm", name, metadata116Template.resolve(mbuiContext.statementContext(), name), changedValues);
            })
            .build();
        serverGroupSystemPropertyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("server-group-system-property-form", metadata117)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("System Property", name, metadata117Template.resolve(mbuiContext.statementContext(), name), changedValues);
            })
            .build();

        Options<org.jboss.hal.dmr.model.NamedNode> serverGroupJvmTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata116)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-group-jvm-table", Ids.ADD_SUFFIX), "Jvm",
                metadata116Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Jvm", metadata116Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        serverGroupJvmTable = new NamedNodeTable<>("server-group-jvm-table", serverGroupJvmTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> serverGroupSystemPropertyTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata117)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-group-system-property-table", Ids.ADD_SUFFIX), "System Property",
                metadata117Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("System Property", metadata117Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("value")
            .build();
        serverGroupSystemPropertyTable = new NamedNodeTable<>("server-group-system-property-table", serverGroupSystemPropertyTableOptions);

        navigation = new VerticalNavigation();
        Elements.Builder serverGroupConfigurationItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Server Group Configuration</h1><p>{{metadata115.getDescription().getDescription()}}</p>"))
                    .rememberAs("html339")
                .end()
                .add(serverGroupConfigurationForm)
            .end();
        Element serverGroupConfigurationItemElement = serverGroupConfigurationItemBuilder.build();
        handlebarElements.put("html339", serverGroupConfigurationItemBuilder.referenceFor("html339"));
        navigation.addPrimary("server-group-configuration-item", "Configuration", "pficon pficon-settings", serverGroupConfigurationItemElement);
        Elements.Builder serverGroupJvmItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JVMs</h1><p>{{metadata116.getDescription().getDescription()}}</p>"))
                    .rememberAs("html341")
                .end()
                .add(serverGroupJvmTable)
                .add(serverGroupJvmForm)
            .end();
        Element serverGroupJvmItemElement = serverGroupJvmItemBuilder.build();
        handlebarElements.put("html341", serverGroupJvmItemBuilder.referenceFor("html341"));
        navigation.addPrimary("server-group-jvm-item", "JVMs", "fa fa-coffee", serverGroupJvmItemElement);
        Elements.Builder serverGroupSystemPropertyItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>System Properties</h1><p>{{metadata117.getDescription().getDescription()}}</p>"))
                    .rememberAs("html344")
                .end()
                .add(serverGroupSystemPropertyTable)
                .add(serverGroupSystemPropertyForm)
            .end();
        Element serverGroupSystemPropertyItemElement = serverGroupSystemPropertyItemBuilder.build();
        handlebarElements.put("html344", serverGroupSystemPropertyItemBuilder.referenceFor("html344"));
        navigation.addPrimary("server-group-system-property-item", "System Properties", "fa fa-list-ul", serverGroupSystemPropertyItemElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        registerAttachable(navigation);
        registerAttachable(serverGroupConfigurationForm);
        registerAttachable(serverGroupJvmTable);
        registerAttachable(serverGroupJvmForm);
        registerAttachable(serverGroupSystemPropertyTable);
        registerAttachable(serverGroupSystemPropertyForm);

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            serverGroupJvmTable.bindForm(serverGroupJvmForm);
            serverGroupSystemPropertyTable.bindForm(serverGroupSystemPropertyForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html339"), "{{metadata115.getDescription().getDescription()}}", String.valueOf(metadata115.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html341"), "{{metadata116.getDescription().getDescription()}}", String.valueOf(metadata116.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html344"), "{{metadata117.getDescription().getDescription()}}", String.valueOf(metadata117.getDescription().getDescription()));
    }
}
