package org.jboss.hal.client.runtime.host;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.FailSafeForm;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.table.NamedNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_HostView extends HostView {

    private final Metadata metadata118;
    private final Metadata metadata122;
    private final Metadata metadata120;
    private final Metadata metadata121;
    private final Metadata metadata119;
    private final Metadata metadata123;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_HostView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata118Template = AddressTemplate.of("/{selected.host}");
        this.metadata118 = mbuiContext.metadataRegistry().lookup(metadata118Template);
        AddressTemplate metadata122Template = AddressTemplate.of("/{selected.host}/socket-binding-group=*");
        this.metadata122 = mbuiContext.metadataRegistry().lookup(metadata122Template);
        AddressTemplate metadata120Template = AddressTemplate.of("/{selected.host}/jvm=*");
        this.metadata120 = mbuiContext.metadataRegistry().lookup(metadata120Template);
        AddressTemplate metadata121Template = AddressTemplate.of("/{selected.host}/path=*");
        this.metadata121 = mbuiContext.metadataRegistry().lookup(metadata121Template);
        AddressTemplate metadata119Template = AddressTemplate.of("/{selected.host}/interface=*");
        this.metadata119 = mbuiContext.metadataRegistry().lookup(metadata119Template);
        AddressTemplate metadata123Template = AddressTemplate.of("/{selected.host}/system-property=*");
        this.metadata123 = mbuiContext.metadataRegistry().lookup(metadata123Template);
        this.handlebarElements = new HashMap<>();

        hostConfigurationForm = new ModelNodeForm.Builder<org.jboss.hal.core.runtime.host.Host>("host-configuration-form", metadata118)
            .includeRuntime()
            .include("name", "organization", "directory-grouping", "uuid", "release-codename", "release-version", "product-name", "product-version", "management-major-version", "management-minor-version", "management-micro-version", "running-mode", "host-state", "suspend-state")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveHost(form, changedValues))
            .build();
        hostInterfaceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("host-interface-form", metadata119)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Interface", name, metadata119Template.resolve(mbuiContext.statementContext(), name), changedValues);
            })
            .build();
        hostJvmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("host-jvm-form", metadata120)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Jvm", name, metadata120Template.resolve(mbuiContext.statementContext(), name), changedValues);
            })
            .build();
        hostPathForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("host-path-form", metadata121)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Path", name, metadata121Template.resolve(mbuiContext.statementContext(), name), changedValues);
            })
            .build();
        hostSocketBindingGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("host-socket-binding-group-form", metadata122)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Socket Binding Group", name, metadata122Template.resolve(mbuiContext.statementContext(), name), changedValues);
            })
            .build();
        hostSystemPropertyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("host-system-property-form", metadata123)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("System Property", name, metadata123Template.resolve(mbuiContext.statementContext(), name), changedValues);
            })
            .build();

        Options<org.jboss.hal.dmr.model.NamedNode> hostInterfaceTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata119)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-interface-table", Ids.ADD_SUFFIX), "Interface",
                metadata119Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Interface", metadata119Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        hostInterfaceTable = new NamedNodeTable<>("host-interface-table", hostInterfaceTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> hostJvmTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata120)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-jvm-table", Ids.ADD_SUFFIX), "Jvm",
                metadata120Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Jvm", metadata120Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        hostJvmTable = new NamedNodeTable<>("host-jvm-table", hostJvmTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> hostPathTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata121)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-path-table", Ids.ADD_SUFFIX), "Path",
                metadata121Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Path", metadata121Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "path")
            .build();
        hostPathTable = new NamedNodeTable<>("host-path-table", hostPathTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> hostSocketBindingGroupTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata122)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-socket-binding-group-table", Ids.ADD_SUFFIX), "Socket Binding Group",
                metadata122Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Socket Binding Group", metadata122Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        hostSocketBindingGroupTable = new NamedNodeTable<>("host-socket-binding-group-table", hostSocketBindingGroupTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> hostSystemPropertyTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata123)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-system-property-table", Ids.ADD_SUFFIX), "System Property",
                metadata123Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("System Property", metadata123Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("value")
            .build();
        hostSystemPropertyTable = new NamedNodeTable<>("host-system-property-table", hostSystemPropertyTableOptions);

        navigation = new VerticalNavigation();
        Elements.Builder hostConfigurationItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1 id=\"host-configuration-title\" /><p>{{metadata118.getDescription().getDescription()}}</p>"))
                    .rememberAs("html348")
                .end()
                .add(hostConfigurationForm)
            .end();
        Element hostConfigurationItemElement = hostConfigurationItemBuilder.build();
        handlebarElements.put("html348", hostConfigurationItemBuilder.referenceFor("html348"));
        navigation.addPrimary("host-configuration-item", "Configuration", "pficon pficon-settings", hostConfigurationItemElement);
        Elements.Builder hostInterfaceItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Interfaces</h1><p>{{metadata119.getDescription().getDescription()}}</p>"))
                    .rememberAs("html350")
                .end()
                .add(hostInterfaceTable)
                .add(hostInterfaceForm)
            .end();
        Element hostInterfaceItemElement = hostInterfaceItemBuilder.build();
        handlebarElements.put("html350", hostInterfaceItemBuilder.referenceFor("html350"));
        navigation.addPrimary("host-interface-item", "Interfaces", "fa fa-exchange", hostInterfaceItemElement);
        Elements.Builder hostJvmItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JVMs</h1><p>{{metadata120.getDescription().getDescription()}}</p>"))
                    .rememberAs("html353")
                .end()
                .add(hostJvmTable)
                .add(hostJvmForm)
            .end();
        Element hostJvmItemElement = hostJvmItemBuilder.build();
        handlebarElements.put("html353", hostJvmItemBuilder.referenceFor("html353"));
        navigation.addPrimary("host-jvm-item", "JVMs", "fa fa-coffee", hostJvmItemElement);
        Elements.Builder hostPathItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Paths</h1><p>{{metadata121.getDescription().getDescription()}}</p>"))
                    .rememberAs("html356")
                .end()
                .add(hostPathTable)
                .add(hostPathForm)
            .end();
        Element hostPathItemElement = hostPathItemBuilder.build();
        handlebarElements.put("html356", hostPathItemBuilder.referenceFor("html356"));
        navigation.addPrimary("host-path-item", "Paths", "fa fa-folder-open", hostPathItemElement);
        Elements.Builder hostSocketBindingGroupItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Socket Binding Groups</h1><p>{{metadata122.getDescription().getDescription()}}</p>"))
                    .rememberAs("html359")
                .end()
                .add(hostSocketBindingGroupTable)
                .add(hostSocketBindingGroupForm)
            .end();
        Element hostSocketBindingGroupItemElement = hostSocketBindingGroupItemBuilder.build();
        handlebarElements.put("html359", hostSocketBindingGroupItemBuilder.referenceFor("html359"));
        navigation.addPrimary("host-socket-binding-group-item", "Socket Binding Groups", "fa fa-object-group", hostSocketBindingGroupItemElement);
        Elements.Builder hostSystemPropertyItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>System Properties</h1><p>{{metadata123.getDescription().getDescription()}}</p>"))
                    .rememberAs("html362")
                .end()
                .add(hostSystemPropertyTable)
                .add(hostSystemPropertyForm)
            .end();
        Element hostSystemPropertyItemElement = hostSystemPropertyItemBuilder.build();
        handlebarElements.put("html362", hostSystemPropertyItemBuilder.referenceFor("html362"));
        navigation.addPrimary("host-system-property-item", "System Properties", "fa fa-list-ul", hostSystemPropertyItemElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        registerAttachable(navigation);
        registerAttachable(hostConfigurationForm);
        registerAttachable(hostInterfaceTable);
        registerAttachable(hostInterfaceForm);
        registerAttachable(hostJvmTable);
        registerAttachable(hostJvmForm);
        registerAttachable(hostPathTable);
        registerAttachable(hostPathForm);
        registerAttachable(hostSocketBindingGroupTable);
        registerAttachable(hostSocketBindingGroupForm);
        registerAttachable(hostSystemPropertyTable);
        registerAttachable(hostSystemPropertyForm);

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            hostInterfaceTable.bindForm(hostInterfaceForm);
            hostJvmTable.bindForm(hostJvmForm);
            hostPathTable.bindForm(hostPathForm);
            hostSocketBindingGroupTable.bindForm(hostSocketBindingGroupForm);
            hostSystemPropertyTable.bindForm(hostSystemPropertyForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html348"), "{{metadata118.getDescription().getDescription()}}", String.valueOf(metadata118.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html350"), "{{metadata119.getDescription().getDescription()}}", String.valueOf(metadata119.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html353"), "{{metadata120.getDescription().getDescription()}}", String.valueOf(metadata120.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html356"), "{{metadata121.getDescription().getDescription()}}", String.valueOf(metadata121.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html359"), "{{metadata122.getDescription().getDescription()}}", String.valueOf(metadata122.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html362"), "{{metadata123.getDescription().getDescription()}}", String.valueOf(metadata123.getDescription().getDescription()));
    }
}
