package org.jboss.hal.client.configuration.subsystem.modcluster;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.FailSafeForm;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.table.NamedNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_ModclusterView extends ModclusterView {

    private final Metadata metadata76;
    private final Metadata metadata77;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_ModclusterView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata76Template = AddressTemplate.of("/{selected.profile}/subsystem=modcluster/mod-cluster-config=configuration");
        this.metadata76 = mbuiContext.metadataRegistry().lookup(metadata76Template);
        AddressTemplate metadata77Template = AddressTemplate.of("/{selected.profile}/subsystem=modcluster/mod-cluster-config=configuration/ssl=configuration");
        this.metadata77 = mbuiContext.metadataRegistry().lookup(metadata77Template);
        this.handlebarElements = new HashMap<>();

        configurationForm = new GroupedForm.Builder<org.jboss.hal.dmr.ModelNode>("modcluster-configuration", metadata76)
            .customGroup("advertising", "Advertising")
                .include("connector", "load-balancing-group", "balancer", "advertise-socket", "advertise-security-key", "advertise")
            .end()
            .customGroup("sessions", "Sessions")
                .include("sticky-session", "sticky-session-force", "sticky-session-remove")
            .end()
            .customGroup("web-contexts", "Web Contexts")
                .include("auto-enable-context", "excluded-contexts")
            .end()
            .customGroup("proxies", "Proxies")
                .include("proxy-url", "proxies")
            .end()
            .customGroup("networking", "Networking")
                .include("node-timeout", "socket-timeout", "stop-context-timeout", "max-attempts", "flush-packets", "flush-wait", "ping", "ttl", "worker-timeout")
            .end()
            .onSave((form, changedValues) -> saveSingletonForm("Configuration", metadata76Template.resolve(mbuiContext.statementContext()), changedValues))
            .build();
        Form<org.jboss.hal.dmr.ModelNode> failSafe_sslForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>(Ids.build("modcluster-ssl-form", Ids.FORM_SUFFIX), metadata77)
            .include("key-alias", "password", "ca-certificate-file", "certificate-key-file", "cipher-suite", "ca-revocation-url", "protocol")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("SSL", metadata77Template.resolve(mbuiContext.statementContext()), changedValues))
            .build();
        sslForm = new FailSafeForm<>(mbuiContext.dispatcher(),
                () -> new Operation.Builder(READ_RESOURCE_OPERATION, metadata77Template.resolve(mbuiContext.statementContext())).build(),
                failSafe_sslForm,
                () -> addSingleton("modcluster-ssl-form", "SSL", metadata77Template));


        navigation = new VerticalNavigation();
        Elements.Builder modclusterConfigurationItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>{{metadata76.getDescription().getDescription()}}</p>"))
                    .rememberAs("html218")
                .end()
                .add(configurationForm)
            .end();
        Element modclusterConfigurationItemElement = modclusterConfigurationItemBuilder.build();
        handlebarElements.put("html218", modclusterConfigurationItemBuilder.referenceFor("html218"));
        navigation.addPrimary("modcluster-configuration-item", "Configuration", "pficon pficon-settings", modclusterConfigurationItemElement);
        Elements.Builder modclusterSslItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>SSL</h1><p>{{metadata77.getDescription().getDescription()}}</p>"))
                    .rememberAs("html220")
                .end()
                .add(sslForm)
            .end();
        Element modclusterSslItemElement = modclusterSslItemBuilder.build();
        handlebarElements.put("html220", modclusterSslItemBuilder.referenceFor("html220"));
        navigation.addPrimary("modcluster-ssl-item", "SSL", "fa fa-lock", modclusterSslItemElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(sslForm);

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();


        TemplateUtil.replaceHandlebar(handlebarElements.get("html218"), "{{metadata76.getDescription().getDescription()}}", String.valueOf(metadata76.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html220"), "{{metadata77.getDescription().getDescription()}}", String.valueOf(metadata77.getDescription().getDescription()));
    }
}
