package org.jboss.hal.client.runtime.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.FailSafeForm;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.table.NamedNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_ServerView extends ServerView {

    private final Metadata metadata125;
    private final Metadata metadata126;
    private final Metadata metadata124;
    private final Metadata metadata128;
    private final Metadata metadata127;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_ServerView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata125Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/interface=*");
        this.metadata125 = mbuiContext.metadataRegistry().lookup(metadata125Template);
        AddressTemplate metadata126Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/jvm=*");
        this.metadata126 = mbuiContext.metadataRegistry().lookup(metadata126Template);
        AddressTemplate metadata124Template = AddressTemplate.of("/{selected.host}/{selected.server-config}");
        this.metadata124 = mbuiContext.metadataRegistry().lookup(metadata124Template);
        AddressTemplate metadata128Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/system-property=*");
        this.metadata128 = mbuiContext.metadataRegistry().lookup(metadata128Template);
        AddressTemplate metadata127Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/path=*");
        this.metadata127 = mbuiContext.metadataRegistry().lookup(metadata127Template);
        this.handlebarElements = new HashMap<>();

        serverConfigurationForm = new ModelNodeForm.Builder<org.jboss.hal.core.runtime.server.Server>("server-configuration-form", metadata124)
            .includeRuntime()
            .include("name", "group", "auto-start", "update-auto-start-with-server-status", "socket-binding-group", "socket-binding-port-offset", "socket-binding-default-interface", "status")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Server Configuration", metadata124Template.resolve(mbuiContext.statementContext()), changedValues))
            .build();
        serverInterfaceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("server-interface-form", metadata125)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Interface", name, metadata125Template.resolve(mbuiContext.statementContext(), name), changedValues);
            })
            .build();
        serverJvmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("server-jvm-form", metadata126)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Jvm", name, metadata126Template.resolve(mbuiContext.statementContext(), name), changedValues);
            })
            .build();
        serverPathForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("server-path-form", metadata127)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Path", name, metadata127Template.resolve(mbuiContext.statementContext(), name), changedValues);
            })
            .build();
        serverSystemPropertyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("server-system-property-form", metadata128)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("System Property", name, metadata128Template.resolve(mbuiContext.statementContext(), name), changedValues);
            })
            .build();

        Options<org.jboss.hal.dmr.model.NamedNode> serverInterfaceTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata125)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-interface-table", Ids.ADD_SUFFIX), "Interface",
                metadata125Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Interface", metadata125Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        serverInterfaceTable = new NamedNodeTable<>("server-interface-table", serverInterfaceTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> serverJvmTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata126)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-jvm-table", Ids.ADD_SUFFIX), "Jvm",
                metadata126Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Jvm", metadata126Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        serverJvmTable = new NamedNodeTable<>("server-jvm-table", serverJvmTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> serverPathTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata127)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-path-table", Ids.ADD_SUFFIX), "Path",
                metadata127Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Path", metadata127Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "path")
            .build();
        serverPathTable = new NamedNodeTable<>("server-path-table", serverPathTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> serverSystemPropertyTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata128)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-system-property-table", Ids.ADD_SUFFIX), "System Property",
                metadata128Template, asList("value"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("System Property", metadata128Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("value")
            .build();
        serverSystemPropertyTable = new NamedNodeTable<>("server-system-property-table", serverSystemPropertyTableOptions);

        navigation = new VerticalNavigation();
        Elements.Builder serverConfigurationItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Server Configuration</h1><p>{{metadata124.getDescription().getDescription()}}</p>"))
                    .rememberAs("html366")
                .end()
                .add(serverConfigurationForm)
            .end();
        Element serverConfigurationItemElement = serverConfigurationItemBuilder.build();
        handlebarElements.put("html366", serverConfigurationItemBuilder.referenceFor("html366"));
        navigation.addPrimary("server-configuration-item", "Configuration", "pficon pficon-settings", serverConfigurationItemElement);
        Elements.Builder serverInterfaceItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Interfaces</h1><p>{{metadata125.getDescription().getDescription()}}</p>"))
                    .rememberAs("html368")
                .end()
                .add(serverInterfaceTable)
                .add(serverInterfaceForm)
            .end();
        Element serverInterfaceItemElement = serverInterfaceItemBuilder.build();
        handlebarElements.put("html368", serverInterfaceItemBuilder.referenceFor("html368"));
        navigation.addPrimary("server-interface-item", "Interfaces", "fa fa-exchange", serverInterfaceItemElement);
        Elements.Builder serverJvmItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JVMs</h1><p>{{metadata126.getDescription().getDescription()}}</p>"))
                    .rememberAs("html371")
                .end()
                .add(serverJvmTable)
                .add(serverJvmForm)
            .end();
        Element serverJvmItemElement = serverJvmItemBuilder.build();
        handlebarElements.put("html371", serverJvmItemBuilder.referenceFor("html371"));
        navigation.addPrimary("server-jvm-item", "JVMs", "fa fa-coffee", serverJvmItemElement);
        Elements.Builder serverPathItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Paths</h1><p>{{metadata127.getDescription().getDescription()}}</p>"))
                    .rememberAs("html374")
                .end()
                .add(serverPathTable)
                .add(serverPathForm)
            .end();
        Element serverPathItemElement = serverPathItemBuilder.build();
        handlebarElements.put("html374", serverPathItemBuilder.referenceFor("html374"));
        navigation.addPrimary("server-path-item", "Paths", "fa fa-folder-open", serverPathItemElement);
        Elements.Builder serverSystemPropertyItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>System Properties</h1><p>{{metadata128.getDescription().getDescription()}}</p>"))
                    .rememberAs("html377")
                .end()
                .add(serverSystemPropertyTable)
                .add(serverSystemPropertyForm)
            .end();
        Element serverSystemPropertyItemElement = serverSystemPropertyItemBuilder.build();
        handlebarElements.put("html377", serverSystemPropertyItemBuilder.referenceFor("html377"));
        navigation.addPrimary("server-system-property-item", "System Properties", "fa fa-list-ul", serverSystemPropertyItemElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        registerAttachable(navigation);
        registerAttachable(serverConfigurationForm);
        registerAttachable(serverInterfaceTable);
        registerAttachable(serverInterfaceForm);
        registerAttachable(serverJvmTable);
        registerAttachable(serverJvmForm);
        registerAttachable(serverPathTable);
        registerAttachable(serverPathForm);
        registerAttachable(serverSystemPropertyTable);
        registerAttachable(serverSystemPropertyForm);

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            serverInterfaceTable.bindForm(serverInterfaceForm);
            serverJvmTable.bindForm(serverJvmForm);
            serverPathTable.bindForm(serverPathForm);
            serverSystemPropertyTable.bindForm(serverSystemPropertyForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html366"), "{{metadata124.getDescription().getDescription()}}", String.valueOf(metadata124.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html368"), "{{metadata125.getDescription().getDescription()}}", String.valueOf(metadata125.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html371"), "{{metadata126.getDescription().getDescription()}}", String.valueOf(metadata126.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html374"), "{{metadata127.getDescription().getDescription()}}", String.valueOf(metadata127.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html377"), "{{metadata128.getDescription().getDescription()}}", String.valueOf(metadata128.getDescription().getDescription()));
    }
}
