package org.jboss.hal.client.configuration.subsystem.logging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.FailSafeForm;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.table.NamedNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_LoggingView extends LoggingView {

    private final Metadata metadata38;
    private final Metadata metadata45;
    private final Metadata metadata41;
    private final Metadata metadata40;
    private final Metadata metadata43;
    private final Metadata metadata35;
    private final Metadata metadata37;
    private final Metadata metadata42;
    private final Metadata metadata44;
    private final Metadata metadata46;
    private final Metadata metadata39;
    private final Metadata metadata47;
    private final Metadata metadata36;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_LoggingView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata38Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*");
        this.metadata38 = mbuiContext.metadataRegistry().lookup(metadata38Template);
        AddressTemplate metadata45Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*");
        this.metadata45 = mbuiContext.metadataRegistry().lookup(metadata45Template);
        AddressTemplate metadata41Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*");
        this.metadata41 = mbuiContext.metadataRegistry().lookup(metadata41Template);
        AddressTemplate metadata40Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*");
        this.metadata40 = mbuiContext.metadataRegistry().lookup(metadata40Template);
        AddressTemplate metadata43Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/async-handler=*");
        this.metadata43 = mbuiContext.metadataRegistry().lookup(metadata43Template);
        AddressTemplate metadata35Template = AddressTemplate.of("/{selected.profile}/subsystem=logging");
        this.metadata35 = mbuiContext.metadataRegistry().lookup(metadata35Template);
        AddressTemplate metadata37Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logger=*");
        this.metadata37 = mbuiContext.metadataRegistry().lookup(metadata37Template);
        AddressTemplate metadata42Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*");
        this.metadata42 = mbuiContext.metadataRegistry().lookup(metadata42Template);
        AddressTemplate metadata44Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*");
        this.metadata44 = mbuiContext.metadataRegistry().lookup(metadata44Template);
        AddressTemplate metadata46Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*");
        this.metadata46 = mbuiContext.metadataRegistry().lookup(metadata46Template);
        AddressTemplate metadata39Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*");
        this.metadata39 = mbuiContext.metadataRegistry().lookup(metadata39Template);
        AddressTemplate metadata47Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*");
        this.metadata47 = mbuiContext.metadataRegistry().lookup(metadata47Template);
        AddressTemplate metadata36Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/root-logger=ROOT");
        this.metadata36 = mbuiContext.metadataRegistry().lookup(metadata36Template);
        this.handlebarElements = new HashMap<>();

        loggingConfigForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("logging-config-form", metadata35)
            .onSave((form, changedValues) -> saveSingletonForm("Logging Configuration", metadata35Template.resolve(mbuiContext.statementContext()), changedValues, metadata35))
            .build();
        rootLoggerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("logging-root-logger-form", metadata36)
            .include("level", "handlers", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Root Logger", metadata36Template.resolve(mbuiContext.statementContext()), changedValues, metadata36))
            .build();
        List<AddressTemplate> rootLoggerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/async-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
        rootLoggerForm.getFormItem("handlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), rootLoggerFormTemplates));
        loggerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-categories-form", metadata37)
            .include("category", "level", "handlers", "use-parent-handlers", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Category", name, metadata37Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata37);
            })
            .build();
        List<AddressTemplate> loggerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/async-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
        loggerForm.getFormItem("handlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), loggerFormTemplates));
        consoleHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-handler-console-form", metadata38)
            .include("level", "target", "autoflush", "formatter", "named-formatter", "enabled", "encoding", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Console Handler", name, metadata38Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata38);
            })
            .build();
        List<AddressTemplate> consoleHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"));
        consoleHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), consoleHandlerFormTemplates));
        fileHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-handler-file-form", metadata39)
            .customFormItem("file", attributeDescription -> new FileFormItem())
            .include("level")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("File Handler", name, metadata39Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata39);
            })
            .build();
        List<AddressTemplate> fileHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"));
        fileHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), fileHandlerFormTemplates));
        periodicHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-handler-periodic-rotating-file-form", metadata40)
            .customFormItem("file", attributeDescription -> new FileFormItem())
            .include("suffix")
            .include("level")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Periodic Rotating File Handler", name, metadata40Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata40);
            })
            .build();
        List<AddressTemplate> periodicHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"));
        periodicHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), periodicHandlerFormTemplates));
        periodicSizeHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-handler-periodic-size-rotating-file-form", metadata41)
            .customFormItem("file", attributeDescription -> new FileFormItem())
            .include("suffix")
            .include("level")
            .include("rotate-size")
            .include("rotate-on-boot")
            .include("max-backup-index")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Periodic Size Rotating File Handler", name, metadata41Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata41);
            })
            .build();
        List<AddressTemplate> periodicSizeHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"));
        periodicSizeHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), periodicSizeHandlerFormTemplates));
        sizeHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-handler-size-rotating-file-form", metadata42)
            .customFormItem("file", attributeDescription -> new FileFormItem())
            .include("suffix")
            .include("level")
            .include("rotate-size")
            .include("rotate-on-boot")
            .include("max-backup-index")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Size Rotating File Handler", name, metadata42Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata42);
            })
            .build();
        List<AddressTemplate> sizeHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"));
        sizeHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), sizeHandlerFormTemplates));
        asyncHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-handler-async-form", metadata43)
            .include("level", "subhandlers", "queue-length", "overflow-action", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Async Handler", name, metadata43Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata43);
            })
            .build();
        List<AddressTemplate> asyncHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
        asyncHandlerForm.getFormItem("subhandlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), asyncHandlerFormTemplates));
        customHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-handler-custom-form", metadata44)
            .include("level", "module", "class", "properties", "formatter", "named-formatter", "enabled", "encoding", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Custom Handler", name, metadata44Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata44);
            })
            .build();
        List<AddressTemplate> customHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"));
        customHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), customHandlerFormTemplates));
        syslogHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-handler-syslog-form", metadata45)
            .include("level", "syslog-format", "hostname", "server-address", "port", "app-name", "facility", "enabled")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Syslog Handler", name, metadata45Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata45);
            })
            .build();
        customFormatterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-formatter-custom-form", metadata47)
            .include("class", "module", "properties")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Custom Formatter", name, metadata47Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata47);
            })
            .build();
        patternFormatterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("logging-formatter-pattern-form", metadata46)
            .include("color-map", "pattern")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Pattern Formatter", name, metadata46Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata46);
            })
            .build();

        Options<org.jboss.hal.dmr.model.NamedNode> loggerTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata37)
            .button(mbuiContext.resources().constants().add(), (event, api) -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("logging-categories-table", Ids.ADD_SUFFIX),
                    mbuiContext.resources().messages().addResourceTitle("Category"),
                    metadata37,
                    asList("level", "handlers", "use-parent-handlers"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata37Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("Category", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                List<AddressTemplate> loggerTableTemplates = asList(
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/async-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
                dialog.getForm().getFormItem("handlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), mbuiContext.statementContext(), loggerTableTemplates));
                dialog.show();
            })
            .button(mbuiContext.tableButtonFactory().remove("Category", metadata37Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("category", "level")
            .build();
        loggerTable = new NamedNodeTable<>("logging-categories-table", loggerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> consoleHandlerTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata38)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("logging-handler-console-table", Ids.ADD_SUFFIX), "Console Handler",
                metadata38Template, asList("level", "target", "formatter"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Console Handler", metadata38Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "level", "target")
            .build();
        consoleHandlerTable = new NamedNodeTable<>("logging-handler-console-table", consoleHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> fileHandlerTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata39)
            .button(mbuiContext.resources().constants().add(), (event, api) -> {
                ModelNodeForm form = new ModelNodeForm.Builder(Ids.build("logging-handler-file-table", Ids.ADD_SUFFIX),
                    metadata39)
                    .addFromRequestProperties()
                    .unboundFormItem(new org.jboss.hal.core.mbui.dialog.NameItem(), 0)
                    .customFormItem("file", attributeDescription -> new FileFormItem())
                    .include("level")
                    .include("formatter")
                    .unsorted()
                    .build();
                AddResourceDialog dialog = new AddResourceDialog(
                    mbuiContext.resources().messages().addResourceTitle("File Handler"),
                    form,
                    (name, modelNode) -> {
                        ResourceAddress address = metadata39Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("File Handler", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.show();
            })
            .button(mbuiContext.tableButtonFactory().remove("File Handler", metadata39Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        fileHandlerTable = new NamedNodeTable<>("logging-handler-file-table", fileHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> periodicHandlerTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata40)
            .button(mbuiContext.resources().constants().add(), (event, api) -> {
                ModelNodeForm form = new ModelNodeForm.Builder(Ids.build("logging-handler-periodic-rotating-file-table", Ids.ADD_SUFFIX),
                    metadata40)
                    .addFromRequestProperties()
                    .unboundFormItem(new org.jboss.hal.core.mbui.dialog.NameItem(), 0)
                    .customFormItem("file", attributeDescription -> new FileFormItem())
                    .include("suffix")
                    .include("level")
                    .include("formatter")
                    .unsorted()
                    .build();
                AddResourceDialog dialog = new AddResourceDialog(
                    mbuiContext.resources().messages().addResourceTitle("Periodic Rotating File Handler"),
                    form,
                    (name, modelNode) -> {
                        ResourceAddress address = metadata40Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("Periodic Rotating File Handler", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.show();
            })
            .button(mbuiContext.tableButtonFactory().remove("Periodic Rotating File Handler", metadata40Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        periodicHandlerTable = new NamedNodeTable<>("logging-handler-periodic-rotating-file-table", periodicHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> periodicSizeHandlerTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata41)
            .button(mbuiContext.resources().constants().add(), (event, api) -> {
                ModelNodeForm form = new ModelNodeForm.Builder(Ids.build("logging-handler-periodic-size-rotating-file-table", Ids.ADD_SUFFIX),
                    metadata41)
                    .addFromRequestProperties()
                    .unboundFormItem(new org.jboss.hal.core.mbui.dialog.NameItem(), 0)
                    .customFormItem("file", attributeDescription -> new FileFormItem())
                    .include("suffix")
                    .include("level")
                    .include("formatter")
                    .include("rotate-size")
                    .include("max-backup-index")
                    .unsorted()
                    .build();
                AddResourceDialog dialog = new AddResourceDialog(
                    mbuiContext.resources().messages().addResourceTitle("Periodic Size Rotating File Handler"),
                    form,
                    (name, modelNode) -> {
                        ResourceAddress address = metadata41Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("Periodic Size Rotating File Handler", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.show();
            })
            .button(mbuiContext.tableButtonFactory().remove("Periodic Size Rotating File Handler", metadata41Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        periodicSizeHandlerTable = new NamedNodeTable<>("logging-handler-periodic-size-rotating-file-table", periodicSizeHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> sizeHandlerTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata42)
            .button(mbuiContext.resources().constants().add(), (event, api) -> {
                ModelNodeForm form = new ModelNodeForm.Builder(Ids.build("logging-handler-size-rotating-file-table", Ids.ADD_SUFFIX),
                    metadata42)
                    .addFromRequestProperties()
                    .unboundFormItem(new org.jboss.hal.core.mbui.dialog.NameItem(), 0)
                    .customFormItem("file", attributeDescription -> new FileFormItem())
                    .include("suffix")
                    .include("level")
                    .include("formatter")
                    .include("rotate-size")
                    .include("max-backup-index")
                    .unsorted()
                    .build();
                AddResourceDialog dialog = new AddResourceDialog(
                    mbuiContext.resources().messages().addResourceTitle("Size Rotating File Handler"),
                    form,
                    (name, modelNode) -> {
                        ResourceAddress address = metadata42Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("Size Rotating File Handler", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.show();
            })
            .button(mbuiContext.tableButtonFactory().remove("Size Rotating File Handler", metadata42Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        sizeHandlerTable = new NamedNodeTable<>("logging-handler-size-rotating-file-table", sizeHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> asyncHandlerTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata43)
            .button(mbuiContext.resources().constants().add(), (event, api) -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("logging-handler-async-table", Ids.ADD_SUFFIX),
                    mbuiContext.resources().messages().addResourceTitle("Async Handler"),
                    metadata43,
                    asList("level", "subhandlers", "queue-length", "overflow-action"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata43Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("Async Handler", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                List<AddressTemplate> asyncHandlerTableTemplates = asList(
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
                dialog.getForm().getFormItem("subhandlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), mbuiContext.statementContext(), asyncHandlerTableTemplates));
                dialog.show();
            })
            .button(mbuiContext.tableButtonFactory().remove("Async Handler", metadata43Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "level")
            .build();
        asyncHandlerTable = new NamedNodeTable<>("logging-handler-async-table", asyncHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> customHandlerTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata44)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("logging-handler-custom-table", Ids.ADD_SUFFIX), "Custom Handler",
                metadata44Template, asList("level", "module", "class", "formatter"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Custom Handler", metadata44Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "level")
            .build();
        customHandlerTable = new NamedNodeTable<>("logging-handler-custom-table", customHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> syslogHandlerTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata45)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("logging-handler-syslog-table", Ids.ADD_SUFFIX), "Syslog Handler",
                metadata45Template, asList("level", "syslog-format", "hostname", "server-address", "port", "app-name", "facility"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Syslog Handler", metadata45Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("level")
            .build();
        syslogHandlerTable = new NamedNodeTable<>("logging-handler-syslog-table", syslogHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> customFormatterTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata47)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("logging-formatter-custom-table", Ids.ADD_SUFFIX), "Custom Formatter",
                metadata47Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Custom Formatter", metadata47Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        customFormatterTable = new NamedNodeTable<>("logging-formatter-custom-table", customFormatterTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> patternFormatterTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata46)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("logging-formatter-pattern-table", Ids.ADD_SUFFIX), "Pattern Formatter",
                metadata46Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Pattern Formatter", metadata46Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("pattern")
            .build();
        patternFormatterTable = new NamedNodeTable<>("logging-formatter-pattern-table", patternFormatterTableOptions);

        navigation = new VerticalNavigation();
        Elements.Builder loggingConfigItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>{{metadata35.getDescription().getDescription()}}</p>"))
                    .rememberAs("html98")
                .end()
                .add(loggingConfigForm)
            .end();
        Element loggingConfigItemElement = loggingConfigItemBuilder.build();
        handlebarElements.put("html98", loggingConfigItemBuilder.referenceFor("html98"));
        navigation.addPrimary("logging-config-item", "Configuration", "fa fa-list-ul", loggingConfigItemElement);
        Elements.Builder loggingRootLoggerItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1 id=\"logging-root-logger-header\">Root Logger</h1><p id=\"logging-root-logger-description\">{{metadata36.getDescription().getDescription()}}</p>"))
                    .rememberAs("html100")
                .end()
                .add(rootLoggerForm)
            .end();
        Element loggingRootLoggerItemElement = loggingRootLoggerItemBuilder.build();
        handlebarElements.put("html100", loggingRootLoggerItemBuilder.referenceFor("html100"));
        navigation.addPrimary("logging-root-logger-item", "Root Logger", "fa fa-sitemap", loggingRootLoggerItemElement);
        Elements.Builder loggingCategoriesItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Categories</h1><p>{{metadata37.getDescription().getDescription()}}</p>"))
                    .rememberAs("html102")
                .end()
                .add(loggerTable)
                .add(loggerForm)
            .end();
        Element loggingCategoriesItemElement = loggingCategoriesItemBuilder.build();
        handlebarElements.put("html102", loggingCategoriesItemBuilder.referenceFor("html102"));
        navigation.addPrimary("logging-categories-item", "Categories", "pficon pficon-repository", loggingCategoriesItemElement);
        navigation.addPrimary("logging-handler-item", "Handler", "fa fa-cogs");
        Elements.Builder loggingHandlerConsoleItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Console Handler</h1><p>{{metadata38.getDescription().getDescription()}}</p>"))
                    .rememberAs("html105")
                .end()
                .add(consoleHandlerTable)
                .add(consoleHandlerForm)
            .end();
        Element loggingHandlerConsoleItemElement = loggingHandlerConsoleItemBuilder.build();
        handlebarElements.put("html105", loggingHandlerConsoleItemBuilder.referenceFor("html105"));
        navigation.addSecondary("logging-handler-item", "logging-handler-console-item", "Console Handler", loggingHandlerConsoleItemElement);
        Elements.Builder loggingHandlerFileItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>File Handler</h1><p>{{metadata39.getDescription().getDescription()}}</p>"))
                    .rememberAs("html108")
                .end()
                .add(fileHandlerTable)
                .add(fileHandlerForm)
            .end();
        Element loggingHandlerFileItemElement = loggingHandlerFileItemBuilder.build();
        handlebarElements.put("html108", loggingHandlerFileItemBuilder.referenceFor("html108"));
        navigation.addSecondary("logging-handler-item", "logging-handler-file-item", "File Handler", loggingHandlerFileItemElement);
        Elements.Builder loggingHandlerPeriodicRotatingFileItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Periodic Handler</h1><p>{{metadata40.getDescription().getDescription()}}</p>"))
                    .rememberAs("html111")
                .end()
                .add(periodicHandlerTable)
                .add(periodicHandlerForm)
            .end();
        Element loggingHandlerPeriodicRotatingFileItemElement = loggingHandlerPeriodicRotatingFileItemBuilder.build();
        handlebarElements.put("html111", loggingHandlerPeriodicRotatingFileItemBuilder.referenceFor("html111"));
        navigation.addSecondary("logging-handler-item", "logging-handler-periodic-rotating-file-item", "Periodic Handler", loggingHandlerPeriodicRotatingFileItemElement);
        Elements.Builder loggingHandlerPeriodicSizeRotatingFileItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Periodic Size Handler</h1><p>{{metadata41.getDescription().getDescription()}}</p>"))
                    .rememberAs("html114")
                .end()
                .add(periodicSizeHandlerTable)
                .add(periodicSizeHandlerForm)
            .end();
        Element loggingHandlerPeriodicSizeRotatingFileItemElement = loggingHandlerPeriodicSizeRotatingFileItemBuilder.build();
        handlebarElements.put("html114", loggingHandlerPeriodicSizeRotatingFileItemBuilder.referenceFor("html114"));
        navigation.addSecondary("logging-handler-item", "logging-handler-periodic-size-rotating-file-item", "Periodic Size Handler", loggingHandlerPeriodicSizeRotatingFileItemElement);
        Elements.Builder loggingHandlerSizeRotatingFileItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Size Handler</h1><p>{{metadata42.getDescription().getDescription()}}</p>"))
                    .rememberAs("html117")
                .end()
                .add(sizeHandlerTable)
                .add(sizeHandlerForm)
            .end();
        Element loggingHandlerSizeRotatingFileItemElement = loggingHandlerSizeRotatingFileItemBuilder.build();
        handlebarElements.put("html117", loggingHandlerSizeRotatingFileItemBuilder.referenceFor("html117"));
        navigation.addSecondary("logging-handler-item", "logging-handler-size-rotating-file-item", "Size Handler", loggingHandlerSizeRotatingFileItemElement);
        Elements.Builder loggingHandlerAsyncItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Async Handler</h1><p>{{metadata43.getDescription().getDescription()}}</p>"))
                    .rememberAs("html120")
                .end()
                .add(asyncHandlerTable)
                .add(asyncHandlerForm)
            .end();
        Element loggingHandlerAsyncItemElement = loggingHandlerAsyncItemBuilder.build();
        handlebarElements.put("html120", loggingHandlerAsyncItemBuilder.referenceFor("html120"));
        navigation.addSecondary("logging-handler-item", "logging-handler-async-item", "Async Handler", loggingHandlerAsyncItemElement);
        Elements.Builder loggingHandlerCustomItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Handler</h1><p>{{metadata44.getDescription().getDescription()}}</p>"))
                    .rememberAs("html123")
                .end()
                .add(customHandlerTable)
                .add(customHandlerForm)
            .end();
        Element loggingHandlerCustomItemElement = loggingHandlerCustomItemBuilder.build();
        handlebarElements.put("html123", loggingHandlerCustomItemBuilder.referenceFor("html123"));
        navigation.addSecondary("logging-handler-item", "logging-handler-custom-item", "Custom Handler", loggingHandlerCustomItemElement);
        Elements.Builder loggingHandlerSyslogItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Syslog Handler</h1><p>{{metadata45.getDescription().getDescription()}}</p>"))
                    .rememberAs("html126")
                .end()
                .add(syslogHandlerTable)
                .add(syslogHandlerForm)
            .end();
        Element loggingHandlerSyslogItemElement = loggingHandlerSyslogItemBuilder.build();
        handlebarElements.put("html126", loggingHandlerSyslogItemBuilder.referenceFor("html126"));
        navigation.addSecondary("logging-handler-item", "logging-handler-syslog-item", "Syslog Handler", loggingHandlerSyslogItemElement);
        navigation.addPrimary("logging-formatter-item", "Formatter", "fa fa-paint-brush");
        Elements.Builder loggingFormatterPatternItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Pattern Formatter</h1><p>{{metadata46.getDescription().getDescription()}}</p>"))
                    .rememberAs("html129")
                .end()
                .add(patternFormatterTable)
                .add(patternFormatterForm)
            .end();
        Element loggingFormatterPatternItemElement = loggingFormatterPatternItemBuilder.build();
        handlebarElements.put("html129", loggingFormatterPatternItemBuilder.referenceFor("html129"));
        navigation.addSecondary("logging-formatter-item", "logging-formatter-pattern-item", "Pattern Formatter", loggingFormatterPatternItemElement);
        Elements.Builder loggingFormatterCustomItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Formatter</h1><p>{{metadata47.getDescription().getDescription()}}</p>"))
                    .rememberAs("html132")
                .end()
                .add(customFormatterTable)
                .add(customFormatterForm)
            .end();
        Element loggingFormatterCustomItemElement = loggingFormatterCustomItemBuilder.build();
        handlebarElements.put("html132", loggingFormatterCustomItemBuilder.referenceFor("html132"));
        navigation.addSecondary("logging-formatter-item", "logging-formatter-custom-item", "Custom Formatter", loggingFormatterCustomItemElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        registerAttachable(navigation);
        registerAttachable(loggingConfigForm);
        registerAttachable(rootLoggerForm);
        registerAttachable(loggerTable);
        registerAttachable(loggerForm);
        registerAttachable(consoleHandlerTable);
        registerAttachable(consoleHandlerForm);
        registerAttachable(fileHandlerTable);
        registerAttachable(fileHandlerForm);
        registerAttachable(periodicHandlerTable);
        registerAttachable(periodicHandlerForm);
        registerAttachable(periodicSizeHandlerTable);
        registerAttachable(periodicSizeHandlerForm);
        registerAttachable(sizeHandlerTable);
        registerAttachable(sizeHandlerForm);
        registerAttachable(asyncHandlerTable);
        registerAttachable(asyncHandlerForm);
        registerAttachable(customHandlerTable);
        registerAttachable(customHandlerForm);
        registerAttachable(syslogHandlerTable);
        registerAttachable(syslogHandlerForm);
        registerAttachable(customFormatterTable);
        registerAttachable(customFormatterForm);
        registerAttachable(patternFormatterTable);
        registerAttachable(patternFormatterForm);

        Element root = layoutBuilder.build();
        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            loggerTable.bindForm(loggerForm);
            consoleHandlerTable.bindForm(consoleHandlerForm);
            fileHandlerTable.bindForm(fileHandlerForm);
            periodicHandlerTable.bindForm(periodicHandlerForm);
            periodicSizeHandlerTable.bindForm(periodicSizeHandlerForm);
            sizeHandlerTable.bindForm(sizeHandlerForm);
            asyncHandlerTable.bindForm(asyncHandlerForm);
            customHandlerTable.bindForm(customHandlerForm);
            syslogHandlerTable.bindForm(syslogHandlerForm);
            customFormatterTable.bindForm(customFormatterForm);
            patternFormatterTable.bindForm(patternFormatterForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html98"), "{{metadata35.getDescription().getDescription()}}", String.valueOf(metadata35.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html100"), "{{metadata36.getDescription().getDescription()}}", String.valueOf(metadata36.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html102"), "{{metadata37.getDescription().getDescription()}}", String.valueOf(metadata37.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html105"), "{{metadata38.getDescription().getDescription()}}", String.valueOf(metadata38.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html108"), "{{metadata39.getDescription().getDescription()}}", String.valueOf(metadata39.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html111"), "{{metadata40.getDescription().getDescription()}}", String.valueOf(metadata40.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html114"), "{{metadata41.getDescription().getDescription()}}", String.valueOf(metadata41.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html117"), "{{metadata42.getDescription().getDescription()}}", String.valueOf(metadata42.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html120"), "{{metadata43.getDescription().getDescription()}}", String.valueOf(metadata43.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html123"), "{{metadata44.getDescription().getDescription()}}", String.valueOf(metadata44.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html126"), "{{metadata45.getDescription().getDescription()}}", String.valueOf(metadata45.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html129"), "{{metadata46.getDescription().getDescription()}}", String.valueOf(metadata46.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html132"), "{{metadata47.getDescription().getDescription()}}", String.valueOf(metadata47.getDescription().getDescription()));
    }
}
