package org.jboss.hal.client.configuration.subsystem.messaging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.FailSafeForm;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.table.NamedNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_DestinationView extends DestinationView {

    private final Metadata metadata66;
    private final Metadata metadata65;
    private final Metadata metadata64;
    private final Metadata metadata67;
    private final Metadata metadata68;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_DestinationView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata66Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/jms-topic=*");
        this.metadata66 = mbuiContext.metadataRegistry().lookup(metadata66Template);
        AddressTemplate metadata65Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/jms-queue=*");
        this.metadata65 = mbuiContext.metadataRegistry().lookup(metadata65Template);
        AddressTemplate metadata64Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/queue=*");
        this.metadata64 = mbuiContext.metadataRegistry().lookup(metadata64Template);
        AddressTemplate metadata67Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/address-setting=*");
        this.metadata67 = mbuiContext.metadataRegistry().lookup(metadata67Template);
        AddressTemplate metadata68Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/divert=*");
        this.metadata68 = mbuiContext.metadataRegistry().lookup(metadata68Template);
        this.handlebarElements = new HashMap<>();

        coreQueueForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("messaging-core-queue-form", metadata64)
            .include("queue-address", "filter", "durable")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.CORE_QUEUE, form, changedValues))
            .build();
        jmsQueueForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("messaging-jms-queue-form", metadata65)
            .include("selector", "entries", "durable")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.JMS_QUEUE, form, changedValues))
            .build();
        jmsTopicForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("messaging-jms-topic-form", metadata66)
            .include("entries")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.JMS_TOPIC, form, changedValues))
            .build();
        addressSettingForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("messaging-address-setting-form", metadata67)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.ADDRESS_SETTING, form, changedValues))
            .build();
        divertForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("messaging-divert-form", metadata68)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.DIVERT, form, changedValues))
            .build();

        Options<org.jboss.hal.dmr.model.NamedNode> coreQueueTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata64)
            .button(mbuiContext.resources().constants().add(), (event, api) -> presenter.add(ServerSubResource.CORE_QUEUE))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> presenter.remove(ServerSubResource.CORE_QUEUE, api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("queue-address")
            .build();
        coreQueueTable = new NamedNodeTable<>("messaging-core-queue-table", coreQueueTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> jmsQueueTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata65)
            .button(mbuiContext.resources().constants().add(), (event, api) -> presenter.add(ServerSubResource.JMS_QUEUE))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> presenter.remove(ServerSubResource.JMS_QUEUE, api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("selector")
            .build();
        jmsQueueTable = new NamedNodeTable<>("messaging-jms-queue-table", jmsQueueTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> jmsTopicTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata66)
            .button(mbuiContext.resources().constants().add(), (event, api) -> presenter.add(ServerSubResource.JMS_TOPIC))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> presenter.remove(ServerSubResource.JMS_TOPIC, api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        jmsTopicTable = new NamedNodeTable<>("messaging-jms-topic-table", jmsTopicTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> addressSettingTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata67)
            .button(mbuiContext.resources().constants().add(), (event, api) -> presenter.add(ServerSubResource.ADDRESS_SETTING))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> presenter.remove(ServerSubResource.ADDRESS_SETTING, api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        addressSettingTable = new NamedNodeTable<>("messaging-address-setting-table", addressSettingTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> divertTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata68)
            .button(mbuiContext.resources().constants().add(), (event, api) -> presenter.add(ServerSubResource.DIVERT))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> presenter.remove(ServerSubResource.DIVERT, api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        divertTable = new NamedNodeTable<>("messaging-divert-table", divertTableOptions);

        navigation = new VerticalNavigation();
        Elements.Builder messagingCoreQueueEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Core Queue</h1><p>{{metadata64.getDescription().getDescription()}}</p>"))
                    .rememberAs("html186")
                .end()
                .add(coreQueueTable)
                .add(coreQueueForm)
            .end();
        Element messagingCoreQueueEntryElement = messagingCoreQueueEntryBuilder.build();
        handlebarElements.put("html186", messagingCoreQueueEntryBuilder.referenceFor("html186"));
        navigation.addPrimary("messaging-core-queue-entry", "Core Queue", "fa fa-cog", messagingCoreQueueEntryElement);
        Elements.Builder messagingJmsQueueEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JMS Queue</h1><p>{{metadata65.getDescription().getDescription()}}</p>"))
                    .rememberAs("html189")
                .end()
                .add(jmsQueueTable)
                .add(jmsQueueForm)
            .end();
        Element messagingJmsQueueEntryElement = messagingJmsQueueEntryBuilder.build();
        handlebarElements.put("html189", messagingJmsQueueEntryBuilder.referenceFor("html189"));
        navigation.addPrimary("messaging-jms-queue-entry", "JMS Queue", "fa fa-long-arrow-right", messagingJmsQueueEntryElement);
        Elements.Builder messagingJmsTopicEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JMS Topic</h1><p>{{metadata66.getDescription().getDescription()}}</p>"))
                    .rememberAs("html192")
                .end()
                .add(jmsTopicTable)
                .add(jmsTopicForm)
            .end();
        Element messagingJmsTopicEntryElement = messagingJmsTopicEntryBuilder.build();
        handlebarElements.put("html192", messagingJmsTopicEntryBuilder.referenceFor("html192"));
        navigation.addPrimary("messaging-jms-topic-entry", "JMS Topic", "fa fa-arrows", messagingJmsTopicEntryElement);
        Elements.Builder messagingAddressSettingEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Address Setting</h1><p>{{metadata67.getDescription().getDescription()}}</p>"))
                    .rememberAs("html195")
                .end()
                .add(addressSettingTable)
                .add(addressSettingForm)
            .end();
        Element messagingAddressSettingEntryElement = messagingAddressSettingEntryBuilder.build();
        handlebarElements.put("html195", messagingAddressSettingEntryBuilder.referenceFor("html195"));
        navigation.addPrimary("messaging-address-setting-entry", "Address Setting", "fa fa-address-card-o", messagingAddressSettingEntryElement);
        Elements.Builder messagingDivertEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Divert</h1><p>{{metadata68.getDescription().getDescription()}}</p>"))
                    .rememberAs("html198")
                .end()
                .add(divertTable)
                .add(divertForm)
            .end();
        Element messagingDivertEntryElement = messagingDivertEntryBuilder.build();
        handlebarElements.put("html198", messagingDivertEntryBuilder.referenceFor("html198"));
        navigation.addPrimary("messaging-divert-entry", "Divert", "fa fa-exchange", messagingDivertEntryElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        registerAttachable(navigation);
        registerAttachable(coreQueueTable);
        registerAttachable(coreQueueForm);
        registerAttachable(jmsQueueTable);
        registerAttachable(jmsQueueForm);
        registerAttachable(jmsTopicTable);
        registerAttachable(jmsTopicForm);
        registerAttachable(addressSettingTable);
        registerAttachable(addressSettingForm);
        registerAttachable(divertTable);
        registerAttachable(divertForm);

        Element root = layoutBuilder.build();
        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            coreQueueTable.bindForm(coreQueueForm);
            jmsQueueTable.bindForm(jmsQueueForm);
            jmsTopicTable.bindForm(jmsTopicForm);
            addressSettingTable.bindForm(addressSettingForm);
            divertTable.bindForm(divertForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html186"), "{{metadata64.getDescription().getDescription()}}", String.valueOf(metadata64.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html189"), "{{metadata65.getDescription().getDescription()}}", String.valueOf(metadata65.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html192"), "{{metadata66.getDescription().getDescription()}}", String.valueOf(metadata66.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html195"), "{{metadata67.getDescription().getDescription()}}", String.valueOf(metadata67.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html198"), "{{metadata68.getDescription().getDescription()}}", String.valueOf(metadata68.getDescription().getDescription()));
    }
}
