package org.jboss.hal.client.configuration.subsystem.transaction;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.FailSafeForm;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.table.NamedNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_TransactionView extends TransactionView {

    private final Metadata metadata102;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_TransactionView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata102Template = AddressTemplate.of("/{selected.profile}/subsystem=transactions");
        this.metadata102 = mbuiContext.metadataRegistry().lookup(metadata102Template);
        this.handlebarElements = new HashMap<>();

        attributesForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("tx-attributes-form", metadata102)
            .include("default-timeout", "enable-tsm-status", "journal-store-enable-async-io", "jts", "node-identifier", "statistics-enabled", "use-journal-store")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Transaction Manager", metadata102Template.resolve(mbuiContext.statementContext()), changedValues, metadata102))
            .build();
        processForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("tx-process-form", metadata102)
            .include("process-id-uuid", "process-id-socket-binding", "process-id-socket-max-ports")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveProcessForm(form, changedValues))
            .build();
        processForm.getFormItem("process-id-socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        recoveryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("tx-recovery-form", metadata102)
            .include("socket-binding", "status-socket-binding", "recovery-listener")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Recovery", metadata102Template.resolve(mbuiContext.statementContext()), changedValues, metadata102))
            .build();
        recoveryForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        recoveryForm.getFormItem("status-socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        pathForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("tx-path-form", metadata102)
            .include("object-store-path", "object-store-relative-to")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Path", metadata102Template.resolve(mbuiContext.statementContext()), changedValues, metadata102))
            .build();
        pathForm.getFormItem("object-store-relative-to").registerSuggestHandler(new org.jboss.hal.client.configuration.PathsAutoComplete());
        jdbcForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("tx-jdbc-form", metadata102)
            .include("use-jdbc-store", "jdbc-action-store-drop-table", "jdbc-action-store-table-prefix", "jdbc-communication-store-drop-table", "jdbc-communication-store-table-prefix", "jdbc-state-store-drop-table", "jdbc-state-store-table-prefix", "jdbc-store-datasource")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("JDBC", metadata102Template.resolve(mbuiContext.statementContext()), changedValues, metadata102))
            .build();
        List<AddressTemplate> jdbcFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=datasources/data-source=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=datasources/xa-data-source=*"));
        jdbcForm.getFormItem("jdbc-store-datasource").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), jdbcFormTemplates));


        navigation = new VerticalNavigation();
        Elements.Builder txAttributesConfigItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Transaction Manager</h1><p>{{metadata102.getDescription().getDescription()}}</p>"))
                    .rememberAs("html290")
                .end()
                .add(attributesForm)
            .end();
        Element txAttributesConfigItemElement = txAttributesConfigItemBuilder.build();
        handlebarElements.put("html290", txAttributesConfigItemBuilder.referenceFor("html290"));
        navigation.addPrimary("tx-attributes-config-item", "Configuration", "fa fa-list-ul", txAttributesConfigItemElement);
        Elements.Builder txProcessItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Process ID</h1><p>{{metadata102.getDescription().getDescription()}}</p>"))
                    .rememberAs("html292")
                .end()
                .add(processForm)
            .end();
        Element txProcessItemElement = txProcessItemBuilder.build();
        handlebarElements.put("html292", txProcessItemBuilder.referenceFor("html292"));
        navigation.addPrimary("tx-process-item", "Process", "pficon pficon-service", txProcessItemElement);
        Elements.Builder txRecoveryConfigItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Recovery</h1><p>{{metadata102.getDescription().getDescription()}}</p>"))
                    .rememberAs("html294")
                .end()
                .add(recoveryForm)
            .end();
        Element txRecoveryConfigItemElement = txRecoveryConfigItemBuilder.build();
        handlebarElements.put("html294", txRecoveryConfigItemBuilder.referenceFor("html294"));
        navigation.addPrimary("tx-recovery-config-item", "Recovery", "fa fa-repeat", txRecoveryConfigItemElement);
        Elements.Builder txPathConfigItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Path</h1><p>{{metadata102.getDescription().getDescription()}}</p>"))
                    .rememberAs("html296")
                .end()
                .add(pathForm)
            .end();
        Element txPathConfigItemElement = txPathConfigItemBuilder.build();
        handlebarElements.put("html296", txPathConfigItemBuilder.referenceFor("html296"));
        navigation.addPrimary("tx-path-config-item", "Path", "fa fa-folder-open", txPathConfigItemElement);
        Elements.Builder txJdbcConfigItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JDBC</h1><p>{{metadata102.getDescription().getDescription()}}</p>"))
                    .rememberAs("html298")
                .end()
                .add(jdbcForm)
            .end();
        Element txJdbcConfigItemElement = txJdbcConfigItemBuilder.build();
        handlebarElements.put("html298", txJdbcConfigItemBuilder.referenceFor("html298"));
        navigation.addPrimary("tx-jdbc-config-item", "JDBC", "fa fa-database", txJdbcConfigItemElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        registerAttachable(navigation);
        registerAttachable(attributesForm);
        registerAttachable(processForm);
        registerAttachable(recoveryForm);
        registerAttachable(pathForm);
        registerAttachable(jdbcForm);

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();


        TemplateUtil.replaceHandlebar(handlebarElements.get("html290"), "{{metadata102.getDescription().getDescription()}}", String.valueOf(metadata102.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html292"), "{{metadata102.getDescription().getDescription()}}", String.valueOf(metadata102.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html294"), "{{metadata102.getDescription().getDescription()}}", String.valueOf(metadata102.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html296"), "{{metadata102.getDescription().getDescription()}}", String.valueOf(metadata102.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html298"), "{{metadata102.getDescription().getDescription()}}", String.valueOf(metadata102.getDescription().getDescription()));
    }
}
