package org.jboss.hal.client.configuration.subsystem.batch;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.table.NamedNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_BatchView extends BatchView {

    private final Metadata metadata6;
    private final Metadata metadata5;
    private final Metadata metadata2;
    private final Metadata metadata4;
    private final Metadata metadata3;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_BatchView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata6Template = AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet/thread-pool=*");
        this.metadata6 = mbuiContext.metadataRegistry().lookup(metadata6Template);
        AddressTemplate metadata5Template = AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet/thread-factory=*");
        this.metadata5 = mbuiContext.metadataRegistry().lookup(metadata5Template);
        AddressTemplate metadata2Template = AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet");
        this.metadata2 = mbuiContext.metadataRegistry().lookup(metadata2Template);
        AddressTemplate metadata4Template = AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet/jdbc-job-repository=*");
        this.metadata4 = mbuiContext.metadataRegistry().lookup(metadata4Template);
        AddressTemplate metadata3Template = AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet/in-memory-job-repository=*");
        this.metadata3 = mbuiContext.metadataRegistry().lookup(metadata3Template);
        this.handlebarElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("batch-configuration-form", metadata2)
            .onSave((form, changedValues) -> saveSingletonForm("Subsystem", metadata2Template.resolve(mbuiContext.statementContext()), changedValues, metadata2))
            .prepareReset(form -> resetSingletonForm("Subsystem", metadata2Template.resolve(mbuiContext.statementContext()), form, metadata2))
            .build();
        jdbcJobRepoForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("batch-jdbc-job-repo-form", metadata4)
            .include("data-source")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("JDBC Job Repository", name, metadata4Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata4);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("JDBC Job Repository", name, metadata4Template.resolve(mbuiContext.statementContext(), name), form, metadata4);
            })
            .build();
        jdbcJobRepoForm.getFormItem("data-source").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=datasources/data-source=*")));
        threadFactoryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("batch-thread-factory-form", metadata5)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Thread Factory", name, metadata5Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata5);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Thread Factory", name, metadata5Template.resolve(mbuiContext.statementContext(), name), form, metadata5);
            })
            .build();
        threadPoolForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("batch-thread-pool-form", metadata6)
            .include("name", "max-threads", "thread-factory")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Thread Pool", name, metadata6Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata6);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Thread Pool", name, metadata6Template.resolve(mbuiContext.statementContext(), name), form, metadata6);
            })
            .build();
        threadPoolForm.getFormItem("thread-factory").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet/thread-factory=*")));

        Options<org.jboss.hal.dmr.model.NamedNode> inMemoryJobRepoTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata3)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("batch-in-memory-job-repo-table", Ids.ADD_SUFFIX), "In Memory Job",
                metadata3Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("In Memory Job", metadata3Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        inMemoryJobRepoTable = new NamedNodeTable<>("batch-in-memory-job-repo-table", inMemoryJobRepoTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> jdbcJobRepoTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata4)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("batch-jdbc-job-repo-table", Ids.ADD_SUFFIX), "JDBC Job Repository",
                metadata4Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("JDBC Job Repository", metadata4Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        jdbcJobRepoTable = new NamedNodeTable<>("batch-jdbc-job-repo-table", jdbcJobRepoTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> threadFactoryTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata5)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("batch-thread-factory-table", Ids.ADD_SUFFIX), "Thread Factory",
                metadata5Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Thread Factory", metadata5Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        threadFactoryTable = new NamedNodeTable<>("batch-thread-factory-table", threadFactoryTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> threadPoolTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata6)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("batch-thread-pool-table", Ids.ADD_SUFFIX), "Thread Pool",
                metadata6Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Thread Pool", metadata6Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        threadPoolTable = new NamedNodeTable<>("batch-thread-pool-table", threadPoolTableOptions);

        navigation = new VerticalNavigation();
        Elements.Builder batchConfigurationItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>{{metadata2.getDescription().getDescription()}}</p>"))
                    .rememberAs("html5")
                .end()
                .add(configurationForm)
            .end();
        Element batchConfigurationItemElement = batchConfigurationItemBuilder.build();
        handlebarElements.put("html5", batchConfigurationItemBuilder.referenceFor("html5"));
        navigation.addPrimary("batch-configuration-item", "Configuration", "pficon pficon-settings", batchConfigurationItemElement);
        Elements.Builder batchInMemoryJobRepoItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>In Memory Job Repository</h1><p>{{metadata3.getDescription().getDescription()}}</p>"))
                    .rememberAs("html7")
                .end()
                .add(inMemoryJobRepoTable)
            .end();
        Element batchInMemoryJobRepoItemElement = batchInMemoryJobRepoItemBuilder.build();
        handlebarElements.put("html7", batchInMemoryJobRepoItemBuilder.referenceFor("html7"));
        navigation.addPrimary("batch-in-memory-job-repo-item", "In Memory", "pficon pficon-memory", batchInMemoryJobRepoItemElement);
        Elements.Builder batchJdbcJobRepoItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JDBC Job Repository</h1><p>{{metadata4.getDescription().getDescription()}}</p>"))
                    .rememberAs("html9")
                .end()
                .add(jdbcJobRepoTable)
                .add(jdbcJobRepoForm)
            .end();
        Element batchJdbcJobRepoItemElement = batchJdbcJobRepoItemBuilder.build();
        handlebarElements.put("html9", batchJdbcJobRepoItemBuilder.referenceFor("html9"));
        navigation.addPrimary("batch-jdbc-job-repo-item", "JDBC", "fa fa-database", batchJdbcJobRepoItemElement);
        Elements.Builder batchThreadFactoryItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Thread Factory</h1><p>{{metadata5.getDescription().getDescription()}}</p>"))
                    .rememberAs("html12")
                .end()
                .add(threadFactoryTable)
                .add(threadFactoryForm)
            .end();
        Element batchThreadFactoryItemElement = batchThreadFactoryItemBuilder.build();
        handlebarElements.put("html12", batchThreadFactoryItemBuilder.referenceFor("html12"));
        navigation.addPrimary("batch-thread-factory-item", "Thread Factory", "pficon pficon-service", batchThreadFactoryItemElement);
        Elements.Builder batchThreadPoolItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Thread Pool</h1><p>{{metadata6.getDescription().getDescription()}}</p>"))
                    .rememberAs("html15")
                .end()
                .add(threadPoolTable)
                .add(threadPoolForm)
            .end();
        Element batchThreadPoolItemElement = batchThreadPoolItemBuilder.build();
        handlebarElements.put("html15", batchThreadPoolItemBuilder.referenceFor("html15"));
        navigation.addPrimary("batch-thread-pool-item", "Thread Pool", "pficon pficon-resource-pool", batchThreadPoolItemElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(inMemoryJobRepoTable);
        registerAttachable(jdbcJobRepoTable);
        registerAttachable(jdbcJobRepoForm);
        registerAttachable(threadFactoryTable);
        registerAttachable(threadFactoryForm);
        registerAttachable(threadPoolTable);
        registerAttachable(threadPoolForm);

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            jdbcJobRepoTable.bindForm(jdbcJobRepoForm);
            threadFactoryTable.bindForm(threadFactoryForm);
            threadPoolTable.bindForm(threadPoolForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html5"), "{{metadata2.getDescription().getDescription()}}", String.valueOf(metadata2.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html7"), "{{metadata3.getDescription().getDescription()}}", String.valueOf(metadata3.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html9"), "{{metadata4.getDescription().getDescription()}}", String.valueOf(metadata4.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html12"), "{{metadata5.getDescription().getDescription()}}", String.valueOf(metadata5.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html15"), "{{metadata6.getDescription().getDescription()}}", String.valueOf(metadata6.getDescription().getDescription()));
    }
}
