package org.jboss.hal.client.configuration.subsystem.messaging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.table.NamedNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_ClusteringView extends ClusteringView {

    private final Metadata metadata52;
    private final Metadata metadata48;
    private final Metadata metadata50;
    private final Metadata metadata51;
    private final Metadata metadata49;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_ClusteringView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata52Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/bridge=*");
        this.metadata52 = mbuiContext.metadataRegistry().lookup(metadata52Template);
        AddressTemplate metadata48Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/broadcast-group=*");
        this.metadata48 = mbuiContext.metadataRegistry().lookup(metadata48Template);
        AddressTemplate metadata50Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/cluster-connection=*");
        this.metadata50 = mbuiContext.metadataRegistry().lookup(metadata50Template);
        AddressTemplate metadata51Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/grouping-handler=*");
        this.metadata51 = mbuiContext.metadataRegistry().lookup(metadata51Template);
        AddressTemplate metadata49Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/discovery-group=*");
        this.metadata49 = mbuiContext.metadataRegistry().lookup(metadata49Template);
        this.handlebarElements = new HashMap<>();

        broadcastGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("messaging-broadcast-group-form", metadata48)
            .include("broadcast-period", "connectors", "jgroups-channel", "jgroups-stack", "socket-binding")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.BROADCAST_GROUP, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.BROADCAST_GROUP, form))
            .build();
        broadcastGroupForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        discoveryGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("messaging-discovery-group-form", metadata49)
            .include("initial-wait-timeout", "refresh-timeout", "jgroups-channel", "jgroups-stack", "socket-binding")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.DISCOVERY_GROUP, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.DISCOVERY_GROUP, form))
            .build();
        discoveryGroupForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        clusterConnectionForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("messaging-cluster-connection-form", metadata50)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.CLUSTER_CONNECTION, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.CLUSTER_CONNECTION, form))
            .build();
        groupingHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("messaging-grouping-handler-form", metadata51)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.GROUPING_HANDLER, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.GROUPING_HANDLER, form))
            .build();
        bridgeForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("messaging-bridge-form", metadata52)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.BRIDGE, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.BRIDGE, form))
            .build();

        Options<org.jboss.hal.dmr.model.NamedNode> broadcastGroupTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata48)
            .button(mbuiContext.resources().constants().add(), (event, api) -> presenter.add(ServerSubResource.BROADCAST_GROUP))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> presenter.remove(ServerSubResource.BROADCAST_GROUP, api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        broadcastGroupTable = new NamedNodeTable<>("messaging-broadcast-group-table", broadcastGroupTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> discoveryGroupTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata49)
            .button(mbuiContext.resources().constants().add(), (event, api) -> presenter.add(ServerSubResource.DISCOVERY_GROUP))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> presenter.remove(ServerSubResource.DISCOVERY_GROUP, api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        discoveryGroupTable = new NamedNodeTable<>("messaging-discovery-group-table", discoveryGroupTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> clusterConnectionTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata50)
            .button(mbuiContext.resources().constants().add(), (event, api) -> presenter.addClusterConnection(ServerSubResource.CLUSTER_CONNECTION))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> presenter.remove(ServerSubResource.CLUSTER_CONNECTION, api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        clusterConnectionTable = new NamedNodeTable<>("messaging-cluster-connection-table", clusterConnectionTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> groupingHandlerTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata51)
            .button(mbuiContext.resources().constants().add(), (event, api) -> presenter.add(ServerSubResource.GROUPING_HANDLER))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> presenter.remove(ServerSubResource.GROUPING_HANDLER, api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        groupingHandlerTable = new NamedNodeTable<>("messaging-grouping-handler-table", groupingHandlerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> bridgeTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata52)
            .button(mbuiContext.resources().constants().add(), (event, api) -> presenter.addBridge(ServerSubResource.BRIDGE))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> presenter.remove(ServerSubResource.BRIDGE, api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        bridgeTable = new NamedNodeTable<>("messaging-bridge-table", bridgeTableOptions);

        navigation = new VerticalNavigation();
        Elements.Builder messagingBroadcastGroupEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Broadcast Group</h1><p>{{metadata48.getDescription().getDescription()}}</p>"))
                    .rememberAs("html136")
                .end()
                .add(broadcastGroupTable)
                .add(broadcastGroupForm)
            .end();
        Element messagingBroadcastGroupEntryElement = messagingBroadcastGroupEntryBuilder.build();
        handlebarElements.put("html136", messagingBroadcastGroupEntryBuilder.referenceFor("html136"));
        navigation.addPrimary("messaging-broadcast-group-entry", "Broadcast Group", "fa fa-video-camera", messagingBroadcastGroupEntryElement);
        Elements.Builder messagingDiscoveryGroupEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Discovery Group</h1><p>{{metadata49.getDescription().getDescription()}}</p>"))
                    .rememberAs("html139")
                .end()
                .add(discoveryGroupTable)
                .add(discoveryGroupForm)
            .end();
        Element messagingDiscoveryGroupEntryElement = messagingDiscoveryGroupEntryBuilder.build();
        handlebarElements.put("html139", messagingDiscoveryGroupEntryBuilder.referenceFor("html139"));
        navigation.addPrimary("messaging-discovery-group-entry", "Discovery Group", "fa fa-map-o", messagingDiscoveryGroupEntryElement);
        Elements.Builder messagingClusterConnectionEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Cluster Connection</h1><p>{{metadata50.getDescription().getDescription()}}</p>"))
                    .rememberAs("html142")
                .end()
                .add(clusterConnectionTable)
                .add(clusterConnectionForm)
            .end();
        Element messagingClusterConnectionEntryElement = messagingClusterConnectionEntryBuilder.build();
        handlebarElements.put("html142", messagingClusterConnectionEntryBuilder.referenceFor("html142"));
        navigation.addPrimary("messaging-cluster-connection-entry", "Cluster Connection", "pficon pficon-network", messagingClusterConnectionEntryElement);
        Elements.Builder messagingGroupingHandlerEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Grouping Handler</h1><p>{{metadata51.getDescription().getDescription()}}</p>"))
                    .rememberAs("html145")
                .end()
                .add(groupingHandlerTable)
                .add(groupingHandlerForm)
            .end();
        Element messagingGroupingHandlerEntryElement = messagingGroupingHandlerEntryBuilder.build();
        handlebarElements.put("html145", messagingGroupingHandlerEntryBuilder.referenceFor("html145"));
        navigation.addPrimary("messaging-grouping-handler-entry", "Grouping Handler", "fa fa-object-group", messagingGroupingHandlerEntryElement);
        Elements.Builder messagingBridgeEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Bridge</h1><p>{{metadata52.getDescription().getDescription()}}</p>"))
                    .rememberAs("html148")
                .end()
                .add(bridgeTable)
                .add(bridgeForm)
            .end();
        Element messagingBridgeEntryElement = messagingBridgeEntryBuilder.build();
        handlebarElements.put("html148", messagingBridgeEntryBuilder.referenceFor("html148"));
        navigation.addPrimary("messaging-bridge-entry", "Bridge", "fa fa-road", messagingBridgeEntryElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        registerAttachable(navigation);
        registerAttachable(broadcastGroupTable);
        registerAttachable(broadcastGroupForm);
        registerAttachable(discoveryGroupTable);
        registerAttachable(discoveryGroupForm);
        registerAttachable(clusterConnectionTable);
        registerAttachable(clusterConnectionForm);
        registerAttachable(groupingHandlerTable);
        registerAttachable(groupingHandlerForm);
        registerAttachable(bridgeTable);
        registerAttachable(bridgeForm);

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            broadcastGroupTable.bindForm(broadcastGroupForm);
            discoveryGroupTable.bindForm(discoveryGroupForm);
            clusterConnectionTable.bindForm(clusterConnectionForm);
            groupingHandlerTable.bindForm(groupingHandlerForm);
            bridgeTable.bindForm(bridgeForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html136"), "{{metadata48.getDescription().getDescription()}}", String.valueOf(metadata48.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html139"), "{{metadata49.getDescription().getDescription()}}", String.valueOf(metadata49.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html142"), "{{metadata50.getDescription().getDescription()}}", String.valueOf(metadata50.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html145"), "{{metadata51.getDescription().getDescription()}}", String.valueOf(metadata51.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html148"), "{{metadata52.getDescription().getDescription()}}", String.valueOf(metadata52.getDescription().getDescription()));
    }
}
