package org.jboss.hal.client.configuration.subsystem.messaging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.table.NamedNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_ServerView extends ServerView {

    private final Metadata metadata73;
    private final Metadata metadata72;
    private final Metadata metadata74;
    private final Metadata metadata71;
    private final Metadata metadata75;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_ServerView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata73Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/path=bindings-directory");
        this.metadata73 = mbuiContext.metadataRegistry().lookup(metadata73Template);
        AddressTemplate metadata72Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/path=paging-directory");
        this.metadata72 = mbuiContext.metadataRegistry().lookup(metadata72Template);
        AddressTemplate metadata74Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/path=large-messages-directory");
        this.metadata74 = mbuiContext.metadataRegistry().lookup(metadata74Template);
        AddressTemplate metadata71Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*");
        this.metadata71 = mbuiContext.metadataRegistry().lookup(metadata71Template);
        AddressTemplate metadata75Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/path=journal-directory");
        this.metadata75 = mbuiContext.metadataRegistry().lookup(metadata75Template);
        this.handlebarElements = new HashMap<>();

        form = new GroupedForm.Builder<org.jboss.hal.dmr.model.NamedNode>("messaging-server-form", metadata71)
            .attributeGroup("management").end()
            .attributeGroup("security").end()
            .attributeGroup("journal").end()
            .attributeGroup("cluster").end()
            .attributeGroup("message-expiry").end()
            .attributeGroup("transaction").end()
            .attributeGroup("statistics").end()
            .attributeGroup("debug").end()
            .onSave((form, changedValues) -> presenter.saveServer(changedValues))
            .prepareReset(form -> presenter.resetServer(form))
            .build();
        pagingDirectoryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("messaging-server-paging-directory-form", metadata72)
            .singleton(
                () -> new Operation.Builder(READ_RESOURCE_OPERATION, metadata72Template.resolve(mbuiContext.statementContext())).build(),
                () -> addSingleton("messaging-server-paging-directory-form", "Paging Directory", metadata72Template))
            .prepareRemove(form -> removeSingletonForm("Paging Directory", metadata72Template.resolve(mbuiContext.statementContext()), form))
            .onSave((form, changedValues) -> saveSingletonForm("Paging Directory", metadata72Template.resolve(mbuiContext.statementContext()), changedValues, metadata72))
            .build();
        bindingsDirectoryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("messaging-server-bindings-directory-form", metadata73)
            .singleton(
                () -> new Operation.Builder(READ_RESOURCE_OPERATION, metadata73Template.resolve(mbuiContext.statementContext())).build(),
                () -> addSingleton("messaging-server-bindings-directory-form", "Bindings Directory", metadata73Template))
            .prepareRemove(form -> removeSingletonForm("Bindings Directory", metadata73Template.resolve(mbuiContext.statementContext()), form))
            .onSave((form, changedValues) -> saveSingletonForm("Bindings Directory", metadata73Template.resolve(mbuiContext.statementContext()), changedValues, metadata73))
            .build();
        largeMessagesDirectoryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("messaging-server-large-messages-directory-form", metadata74)
            .singleton(
                () -> new Operation.Builder(READ_RESOURCE_OPERATION, metadata74Template.resolve(mbuiContext.statementContext())).build(),
                () -> addSingleton("messaging-server-large-messages-directory-form", "Large Messages Directory", metadata74Template))
            .prepareRemove(form -> removeSingletonForm("Large Messages Directory", metadata74Template.resolve(mbuiContext.statementContext()), form))
            .onSave((form, changedValues) -> saveSingletonForm("Large Messages Directory", metadata74Template.resolve(mbuiContext.statementContext()), changedValues, metadata74))
            .build();
        journalDirectoryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("messaging-server-journal-directory-form", metadata75)
            .singleton(
                () -> new Operation.Builder(READ_RESOURCE_OPERATION, metadata75Template.resolve(mbuiContext.statementContext())).build(),
                () -> addSingleton("messaging-server-journal-directory-form", "Journal Directory", metadata75Template))
            .prepareRemove(form -> removeSingletonForm("Journal Directory", metadata75Template.resolve(mbuiContext.statementContext()), form))
            .onSave((form, changedValues) -> saveSingletonForm("Journal Directory", metadata75Template.resolve(mbuiContext.statementContext()), changedValues, metadata75))
            .build();


        verticalNavigation = new VerticalNavigation();
        Elements.Builder messagingServerEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Messaging Server</h1><p>{{metadata71.getDescription().getDescription()}}</p>"))
                    .rememberAs("html206")
                .end()
                .add(form)
            .end();
        Element messagingServerEntryElement = messagingServerEntryBuilder.build();
        handlebarElements.put("html206", messagingServerEntryBuilder.referenceFor("html206"));
        verticalNavigation.addPrimary("messaging-server-entry", "Configuration", "pficon pficon-settings", messagingServerEntryElement);
        verticalNavigation.addPrimary("messaging-server-directory-entry", "Directories", "pficon pficon-repository");
        Elements.Builder messagingServerPagingDirectoryEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Paging Directory</h1><p>{{metadata72.getDescription().getDescription()}}</p>"))
                    .rememberAs("html208")
                .end()
                .add(pagingDirectoryForm)
            .end();
        Element messagingServerPagingDirectoryEntryElement = messagingServerPagingDirectoryEntryBuilder.build();
        handlebarElements.put("html208", messagingServerPagingDirectoryEntryBuilder.referenceFor("html208"));
        verticalNavigation.addSecondary("messaging-server-directory-entry", "messaging-server-paging-directory-entry", "Paging", messagingServerPagingDirectoryEntryElement);
        Elements.Builder messagingServerBindingsDirectoryEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Bindings Directory</h1><p>{{metadata73.getDescription().getDescription()}}</p>"))
                    .rememberAs("html210")
                .end()
                .add(bindingsDirectoryForm)
            .end();
        Element messagingServerBindingsDirectoryEntryElement = messagingServerBindingsDirectoryEntryBuilder.build();
        handlebarElements.put("html210", messagingServerBindingsDirectoryEntryBuilder.referenceFor("html210"));
        verticalNavigation.addSecondary("messaging-server-directory-entry", "messaging-server-bindings-directory-entry", "Bindings", messagingServerBindingsDirectoryEntryElement);
        Elements.Builder messagingServerLargeMessagesDirectoryEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Large Messages Directory</h1><p>{{metadata74.getDescription().getDescription()}}</p>"))
                    .rememberAs("html212")
                .end()
                .add(largeMessagesDirectoryForm)
            .end();
        Element messagingServerLargeMessagesDirectoryEntryElement = messagingServerLargeMessagesDirectoryEntryBuilder.build();
        handlebarElements.put("html212", messagingServerLargeMessagesDirectoryEntryBuilder.referenceFor("html212"));
        verticalNavigation.addSecondary("messaging-server-directory-entry", "messaging-server-large-messages-directory-entry", "Large Messages", messagingServerLargeMessagesDirectoryEntryElement);
        Elements.Builder messagingServerJournalDirectoryEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Journal Directory</h1><p>{{metadata75.getDescription().getDescription()}}</p>"))
                    .rememberAs("html214")
                .end()
                .add(journalDirectoryForm)
            .end();
        Element messagingServerJournalDirectoryEntryElement = messagingServerJournalDirectoryEntryBuilder.build();
        handlebarElements.put("html214", messagingServerJournalDirectoryEntryBuilder.referenceFor("html214"));
        verticalNavigation.addSecondary("messaging-server-directory-entry", "messaging-server-journal-directory-entry", "Journal", messagingServerJournalDirectoryEntryElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(verticalNavigation.panes())
                .end()
            .end();

        registerAttachable(verticalNavigation);
        registerAttachable(form);
        registerAttachable(pagingDirectoryForm);
        registerAttachable(bindingsDirectoryForm);
        registerAttachable(largeMessagesDirectoryForm);
        registerAttachable(journalDirectoryForm);

        Element root = layoutBuilder.build();
        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();


        TemplateUtil.replaceHandlebar(handlebarElements.get("html206"), "{{metadata71.getDescription().getDescription()}}", String.valueOf(metadata71.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html208"), "{{metadata72.getDescription().getDescription()}}", String.valueOf(metadata72.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html210"), "{{metadata73.getDescription().getDescription()}}", String.valueOf(metadata73.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html212"), "{{metadata74.getDescription().getDescription()}}", String.valueOf(metadata74.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html214"), "{{metadata75.getDescription().getDescription()}}", String.valueOf(metadata75.getDescription().getDescription()));
    }
}
