package org.jboss.hal.client.configuration.subsystem.security;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.table.NamedNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_SecurityDomainView extends SecurityDomainView {

    private final Metadata metadata94;
    private final Metadata metadata89;
    private final Metadata metadata90;
    private final Metadata metadata93;
    private final Metadata metadata91;
    private final Metadata metadata92;
    private final Metadata metadata88;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_SecurityDomainView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata94Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/identity-trust=classic/trust-module=*");
        this.metadata94 = mbuiContext.metadataRegistry().lookup(metadata94Template);
        AddressTemplate metadata89Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/authentication=classic/login-module=*");
        this.metadata89 = mbuiContext.metadataRegistry().lookup(metadata89Template);
        AddressTemplate metadata90Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/authorization=classic/policy-module=*");
        this.metadata90 = mbuiContext.metadataRegistry().lookup(metadata90Template);
        AddressTemplate metadata93Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/mapping=classic/mapping-module=*");
        this.metadata93 = mbuiContext.metadataRegistry().lookup(metadata93Template);
        AddressTemplate metadata91Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/audit=classic/provider-module=*");
        this.metadata91 = mbuiContext.metadataRegistry().lookup(metadata91Template);
        AddressTemplate metadata92Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/acl=classic/acl-module=*");
        this.metadata92 = mbuiContext.metadataRegistry().lookup(metadata92Template);
        AddressTemplate metadata88Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*");
        this.metadata88 = mbuiContext.metadataRegistry().lookup(metadata88Template);
        this.handlebarElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("security-domain-configuration-form", metadata88)
            .onSave((form, changedValues) -> presenter.saveSecurityDomain(changedValues))
            .prepareReset(form -> presenter.resetSecurityDomain(form))
            .build();
        authenticationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("security-domain-authentication-form", metadata89)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.AUTHENTICATION))
            .prepareReset(form -> presenter.resetModule(form, Module.AUTHENTICATION))
            .build();
        authorizationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("security-domain-authorization-form", metadata90)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.AUTHORIZATION))
            .prepareReset(form -> presenter.resetModule(form, Module.AUTHORIZATION))
            .build();
        auditForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("security-domain-audit-form", metadata91)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.AUDIT))
            .prepareReset(form -> presenter.resetModule(form, Module.AUDIT))
            .build();
        aclForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("security-domain-acl-form", metadata92)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.ACL))
            .prepareReset(form -> presenter.resetModule(form, Module.ACL))
            .build();
        trustForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("security-domain-trust-form", metadata94)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.TRUST))
            .prepareReset(form -> presenter.resetModule(form, Module.TRUST))
            .build();
        mappingForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("security-domain-mapping-form", metadata93)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.MAPPING))
            .prepareReset(form -> presenter.resetModule(form, Module.MAPPING))
            .build();

        Options<org.jboss.hal.dmr.model.NamedNode> authenticationTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata89)
            .button(mbuiContext.resources().constants().add(), (event, api) -> presenter.addClassicAuthenticationModule())
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> presenter.removeModule(api, Module.AUTHENTICATION))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        authenticationTable = new NamedNodeTable<>("security-domain-authentication-table", authenticationTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> authorizationTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata90)
            .button(mbuiContext.resources().constants().add(), (event, api) -> presenter.addModule(Module.AUTHORIZATION))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> presenter.removeModule(api, Module.AUTHORIZATION))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        authorizationTable = new NamedNodeTable<>("security-domain-authorization-table", authorizationTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> auditTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata91)
            .button(mbuiContext.resources().constants().add(), (event, api) -> presenter.addModule(Module.AUDIT))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> presenter.removeModule(api, Module.AUDIT))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        auditTable = new NamedNodeTable<>("security-domain-audit-table", auditTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> aclTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata92)
            .button(mbuiContext.resources().constants().add(), (event, api) -> presenter.addModule(Module.ACL))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> presenter.removeModule(api, Module.ACL))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        aclTable = new NamedNodeTable<>("security-domain-acl-table", aclTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> trustTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata94)
            .button(mbuiContext.resources().constants().add(), (event, api) -> presenter.addModule(Module.TRUST))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> presenter.removeModule(api, Module.TRUST))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        trustTable = new NamedNodeTable<>("security-domain-trust-table", trustTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> mappingTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata93)
            .button(mbuiContext.resources().constants().add(), (event, api) -> presenter.addModule(Module.MAPPING))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, (event, api) -> presenter.removeModule(api, Module.MAPPING))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        mappingTable = new NamedNodeTable<>("security-domain-mapping-table", mappingTableOptions);

        navigation = new VerticalNavigation();
        Elements.Builder securityDomainConfigurationItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>{{metadata88.getDescription().getDescription()}}</p>"))
                    .rememberAs("html249")
                .end()
                .add(configurationForm)
            .end();
        Element securityDomainConfigurationItemElement = securityDomainConfigurationItemBuilder.build();
        handlebarElements.put("html249", securityDomainConfigurationItemBuilder.referenceFor("html249"));
        navigation.addPrimary("security-domain-configuration-item", "Configuration", "pficon pficon-settings", securityDomainConfigurationItemElement);
        Elements.Builder securityDomainAuthenticationItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Authentication Module</h1><p>{{metadata89.getDescription().getDescription()}}</p>"))
                    .rememberAs("html251")
                .end()
                .add(authenticationTable)
                .add(authenticationForm)
            .end();
        Element securityDomainAuthenticationItemElement = securityDomainAuthenticationItemBuilder.build();
        handlebarElements.put("html251", securityDomainAuthenticationItemBuilder.referenceFor("html251"));
        navigation.addPrimary("security-domain-authentication-item", "Authentication", "fa fa-sign-in", securityDomainAuthenticationItemElement);
        Elements.Builder securityDomainAuthorizationItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Authorization Module</h1><p>{{metadata90.getDescription().getDescription()}}</p>"))
                    .rememberAs("html254")
                .end()
                .add(authorizationTable)
                .add(authorizationForm)
            .end();
        Element securityDomainAuthorizationItemElement = securityDomainAuthorizationItemBuilder.build();
        handlebarElements.put("html254", securityDomainAuthorizationItemBuilder.referenceFor("html254"));
        navigation.addPrimary("security-domain-authorization-item", "Authorization", "fa fa-shield", securityDomainAuthorizationItemElement);
        Elements.Builder securityDomainAuditItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Audit Module</h1><p>{{metadata91.getDescription().getDescription()}}</p>"))
                    .rememberAs("html257")
                .end()
                .add(auditTable)
                .add(auditForm)
            .end();
        Element securityDomainAuditItemElement = securityDomainAuditItemBuilder.build();
        handlebarElements.put("html257", securityDomainAuditItemBuilder.referenceFor("html257"));
        navigation.addPrimary("security-domain-audit-item", "Audit", "fa fa-file-text-o", securityDomainAuditItemElement);
        Elements.Builder securityDomainAclItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>ACL Module</h1><p>{{metadata92.getDescription().getDescription()}}</p>"))
                    .rememberAs("html260")
                .end()
                .add(aclTable)
                .add(aclForm)
            .end();
        Element securityDomainAclItemElement = securityDomainAclItemBuilder.build();
        handlebarElements.put("html260", securityDomainAclItemBuilder.referenceFor("html260"));
        navigation.addPrimary("security-domain-acl-item", "ACL", "fa fa-lock", securityDomainAclItemElement);
        Elements.Builder securityDomainMappingItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Mapping Module</h1><p>{{metadata93.getDescription().getDescription()}}</p>"))
                    .rememberAs("html263")
                .end()
                .add(mappingTable)
                .add(mappingForm)
            .end();
        Element securityDomainMappingItemElement = securityDomainMappingItemBuilder.build();
        handlebarElements.put("html263", securityDomainMappingItemBuilder.referenceFor("html263"));
        navigation.addPrimary("security-domain-mapping-item", "Mapping", "fa fa-exchange", securityDomainMappingItemElement);
        Elements.Builder securityDomainTrustItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Trust Module</h1><p>{{metadata94.getDescription().getDescription()}}</p>"))
                    .rememberAs("html266")
                .end()
                .add(trustTable)
                .add(trustForm)
            .end();
        Element securityDomainTrustItemElement = securityDomainTrustItemBuilder.build();
        handlebarElements.put("html266", securityDomainTrustItemBuilder.referenceFor("html266"));
        navigation.addPrimary("security-domain-trust-item", "Identity Trust", "fa fa-handshake-o", securityDomainTrustItemElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(authenticationTable);
        registerAttachable(authenticationForm);
        registerAttachable(authorizationTable);
        registerAttachable(authorizationForm);
        registerAttachable(auditTable);
        registerAttachable(auditForm);
        registerAttachable(aclTable);
        registerAttachable(aclForm);
        registerAttachable(trustTable);
        registerAttachable(trustForm);
        registerAttachable(mappingTable);
        registerAttachable(mappingForm);

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            authenticationTable.bindForm(authenticationForm);
            authorizationTable.bindForm(authorizationForm);
            auditTable.bindForm(auditForm);
            aclTable.bindForm(aclForm);
            trustTable.bindForm(trustForm);
            mappingTable.bindForm(mappingForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html249"), "{{metadata88.getDescription().getDescription()}}", String.valueOf(metadata88.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html251"), "{{metadata89.getDescription().getDescription()}}", String.valueOf(metadata89.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html254"), "{{metadata90.getDescription().getDescription()}}", String.valueOf(metadata90.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html257"), "{{metadata91.getDescription().getDescription()}}", String.valueOf(metadata91.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html260"), "{{metadata92.getDescription().getDescription()}}", String.valueOf(metadata92.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html263"), "{{metadata93.getDescription().getDescription()}}", String.valueOf(metadata93.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html266"), "{{metadata94.getDescription().getDescription()}}", String.valueOf(metadata94.getDescription().getDescription()));
    }
}
