package org.jboss.hal.client.configuration.subsystem.security;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.table.NamedNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_SecurityView extends SecurityView {

    private final Metadata metadata97;
    private final Metadata metadata100;
    private final Metadata metadata98;
    private final Metadata metadata96;
    private final Metadata metadata101;
    private final Metadata metadata99;
    private final Metadata metadata95;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_SecurityView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata97Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-key-store=*");
        this.metadata97 = mbuiContext.metadataRegistry().lookup(metadata97Template);
        AddressTemplate metadata100Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-trust-store=*");
        this.metadata100 = mbuiContext.metadataRegistry().lookup(metadata100Template);
        AddressTemplate metadata98Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-realm=*");
        this.metadata98 = mbuiContext.metadataRegistry().lookup(metadata98Template);
        AddressTemplate metadata96Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-key-manager=*");
        this.metadata96 = mbuiContext.metadataRegistry().lookup(metadata96Template);
        AddressTemplate metadata101Template = AddressTemplate.of("/{selected.profile}/subsystem=security/vault=classic");
        this.metadata101 = mbuiContext.metadataRegistry().lookup(metadata101Template);
        AddressTemplate metadata99Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-trust-manager=*");
        this.metadata99 = mbuiContext.metadataRegistry().lookup(metadata99Template);
        AddressTemplate metadata95Template = AddressTemplate.of("/{selected.profile}/subsystem=security");
        this.metadata95 = mbuiContext.metadataRegistry().lookup(metadata95Template);
        this.handlebarElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("security-configuration-form", metadata95)
            .onSave((form, changedValues) -> saveSingletonForm("Configuration", metadata95Template.resolve(mbuiContext.statementContext()), changedValues, metadata95))
            .prepareReset(form -> resetSingletonForm("Configuration", metadata95Template.resolve(mbuiContext.statementContext()), form, metadata95))
            .build();
        keyManagerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("security-elytron-key-manager-form", metadata96)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Key Manager", name, metadata96Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata96);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Key Manager", name, metadata96Template.resolve(mbuiContext.statementContext(), name), form, metadata96);
            })
            .build();
        keyStoreForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("security-elytron-key-store-form", metadata97)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Key Store", name, metadata97Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata97);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Key Store", name, metadata97Template.resolve(mbuiContext.statementContext(), name), form, metadata97);
            })
            .build();
        realmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("security-elytron-realm-form", metadata98)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Realm", name, metadata98Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata98);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Realm", name, metadata98Template.resolve(mbuiContext.statementContext(), name), form, metadata98);
            })
            .build();
        trustManagerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("security-elytron-trust-manager-form", metadata99)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Trust Manager", name, metadata99Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata99);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Trust Manager", name, metadata99Template.resolve(mbuiContext.statementContext(), name), form, metadata99);
            })
            .build();
        trustStoreForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("security-elytron-trust-store-form", metadata100)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Trust Store", name, metadata100Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata100);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Trust Store", name, metadata100Template.resolve(mbuiContext.statementContext(), name), form, metadata100);
            })
            .build();
        vaultForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("security-vault-form", metadata101)
            .singleton(
                () -> new Operation.Builder(READ_RESOURCE_OPERATION, metadata101Template.resolve(mbuiContext.statementContext())).build(),
                () -> addSingleton("security-vault-form", "Vault", metadata101Template))
            .prepareRemove(form -> removeSingletonForm("Vault", metadata101Template.resolve(mbuiContext.statementContext()), form))
            .onSave((form, changedValues) -> saveSingletonForm("Vault", metadata101Template.resolve(mbuiContext.statementContext()), changedValues, metadata101))
            .prepareReset(form -> resetSingletonForm("Vault", metadata101Template.resolve(mbuiContext.statementContext()), form, metadata101))
            .build();

        Options<org.jboss.hal.dmr.model.NamedNode> keyManagerTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata96)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-key-manager-table", Ids.ADD_SUFFIX), "Elytron Key Manager",
                metadata96Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Key Manager", metadata96Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();
        keyManagerTable = new NamedNodeTable<>("security-elytron-key-manager-table", keyManagerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> keyStoreTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata97)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-key-store-table", Ids.ADD_SUFFIX), "Elytron Key Store",
                metadata97Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Key Store", metadata97Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();
        keyStoreTable = new NamedNodeTable<>("security-elytron-key-store-table", keyStoreTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> realmTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata98)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-realm-table", Ids.ADD_SUFFIX), "Elytron Realm",
                metadata98Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Realm", metadata98Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jaas-config")
            .build();
        realmTable = new NamedNodeTable<>("security-elytron-realm-table", realmTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> trustManagerTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata99)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-trust-manager-table", Ids.ADD_SUFFIX), "Elytron Trust Manager",
                metadata99Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Trust Manager", metadata99Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();
        trustManagerTable = new NamedNodeTable<>("security-elytron-trust-manager-table", trustManagerTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> trustStoreTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata100)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-trust-store-table", Ids.ADD_SUFFIX), "Elytron Trust Store",
                metadata100Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Trust Store", metadata100Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();
        trustStoreTable = new NamedNodeTable<>("security-elytron-trust-store-table", trustStoreTableOptions);

        navigation = new VerticalNavigation();
        Elements.Builder securityConfigurationItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>{{metadata95.getDescription().getDescription()}}</p>"))
                    .rememberAs("html270")
                .end()
                .add(configurationForm)
            .end();
        Element securityConfigurationItemElement = securityConfigurationItemBuilder.build();
        handlebarElements.put("html270", securityConfigurationItemBuilder.referenceFor("html270"));
        navigation.addPrimary("security-configuration-item", "Configuration", "pficon pficon-settings", securityConfigurationItemElement);
        Elements.Builder securityElytronKeyManagerItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Key Manager</h1><p>{{metadata96.getDescription().getDescription()}}</p>"))
                    .rememberAs("html272")
                .end()
                .add(keyManagerTable)
                .add(keyManagerForm)
            .end();
        Element securityElytronKeyManagerItemElement = securityElytronKeyManagerItemBuilder.build();
        handlebarElements.put("html272", securityElytronKeyManagerItemBuilder.referenceFor("html272"));
        navigation.addPrimary("security-elytron-key-manager-item", "Key Manager", "fa fa-key", securityElytronKeyManagerItemElement);
        Elements.Builder securityElytronKeyStoreItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Key Store</h1><p>{{metadata97.getDescription().getDescription()}}</p>"))
                    .rememberAs("html275")
                .end()
                .add(keyStoreTable)
                .add(keyStoreForm)
            .end();
        Element securityElytronKeyStoreItemElement = securityElytronKeyStoreItemBuilder.build();
        handlebarElements.put("html275", securityElytronKeyStoreItemBuilder.referenceFor("html275"));
        navigation.addPrimary("security-elytron-key-store-item", "Key Store", "fa fa-key", securityElytronKeyStoreItemElement);
        Elements.Builder securityElytronRealmItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Realm</h1><p>{{metadata98.getDescription().getDescription()}}</p>"))
                    .rememberAs("html278")
                .end()
                .add(realmTable)
                .add(realmForm)
            .end();
        Element securityElytronRealmItemElement = securityElytronRealmItemBuilder.build();
        handlebarElements.put("html278", securityElytronRealmItemBuilder.referenceFor("html278"));
        navigation.addPrimary("security-elytron-realm-item", "Realm", "fa fa-map", securityElytronRealmItemElement);
        Elements.Builder securityElytronTrustManagerItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Trust Manager</h1><p>{{metadata99.getDescription().getDescription()}}</p>"))
                    .rememberAs("html281")
                .end()
                .add(trustManagerTable)
                .add(trustManagerForm)
            .end();
        Element securityElytronTrustManagerItemElement = securityElytronTrustManagerItemBuilder.build();
        handlebarElements.put("html281", securityElytronTrustManagerItemBuilder.referenceFor("html281"));
        navigation.addPrimary("security-elytron-trust-manager-item", "Trust Manager", "fa fa-lock", securityElytronTrustManagerItemElement);
        Elements.Builder securityElytronTrustStoreItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Trust Store</h1><p>{{metadata100.getDescription().getDescription()}}</p>"))
                    .rememberAs("html284")
                .end()
                .add(trustStoreTable)
                .add(trustStoreForm)
            .end();
        Element securityElytronTrustStoreItemElement = securityElytronTrustStoreItemBuilder.build();
        handlebarElements.put("html284", securityElytronTrustStoreItemBuilder.referenceFor("html284"));
        navigation.addPrimary("security-elytron-trust-store-item", "Trust Store", "fa fa-lock", securityElytronTrustStoreItemElement);
        Elements.Builder securityVaultItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Vault</h1><p>{{metadata101.getDescription().getDescription()}}</p>"))
                    .rememberAs("html287")
                .end()
                .add(vaultForm)
            .end();
        Element securityVaultItemElement = securityVaultItemBuilder.build();
        handlebarElements.put("html287", securityVaultItemBuilder.referenceFor("html287"));
        navigation.addPrimary("security-vault-item", "Vault", "fa fa-shield", securityVaultItemElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(keyManagerTable);
        registerAttachable(keyManagerForm);
        registerAttachable(keyStoreTable);
        registerAttachable(keyStoreForm);
        registerAttachable(realmTable);
        registerAttachable(realmForm);
        registerAttachable(trustManagerTable);
        registerAttachable(trustManagerForm);
        registerAttachable(trustStoreTable);
        registerAttachable(trustStoreForm);
        registerAttachable(vaultForm);

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            keyManagerTable.bindForm(keyManagerForm);
            keyStoreTable.bindForm(keyStoreForm);
            realmTable.bindForm(realmForm);
            trustManagerTable.bindForm(trustManagerForm);
            trustStoreTable.bindForm(trustStoreForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html270"), "{{metadata95.getDescription().getDescription()}}", String.valueOf(metadata95.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html272"), "{{metadata96.getDescription().getDescription()}}", String.valueOf(metadata96.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html275"), "{{metadata97.getDescription().getDescription()}}", String.valueOf(metadata97.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html278"), "{{metadata98.getDescription().getDescription()}}", String.valueOf(metadata98.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html281"), "{{metadata99.getDescription().getDescription()}}", String.valueOf(metadata99.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html284"), "{{metadata100.getDescription().getDescription()}}", String.valueOf(metadata100.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html287"), "{{metadata101.getDescription().getDescription()}}", String.valueOf(metadata101.getDescription().getDescription()));
    }
}
