package org.jboss.hal.client.configuration.subsystem.remoting;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.table.NamedNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.model.Operation;
import org.jboss.hal.dmr.model.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_RemotingView extends RemotingView {

    private final Metadata metadata152;
    private final Metadata metadata150;
    private final Metadata metadata149;
    private final Metadata metadata148;
    private final Metadata metadata151;
    private final Metadata metadata153;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_RemotingView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata152Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/outbound-connection=*");
        this.metadata152 = mbuiContext.metadataRegistry().lookup(metadata152Template);
        AddressTemplate metadata150Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/http-connector=*");
        this.metadata150 = mbuiContext.metadataRegistry().lookup(metadata150Template);
        AddressTemplate metadata149Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/connector=*");
        this.metadata149 = mbuiContext.metadataRegistry().lookup(metadata149Template);
        AddressTemplate metadata148Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/configuration=endpoint");
        this.metadata148 = mbuiContext.metadataRegistry().lookup(metadata148Template);
        AddressTemplate metadata151Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/local-outbound-connection=*");
        this.metadata151 = mbuiContext.metadataRegistry().lookup(metadata151Template);
        AddressTemplate metadata153Template = AddressTemplate.of("/{selected.profile}/subsystem=remoting/remote-outbound-connection=*");
        this.metadata153 = mbuiContext.metadataRegistry().lookup(metadata153Template);
        this.handlebarElements = new HashMap<>();

        endpointConfigurationForm = new GroupedForm.Builder<org.jboss.hal.dmr.ModelNode>("remoting-endpoint-configuration", metadata148)
            .customGroup("remoting-endpoint-configuration-attributes", mbuiContext.resources().constants().attributes())
                .include("buffer-region-size", "heartbeat-interval", "receive-buffer-size", "receive-window-size", "send-buffer-size", "server-name", "transmit-window-size", "worker")
            .end()
            .customGroup("remoting-endpoint-configuration-security", mbuiContext.resources().constants().security())
                .include("auth-realm", "authentication-retries", "authorize-id", "sasl-protocol")
            .end()
            .customGroup("remoting-endpoint-configuration-channels", "Channels")
                .include("max-inbound-channels", "max-inbound-message-size", "max-inbound-messages", "max-outbound-channels", "max-outbound-message-size", "max-outbound-messages")
            .end()
            .onSave((form, changedValues) -> saveSingletonForm("Endpoint Configuration", metadata148Template.resolve(mbuiContext.statementContext()), changedValues, metadata148))
            .prepareReset(form -> resetSingletonForm("Endpoint Configuration", metadata148Template.resolve(mbuiContext.statementContext()), form, metadata148))
            .build();
        localOutboundForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("remoting-local-outbound-form", metadata151)
            .unboundFormItem(new org.jboss.hal.ballroom.form.PropertiesItem("property"), 0)
            .include("outbound-socket-binding-ref")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveLocalOutbound(form, changedValues))
            .prepareReset(form -> presenter.resetLocalOutbound(form))
            .build();
        localOutboundForm.getFormItem("outbound-socket-binding-ref").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/local-destination-outbound-socket-binding=*")));
        outboundForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("remoting-outbound-form", metadata152)
            .unboundFormItem(new org.jboss.hal.ballroom.form.PropertiesItem("property"), 0)
            .include("uri")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveOutbound(form, changedValues))
            .prepareReset(form -> presenter.resetOutbound(form))
            .build();
        remoteOutboundForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.model.NamedNode>("remoting-remote-outbound-form", metadata153)
            .include("outbound-socket-binding-ref")
            .unboundFormItem(new org.jboss.hal.ballroom.form.PropertiesItem("property"), 1)
            .include("protocol")
            .include("security-realm")
            .include("username")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveRemoteOutbound(form, changedValues))
            .prepareReset(form -> presenter.resetRemoteOutbound(form))
            .build();
        remoteOutboundForm.getFormItem("outbound-socket-binding-ref").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/remote-destination-outbound-socket-binding=*")));

        Options<org.jboss.hal.dmr.model.NamedNode> connectorTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata149)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("remoting-connector-table", Ids.ADD_SUFFIX), "Connector",
                metadata149Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Connector", metadata149Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        connectorTable = new NamedNodeTable<>("remoting-connector-table", metadata149, connectorTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> httpConnectorTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata150)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("remoting-http-connector-table", Ids.ADD_SUFFIX), "HTTP Connector",
                metadata150Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("HTTP Connector", metadata150Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        httpConnectorTable = new NamedNodeTable<>("remoting-http-connector-table", metadata150, httpConnectorTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> localOutboundTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata151)
            .button(mbuiContext.tableButtonFactory().add(metadata151Template, (event, api) -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("remoting-local-outbound-table", Ids.ADD_SUFFIX),
                    mbuiContext.resources().messages().addResourceTitle("Local Outbound"),
                    metadata151,
                    asList("outbound-socket-binding-ref"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata151Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("Local Outbound", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.getForm().getFormItem("outbound-socket-binding-ref").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/local-destination-outbound-socket-binding=*")));
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Local Outbound", metadata151Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        localOutboundTable = new NamedNodeTable<>("remoting-local-outbound-table", metadata151, localOutboundTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> outboundTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata152)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("remoting-outbound-table", Ids.ADD_SUFFIX), "Outbound",
                metadata152Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Outbound", metadata152Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        outboundTable = new NamedNodeTable<>("remoting-outbound-table", metadata152, outboundTableOptions);
        Options<org.jboss.hal.dmr.model.NamedNode> remoteOutboundTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.model.NamedNode>(metadata153)
            .button(mbuiContext.tableButtonFactory().add(metadata153Template, (event, api) -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("remoting-remote-outbound-table", Ids.ADD_SUFFIX),
                    mbuiContext.resources().messages().addResourceTitle("Remote Outbound"),
                    metadata153,
                    asList("outbound-socket-binding-ref"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata153Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("Remote Outbound", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.getForm().getFormItem("outbound-socket-binding-ref").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/remote-destination-outbound-socket-binding=*")));
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Remote Outbound", metadata153Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        remoteOutboundTable = new NamedNodeTable<>("remoting-remote-outbound-table", metadata153, remoteOutboundTableOptions);

        navigation = new VerticalNavigation();
        Elements.Builder remotingEndpointConfigurationItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Endpoint Configuration</h1><p>{{metadata148.getDescription().getDescription()}}</p>"))
                    .rememberAs("html435")
                .end()
                .add(endpointConfigurationForm)
            .end();
        Element remotingEndpointConfigurationItemElement = remotingEndpointConfigurationItemBuilder.build();
        handlebarElements.put("html435", remotingEndpointConfigurationItemBuilder.referenceFor("html435"));
        navigation.addPrimary("remoting-endpoint-configuration-item", "Endpoint Configuration", "pficon pficon-settings", remotingEndpointConfigurationItemElement);
        navigation.addPrimary("remoting-remote-connector-item", "Remote Connector", "pficon pficon-network");
        Elements.Builder remotingConnectorSubItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Connector</h1><p>{{metadata149.getDescription().getDescription()}}</p>"))
                    .rememberAs("html437")
                .end()
                .add(connectorTable)
            .end();
        Element remotingConnectorSubItemElement = remotingConnectorSubItemBuilder.build();
        handlebarElements.put("html437", remotingConnectorSubItemBuilder.referenceFor("html437"));
        navigation.addSecondary("remoting-remote-connector-item", "remoting-connector-sub-item", "Connector", remotingConnectorSubItemElement);
        Elements.Builder remotingHttpConnectorSubItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>HTTP Connector</h1><p>{{metadata150.getDescription().getDescription()}}</p>"))
                    .rememberAs("html439")
                .end()
                .add(httpConnectorTable)
            .end();
        Element remotingHttpConnectorSubItemElement = remotingHttpConnectorSubItemBuilder.build();
        handlebarElements.put("html439", remotingHttpConnectorSubItemBuilder.referenceFor("html439"));
        navigation.addSecondary("remoting-remote-connector-item", "remoting-http-connector-sub-item", "HTTP Connector", remotingHttpConnectorSubItemElement);
        navigation.addPrimary("remoting-outbound-connection-item", "Outbound Connection", "pficon pficon-service");
        Elements.Builder remotingLocalOutboundSubItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Local Outbound</h1><p>{{metadata151.getDescription().getDescription()}}</p>"))
                    .rememberAs("html441")
                .end()
                .add(localOutboundTable)
                .add(localOutboundForm)
            .end();
        Element remotingLocalOutboundSubItemElement = remotingLocalOutboundSubItemBuilder.build();
        handlebarElements.put("html441", remotingLocalOutboundSubItemBuilder.referenceFor("html441"));
        navigation.addSecondary("remoting-outbound-connection-item", "remoting-local-outbound-sub-item", "Local Outbound", remotingLocalOutboundSubItemElement);
        Elements.Builder remotingOutboundSubItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Outbound</h1><p>{{metadata152.getDescription().getDescription()}}</p>"))
                    .rememberAs("html444")
                .end()
                .add(outboundTable)
                .add(outboundForm)
            .end();
        Element remotingOutboundSubItemElement = remotingOutboundSubItemBuilder.build();
        handlebarElements.put("html444", remotingOutboundSubItemBuilder.referenceFor("html444"));
        navigation.addSecondary("remoting-outbound-connection-item", "remoting-outbound-sub-item", "Outbound", remotingOutboundSubItemElement);
        Elements.Builder remotingRemoteOutboundSubItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remote Outbound</h1><p>{{metadata153.getDescription().getDescription()}}</p>"))
                    .rememberAs("html447")
                .end()
                .add(remoteOutboundTable)
                .add(remoteOutboundForm)
            .end();
        Element remotingRemoteOutboundSubItemElement = remotingRemoteOutboundSubItemBuilder.build();
        handlebarElements.put("html447", remotingRemoteOutboundSubItemBuilder.referenceFor("html447"));
        navigation.addSecondary("remoting-outbound-connection-item", "remoting-remote-outbound-sub-item", "Remote Outbound", remotingRemoteOutboundSubItemElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        registerAttachable(navigation);
        registerAttachable(endpointConfigurationForm);
        registerAttachable(connectorTable);
        registerAttachable(httpConnectorTable);
        registerAttachable(localOutboundTable);
        registerAttachable(localOutboundForm);
        registerAttachable(outboundTable);
        registerAttachable(outboundForm);
        registerAttachable(remoteOutboundTable);
        registerAttachable(remoteOutboundForm);

        Element root = layoutBuilder.build();
        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            localOutboundTable.bindForm(localOutboundForm);
            outboundTable.bindForm(outboundForm);
            remoteOutboundTable.bindForm(remoteOutboundForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html435"), "{{metadata148.getDescription().getDescription()}}", String.valueOf(metadata148.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html437"), "{{metadata149.getDescription().getDescription()}}", String.valueOf(metadata149.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html439"), "{{metadata150.getDescription().getDescription()}}", String.valueOf(metadata150.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html441"), "{{metadata151.getDescription().getDescription()}}", String.valueOf(metadata151.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html444"), "{{metadata152.getDescription().getDescription()}}", String.valueOf(metadata152.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html447"), "{{metadata153.getDescription().getDescription()}}", String.valueOf(metadata153.getDescription().getDescription()));
    }
}
