package org.jboss.hal.client.configuration.subsystem.messaging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.table.NamedNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_ConnectionView extends ConnectionView {

    private final Metadata metadata132;
    private final Metadata metadata131;
    private final Metadata metadata133;
    private final Metadata metadata129;
    private final Metadata metadata127;
    private final Metadata metadata124;
    private final Metadata metadata130;
    private final Metadata metadata128;
    private final Metadata metadata125;
    private final Metadata metadata126;
    private final Metadata metadata123;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_ConnectionView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata132Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/connection-factory=*");
        this.metadata132 = mbuiContext.metadataRegistry().lookup(metadata132Template);
        AddressTemplate metadata131Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/connector-service=*");
        this.metadata131 = mbuiContext.metadataRegistry().lookup(metadata131Template);
        AddressTemplate metadata133Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/pooled-connection-factory=*");
        this.metadata133 = mbuiContext.metadataRegistry().lookup(metadata133Template);
        AddressTemplate metadata129Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/http-connector=*");
        this.metadata129 = mbuiContext.metadataRegistry().lookup(metadata129Template);
        AddressTemplate metadata127Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/connector=*");
        this.metadata127 = mbuiContext.metadataRegistry().lookup(metadata127Template);
        AddressTemplate metadata124Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/in-vm-acceptor=*");
        this.metadata124 = mbuiContext.metadataRegistry().lookup(metadata124Template);
        AddressTemplate metadata130Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/remote-connector=*");
        this.metadata130 = mbuiContext.metadataRegistry().lookup(metadata130Template);
        AddressTemplate metadata128Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/in-vm-connector=*");
        this.metadata128 = mbuiContext.metadataRegistry().lookup(metadata128Template);
        AddressTemplate metadata125Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/http-acceptor=*");
        this.metadata125 = mbuiContext.metadataRegistry().lookup(metadata125Template);
        AddressTemplate metadata126Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/remote-acceptor=*");
        this.metadata126 = mbuiContext.metadataRegistry().lookup(metadata126Template);
        AddressTemplate metadata123Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/acceptor=*");
        this.metadata123 = mbuiContext.metadataRegistry().lookup(metadata123Template);
        this.handlebarElements = new HashMap<>();

        acceptorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-acceptor-form", metadata123)
            .include("factory-class", "socket-binding", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.ACCEPTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.ACCEPTOR, form))
            .build();
        acceptorForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        inVmAcceptorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-in-vm-acceptor-form", metadata124)
            .include("server-id", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.IN_VM_ACCEPTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.IN_VM_ACCEPTOR, form))
            .build();
        httpAcceptorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-http-acceptor-form", metadata125)
            .include("http-listener", "upgrade-legacy", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.HTTP_ACCEPTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.HTTP_ACCEPTOR, form))
            .build();
        httpAcceptorForm.getFormItem("http-listener").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=undertow/server=*/http-listener=*")));
        remoteAcceptorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-remote-acceptor-form", metadata126)
            .include("socket-binding", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.REMOTE_ACCEPTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.REMOTE_ACCEPTOR, form))
            .build();
        remoteAcceptorForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        connectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-connector-form", metadata127)
            .include("factory-class", "socket-binding", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.CONNECTOR, form))
            .build();
        connectorForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        inVmConnectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-in-vm-connector-form", metadata128)
            .include("server-id", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.IN_VM_CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.IN_VM_CONNECTOR, form))
            .build();
        httpConnectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-http-connector-form", metadata129)
            .include("endpoint", "socket-binding", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.HTTP_CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.HTTP_CONNECTOR, form))
            .build();
        httpConnectorForm.getFormItem("endpoint").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/http-acceptor=*")));
        httpConnectorForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        remoteConnectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-remote-connector-form", metadata130)
            .include("socket-binding", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.REMOTE_CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.REMOTE_CONNECTOR, form))
            .build();
        remoteConnectorForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        connectorServiceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-connector-service-form", metadata131)
            .include("factory-class", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.CONNECTOR_SERVICE, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.CONNECTOR_SERVICE, form))
            .build();
        connectionFactoryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-connection-factory-form", metadata132)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.CONNECTION_FACTORY, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.CONNECTION_FACTORY, form))
            .build();
        pooledConnectionFactoryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-pooled-connection-factory-form", metadata133)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.POOLED_CONNECTION_FACTORY, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.POOLED_CONNECTION_FACTORY, form))
            .build();

        Options<org.jboss.hal.dmr.NamedNode> acceptorTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.NamedNode>(metadata123)
            .button(mbuiContext.resources().constants().add(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/acceptor=*:add)"), (event, api) -> presenter.add(ServerSubResource.ACCEPTOR))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/acceptor=*:remove)"), (event, api) -> presenter.remove(ServerSubResource.ACCEPTOR, api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        acceptorTable = new NamedNodeTable<>("messaging-acceptor-table", metadata123, acceptorTableOptions);
        Options<org.jboss.hal.dmr.NamedNode> inVmAcceptorTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.NamedNode>(metadata124)
            .button(mbuiContext.resources().constants().add(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/in-vm-acceptor=*:add)"), (event, api) -> presenter.add(ServerSubResource.IN_VM_ACCEPTOR))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/in-vm-acceptor=*:remove)"), (event, api) -> presenter.remove(ServerSubResource.IN_VM_ACCEPTOR, api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("server-id")
            .build();
        inVmAcceptorTable = new NamedNodeTable<>("messaging-in-vm-acceptor-table", metadata124, inVmAcceptorTableOptions);
        Options<org.jboss.hal.dmr.NamedNode> httpAcceptorTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.NamedNode>(metadata125)
            .button(mbuiContext.resources().constants().add(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/http-acceptor=*:add)"), (event, api) -> presenter.addHttp(ServerSubResource.HTTP_ACCEPTOR))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/http-acceptor=*:remove)"), (event, api) -> presenter.remove(ServerSubResource.HTTP_ACCEPTOR, api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        httpAcceptorTable = new NamedNodeTable<>("messaging-http-acceptor-table", metadata125, httpAcceptorTableOptions);
        Options<org.jboss.hal.dmr.NamedNode> remoteAcceptorTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.NamedNode>(metadata126)
            .button(mbuiContext.resources().constants().add(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/remote-acceptor=*:add)"), (event, api) -> presenter.addRemote(ServerSubResource.REMOTE_ACCEPTOR))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/remote-acceptor=*:remove)"), (event, api) -> presenter.remove(ServerSubResource.REMOTE_ACCEPTOR, api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        remoteAcceptorTable = new NamedNodeTable<>("messaging-remote-acceptor-table", metadata126, remoteAcceptorTableOptions);
        Options<org.jboss.hal.dmr.NamedNode> connectorTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.NamedNode>(metadata127)
            .button(mbuiContext.resources().constants().add(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/connector=*:add)"), (event, api) -> presenter.add(ServerSubResource.CONNECTOR))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/connector=*:remove)"), (event, api) -> presenter.remove(ServerSubResource.CONNECTOR, api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        connectorTable = new NamedNodeTable<>("messaging-connector-table", metadata127, connectorTableOptions);
        Options<org.jboss.hal.dmr.NamedNode> inVmConnectorTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.NamedNode>(metadata128)
            .button(mbuiContext.resources().constants().add(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/in-vm-connector=*:add)"), (event, api) -> presenter.add(ServerSubResource.IN_VM_CONNECTOR))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/in-vm-connector=*:remove)"), (event, api) -> presenter.remove(ServerSubResource.IN_VM_CONNECTOR, api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("server-id")
            .build();
        inVmConnectorTable = new NamedNodeTable<>("messaging-in-vm-connector-table", metadata128, inVmConnectorTableOptions);
        Options<org.jboss.hal.dmr.NamedNode> httpConnectorTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.NamedNode>(metadata129)
            .button(mbuiContext.resources().constants().add(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/http-connector=*:add)"), (event, api) -> presenter.addHttp(ServerSubResource.HTTP_CONNECTOR))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/http-connector=*:remove)"), (event, api) -> presenter.remove(ServerSubResource.HTTP_CONNECTOR, api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        httpConnectorTable = new NamedNodeTable<>("messaging-http-connector-table", metadata129, httpConnectorTableOptions);
        Options<org.jboss.hal.dmr.NamedNode> remoteConnectorTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.NamedNode>(metadata130)
            .button(mbuiContext.resources().constants().add(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/remote-connector=*:add)"), (event, api) -> presenter.addRemote(ServerSubResource.REMOTE_CONNECTOR))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/remote-connector=*:remove)"), (event, api) -> presenter.remove(ServerSubResource.REMOTE_CONNECTOR, api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        remoteConnectorTable = new NamedNodeTable<>("messaging-remote-connector-table", metadata130, remoteConnectorTableOptions);
        Options<org.jboss.hal.dmr.NamedNode> connectorServiceTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.NamedNode>(metadata131)
            .button(mbuiContext.resources().constants().add(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/connector-service=*:add)"), (event, api) -> presenter.add(ServerSubResource.CONNECTOR_SERVICE))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/connector-service=*:remove)"), (event, api) -> presenter.remove(ServerSubResource.CONNECTOR_SERVICE, api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        connectorServiceTable = new NamedNodeTable<>("messaging-connector-service-table", metadata131, connectorServiceTableOptions);
        Options<org.jboss.hal.dmr.NamedNode> connectionFactoryTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.NamedNode>(metadata132)
            .button(mbuiContext.resources().constants().add(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/connection-factory=*:add)"), (event, api) -> presenter.add(ServerSubResource.CONNECTION_FACTORY))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/connection-factory=*:remove)"), (event, api) -> presenter.remove(ServerSubResource.CONNECTION_FACTORY, api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        connectionFactoryTable = new NamedNodeTable<>("messaging-connection-factory-table", metadata132, connectionFactoryTableOptions);
        Options<org.jboss.hal.dmr.NamedNode> pooledConnectionFactoryTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.NamedNode>(metadata133)
            .button(mbuiContext.resources().constants().add(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/pooled-connection-factory=*:add)"), (event, api) -> presenter.add(ServerSubResource.POOLED_CONNECTION_FACTORY))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/pooled-connection-factory=*:remove)"), (event, api) -> presenter.remove(ServerSubResource.POOLED_CONNECTION_FACTORY, api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        pooledConnectionFactoryTable = new NamedNodeTable<>("messaging-pooled-connection-factory-table", metadata133, pooledConnectionFactoryTableOptions);

        navigation = new VerticalNavigation();
        navigation.addPrimary("messaging-acceptor-group-entry", "Acceptor", "fa fa-sign-in");
        Elements.Builder messagingAcceptorEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Generic Acceptor</h1><p>{{metadata123.getDescription().getDescription()}}</p>"))
                    .rememberAs("html365")
                .end()
                .add(acceptorTable)
                .add(acceptorForm)
            .end();
        Element messagingAcceptorEntryElement = messagingAcceptorEntryBuilder.build();
        handlebarElements.put("html365", messagingAcceptorEntryBuilder.referenceFor("html365"));
        navigation.addSecondary("messaging-acceptor-group-entry", "messaging-acceptor-entry", "Generic", messagingAcceptorEntryElement);
        Elements.Builder messagingInVmAcceptorEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>In VM Acceptor</h1><p>{{metadata124.getDescription().getDescription()}}</p>"))
                    .rememberAs("html368")
                .end()
                .add(inVmAcceptorTable)
                .add(inVmAcceptorForm)
            .end();
        Element messagingInVmAcceptorEntryElement = messagingInVmAcceptorEntryBuilder.build();
        handlebarElements.put("html368", messagingInVmAcceptorEntryBuilder.referenceFor("html368"));
        navigation.addSecondary("messaging-acceptor-group-entry", "messaging-in-vm-acceptor-entry", "In VM", messagingInVmAcceptorEntryElement);
        Elements.Builder messagingHttpAcceptorEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>HTTP Acceptor</h1><p>{{metadata125.getDescription().getDescription()}}</p>"))
                    .rememberAs("html371")
                .end()
                .add(httpAcceptorTable)
                .add(httpAcceptorForm)
            .end();
        Element messagingHttpAcceptorEntryElement = messagingHttpAcceptorEntryBuilder.build();
        handlebarElements.put("html371", messagingHttpAcceptorEntryBuilder.referenceFor("html371"));
        navigation.addSecondary("messaging-acceptor-group-entry", "messaging-http-acceptor-entry", "HTTP", messagingHttpAcceptorEntryElement);
        Elements.Builder messagingRemoteAcceptorEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remote Acceptor</h1><p>{{metadata126.getDescription().getDescription()}}</p>"))
                    .rememberAs("html374")
                .end()
                .add(remoteAcceptorTable)
                .add(remoteAcceptorForm)
            .end();
        Element messagingRemoteAcceptorEntryElement = messagingRemoteAcceptorEntryBuilder.build();
        handlebarElements.put("html374", messagingRemoteAcceptorEntryBuilder.referenceFor("html374"));
        navigation.addSecondary("messaging-acceptor-group-entry", "messaging-remote-acceptor-entry", "Remote", messagingRemoteAcceptorEntryElement);
        navigation.addPrimary("messaging-connector-group-entry", "Connector", "fa fa-link");
        Elements.Builder messagingConnectorEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Generic Connector</h1><p>{{metadata127.getDescription().getDescription()}}</p>"))
                    .rememberAs("html377")
                .end()
                .add(connectorTable)
                .add(connectorForm)
            .end();
        Element messagingConnectorEntryElement = messagingConnectorEntryBuilder.build();
        handlebarElements.put("html377", messagingConnectorEntryBuilder.referenceFor("html377"));
        navigation.addSecondary("messaging-connector-group-entry", "messaging-connector-entry", "Generic", messagingConnectorEntryElement);
        Elements.Builder messagingInVmConnectorEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>In VM Connector</h1><p>{{metadata128.getDescription().getDescription()}}</p>"))
                    .rememberAs("html380")
                .end()
                .add(inVmConnectorTable)
                .add(inVmConnectorForm)
            .end();
        Element messagingInVmConnectorEntryElement = messagingInVmConnectorEntryBuilder.build();
        handlebarElements.put("html380", messagingInVmConnectorEntryBuilder.referenceFor("html380"));
        navigation.addSecondary("messaging-connector-group-entry", "messaging-in-vm-connector-entry", "In VM", messagingInVmConnectorEntryElement);
        Elements.Builder messagingHttpConnectorEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>HTTP Connector</h1><p>{{metadata129.getDescription().getDescription()}}</p>"))
                    .rememberAs("html383")
                .end()
                .add(httpConnectorTable)
                .add(httpConnectorForm)
            .end();
        Element messagingHttpConnectorEntryElement = messagingHttpConnectorEntryBuilder.build();
        handlebarElements.put("html383", messagingHttpConnectorEntryBuilder.referenceFor("html383"));
        navigation.addSecondary("messaging-connector-group-entry", "messaging-http-connector-entry", "HTTP", messagingHttpConnectorEntryElement);
        Elements.Builder messagingRemoteConnectorEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remote Connector</h1><p>{{metadata130.getDescription().getDescription()}}</p>"))
                    .rememberAs("html386")
                .end()
                .add(remoteConnectorTable)
                .add(remoteConnectorForm)
            .end();
        Element messagingRemoteConnectorEntryElement = messagingRemoteConnectorEntryBuilder.build();
        handlebarElements.put("html386", messagingRemoteConnectorEntryBuilder.referenceFor("html386"));
        navigation.addSecondary("messaging-connector-group-entry", "messaging-remote-connector-entry", "Remote", messagingRemoteConnectorEntryElement);
        Elements.Builder messagingConnectorServiceEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Connector Service</h1><p>{{metadata131.getDescription().getDescription()}}</p>"))
                    .rememberAs("html389")
                .end()
                .add(connectorServiceTable)
                .add(connectorServiceForm)
            .end();
        Element messagingConnectorServiceEntryElement = messagingConnectorServiceEntryBuilder.build();
        handlebarElements.put("html389", messagingConnectorServiceEntryBuilder.referenceFor("html389"));
        navigation.addPrimary("messaging-connector-service-entry", "Connector Service", "pficon pficon-service", messagingConnectorServiceEntryElement);
        Elements.Builder messagingConnectionFactoryEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Connection Factory</h1><p>{{metadata132.getDescription().getDescription()}}</p>"))
                    .rememberAs("html392")
                .end()
                .add(connectionFactoryTable)
                .add(connectionFactoryForm)
            .end();
        Element messagingConnectionFactoryEntryElement = messagingConnectionFactoryEntryBuilder.build();
        handlebarElements.put("html392", messagingConnectionFactoryEntryBuilder.referenceFor("html392"));
        navigation.addPrimary("messaging-connection-factory-entry", "Connection Factory", "fa fa-cubes", messagingConnectionFactoryEntryElement);
        Elements.Builder messagingPooledConnectionFactoryEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Pooled Connection Factory</h1><p>{{metadata133.getDescription().getDescription()}}</p>"))
                    .rememberAs("html395")
                .end()
                .add(pooledConnectionFactoryTable)
                .add(pooledConnectionFactoryForm)
            .end();
        Element messagingPooledConnectionFactoryEntryElement = messagingPooledConnectionFactoryEntryBuilder.build();
        handlebarElements.put("html395", messagingPooledConnectionFactoryEntryBuilder.referenceFor("html395"));
        navigation.addPrimary("messaging-pooled-connection-factory-entry", "Pooled Connection Factory", "pficon pficon-replicator", messagingPooledConnectionFactoryEntryElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        registerAttachable(navigation);
        registerAttachable(acceptorTable);
        registerAttachable(acceptorForm);
        registerAttachable(inVmAcceptorTable);
        registerAttachable(inVmAcceptorForm);
        registerAttachable(httpAcceptorTable);
        registerAttachable(httpAcceptorForm);
        registerAttachable(remoteAcceptorTable);
        registerAttachable(remoteAcceptorForm);
        registerAttachable(connectorTable);
        registerAttachable(connectorForm);
        registerAttachable(inVmConnectorTable);
        registerAttachable(inVmConnectorForm);
        registerAttachable(httpConnectorTable);
        registerAttachable(httpConnectorForm);
        registerAttachable(remoteConnectorTable);
        registerAttachable(remoteConnectorForm);
        registerAttachable(connectorServiceTable);
        registerAttachable(connectorServiceForm);
        registerAttachable(connectionFactoryTable);
        registerAttachable(connectionFactoryForm);
        registerAttachable(pooledConnectionFactoryTable);
        registerAttachable(pooledConnectionFactoryForm);

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            acceptorTable.bindForm(acceptorForm);
            inVmAcceptorTable.bindForm(inVmAcceptorForm);
            httpAcceptorTable.bindForm(httpAcceptorForm);
            remoteAcceptorTable.bindForm(remoteAcceptorForm);
            connectorTable.bindForm(connectorForm);
            inVmConnectorTable.bindForm(inVmConnectorForm);
            httpConnectorTable.bindForm(httpConnectorForm);
            remoteConnectorTable.bindForm(remoteConnectorForm);
            connectorServiceTable.bindForm(connectorServiceForm);
            connectionFactoryTable.bindForm(connectionFactoryForm);
            pooledConnectionFactoryTable.bindForm(pooledConnectionFactoryForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html365"), "{{metadata123.getDescription().getDescription()}}", String.valueOf(metadata123.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html368"), "{{metadata124.getDescription().getDescription()}}", String.valueOf(metadata124.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html371"), "{{metadata125.getDescription().getDescription()}}", String.valueOf(metadata125.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html374"), "{{metadata126.getDescription().getDescription()}}", String.valueOf(metadata126.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html377"), "{{metadata127.getDescription().getDescription()}}", String.valueOf(metadata127.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html380"), "{{metadata128.getDescription().getDescription()}}", String.valueOf(metadata128.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html383"), "{{metadata129.getDescription().getDescription()}}", String.valueOf(metadata129.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html386"), "{{metadata130.getDescription().getDescription()}}", String.valueOf(metadata130.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html389"), "{{metadata131.getDescription().getDescription()}}", String.valueOf(metadata131.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html392"), "{{metadata132.getDescription().getDescription()}}", String.valueOf(metadata132.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html395"), "{{metadata133.getDescription().getDescription()}}", String.valueOf(metadata133.getDescription().getDescription()));
    }
}
