package org.jboss.hal.client.configuration.subsystem.messaging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.table.NamedNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_DestinationView extends DestinationView {

    private final Metadata metadata136;
    private final Metadata metadata135;
    private final Metadata metadata134;
    private final Metadata metadata137;
    private final Metadata metadata138;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_DestinationView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata136Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/jms-topic=*");
        this.metadata136 = mbuiContext.metadataRegistry().lookup(metadata136Template);
        AddressTemplate metadata135Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/jms-queue=*");
        this.metadata135 = mbuiContext.metadataRegistry().lookup(metadata135Template);
        AddressTemplate metadata134Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/queue=*");
        this.metadata134 = mbuiContext.metadataRegistry().lookup(metadata134Template);
        AddressTemplate metadata137Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/address-setting=*");
        this.metadata137 = mbuiContext.metadataRegistry().lookup(metadata137Template);
        AddressTemplate metadata138Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/divert=*");
        this.metadata138 = mbuiContext.metadataRegistry().lookup(metadata138Template);
        this.handlebarElements = new HashMap<>();

        coreQueueForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-core-queue-form", metadata134)
            .include("queue-address", "filter", "durable")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.CORE_QUEUE, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.CORE_QUEUE, form))
            .build();
        jmsQueueForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-jms-queue-form", metadata135)
            .include("selector", "entries", "durable")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.JMS_QUEUE, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.JMS_QUEUE, form))
            .build();
        jmsTopicForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-jms-topic-form", metadata136)
            .include("entries")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.JMS_TOPIC, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.JMS_TOPIC, form))
            .build();
        addressSettingForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-address-setting-form", metadata137)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.ADDRESS_SETTING, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.ADDRESS_SETTING, form))
            .build();
        divertForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-divert-form", metadata138)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.DIVERT, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.DIVERT, form))
            .build();

        Options<org.jboss.hal.dmr.NamedNode> coreQueueTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.NamedNode>(metadata134)
            .button(mbuiContext.resources().constants().add(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/queue=*:add)"), (event, api) -> presenter.add(ServerSubResource.CORE_QUEUE))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/queue=*:remove)"), (event, api) -> presenter.remove(ServerSubResource.CORE_QUEUE, api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("queue-address")
            .build();
        coreQueueTable = new NamedNodeTable<>("messaging-core-queue-table", metadata134, coreQueueTableOptions);
        Options<org.jboss.hal.dmr.NamedNode> jmsQueueTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.NamedNode>(metadata135)
            .button(mbuiContext.resources().constants().add(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/jms-queue=*:add)"), (event, api) -> presenter.add(ServerSubResource.JMS_QUEUE))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/jms-queue=*:remove)"), (event, api) -> presenter.remove(ServerSubResource.JMS_QUEUE, api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("selector")
            .build();
        jmsQueueTable = new NamedNodeTable<>("messaging-jms-queue-table", metadata135, jmsQueueTableOptions);
        Options<org.jboss.hal.dmr.NamedNode> jmsTopicTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.NamedNode>(metadata136)
            .button(mbuiContext.resources().constants().add(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/jms-topic=*:add)"), (event, api) -> presenter.add(ServerSubResource.JMS_TOPIC))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/jms-topic=*:remove)"), (event, api) -> presenter.remove(ServerSubResource.JMS_TOPIC, api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        jmsTopicTable = new NamedNodeTable<>("messaging-jms-topic-table", metadata136, jmsTopicTableOptions);
        Options<org.jboss.hal.dmr.NamedNode> addressSettingTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.NamedNode>(metadata137)
            .button(mbuiContext.resources().constants().add(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/address-setting=*:add)"), (event, api) -> presenter.add(ServerSubResource.ADDRESS_SETTING))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/address-setting=*:remove)"), (event, api) -> presenter.remove(ServerSubResource.ADDRESS_SETTING, api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        addressSettingTable = new NamedNodeTable<>("messaging-address-setting-table", metadata137, addressSettingTableOptions);
        Options<org.jboss.hal.dmr.NamedNode> divertTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.NamedNode>(metadata138)
            .button(mbuiContext.resources().constants().add(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/divert=*:add)"), (event, api) -> presenter.add(ServerSubResource.DIVERT))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/divert=*:remove)"), (event, api) -> presenter.remove(ServerSubResource.DIVERT, api.selectedRow()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        divertTable = new NamedNodeTable<>("messaging-divert-table", metadata138, divertTableOptions);

        navigation = new VerticalNavigation();
        Elements.Builder messagingCoreQueueEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Core Queue</h1><p>{{metadata134.getDescription().getDescription()}}</p>"))
                    .rememberAs("html399")
                .end()
                .add(coreQueueTable)
                .add(coreQueueForm)
            .end();
        Element messagingCoreQueueEntryElement = messagingCoreQueueEntryBuilder.build();
        handlebarElements.put("html399", messagingCoreQueueEntryBuilder.referenceFor("html399"));
        navigation.addPrimary("messaging-core-queue-entry", "Core Queue", "fa fa-cog", messagingCoreQueueEntryElement);
        Elements.Builder messagingJmsQueueEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JMS Queue</h1><p>{{metadata135.getDescription().getDescription()}}</p>"))
                    .rememberAs("html402")
                .end()
                .add(jmsQueueTable)
                .add(jmsQueueForm)
            .end();
        Element messagingJmsQueueEntryElement = messagingJmsQueueEntryBuilder.build();
        handlebarElements.put("html402", messagingJmsQueueEntryBuilder.referenceFor("html402"));
        navigation.addPrimary("messaging-jms-queue-entry", "JMS Queue", "fa fa-long-arrow-right", messagingJmsQueueEntryElement);
        Elements.Builder messagingJmsTopicEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JMS Topic</h1><p>{{metadata136.getDescription().getDescription()}}</p>"))
                    .rememberAs("html405")
                .end()
                .add(jmsTopicTable)
                .add(jmsTopicForm)
            .end();
        Element messagingJmsTopicEntryElement = messagingJmsTopicEntryBuilder.build();
        handlebarElements.put("html405", messagingJmsTopicEntryBuilder.referenceFor("html405"));
        navigation.addPrimary("messaging-jms-topic-entry", "JMS Topic", "fa fa-arrows", messagingJmsTopicEntryElement);
        Elements.Builder messagingAddressSettingEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Address Setting</h1><p>{{metadata137.getDescription().getDescription()}}</p>"))
                    .rememberAs("html408")
                .end()
                .add(addressSettingTable)
                .add(addressSettingForm)
            .end();
        Element messagingAddressSettingEntryElement = messagingAddressSettingEntryBuilder.build();
        handlebarElements.put("html408", messagingAddressSettingEntryBuilder.referenceFor("html408"));
        navigation.addPrimary("messaging-address-setting-entry", "Address Setting", "fa fa-address-card-o", messagingAddressSettingEntryElement);
        Elements.Builder messagingDivertEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Divert</h1><p>{{metadata138.getDescription().getDescription()}}</p>"))
                    .rememberAs("html411")
                .end()
                .add(divertTable)
                .add(divertForm)
            .end();
        Element messagingDivertEntryElement = messagingDivertEntryBuilder.build();
        handlebarElements.put("html411", messagingDivertEntryBuilder.referenceFor("html411"));
        navigation.addPrimary("messaging-divert-entry", "Divert", "fa fa-exchange", messagingDivertEntryElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        registerAttachable(navigation);
        registerAttachable(coreQueueTable);
        registerAttachable(coreQueueForm);
        registerAttachable(jmsQueueTable);
        registerAttachable(jmsQueueForm);
        registerAttachable(jmsTopicTable);
        registerAttachable(jmsTopicForm);
        registerAttachable(addressSettingTable);
        registerAttachable(addressSettingForm);
        registerAttachable(divertTable);
        registerAttachable(divertForm);

        Element root = layoutBuilder.build();
        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            coreQueueTable.bindForm(coreQueueForm);
            jmsQueueTable.bindForm(jmsQueueForm);
            jmsTopicTable.bindForm(jmsTopicForm);
            addressSettingTable.bindForm(addressSettingForm);
            divertTable.bindForm(divertForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html399"), "{{metadata134.getDescription().getDescription()}}", String.valueOf(metadata134.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html402"), "{{metadata135.getDescription().getDescription()}}", String.valueOf(metadata135.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html405"), "{{metadata136.getDescription().getDescription()}}", String.valueOf(metadata136.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html408"), "{{metadata137.getDescription().getDescription()}}", String.valueOf(metadata137.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html411"), "{{metadata138.getDescription().getDescription()}}", String.valueOf(metadata138.getDescription().getDescription()));
    }
}
