package org.jboss.hal.client.configuration.subsystem.security;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.table.NamedNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_SecurityDomainView extends SecurityDomainView {

    private final Metadata metadata164;
    private final Metadata metadata159;
    private final Metadata metadata160;
    private final Metadata metadata163;
    private final Metadata metadata161;
    private final Metadata metadata162;
    private final Metadata metadata158;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_SecurityDomainView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata164Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/identity-trust=classic/trust-module=*");
        this.metadata164 = mbuiContext.metadataRegistry().lookup(metadata164Template);
        AddressTemplate metadata159Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/authentication=classic/login-module=*");
        this.metadata159 = mbuiContext.metadataRegistry().lookup(metadata159Template);
        AddressTemplate metadata160Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/authorization=classic/policy-module=*");
        this.metadata160 = mbuiContext.metadataRegistry().lookup(metadata160Template);
        AddressTemplate metadata163Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/mapping=classic/mapping-module=*");
        this.metadata163 = mbuiContext.metadataRegistry().lookup(metadata163Template);
        AddressTemplate metadata161Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/audit=classic/provider-module=*");
        this.metadata161 = mbuiContext.metadataRegistry().lookup(metadata161Template);
        AddressTemplate metadata162Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/acl=classic/acl-module=*");
        this.metadata162 = mbuiContext.metadataRegistry().lookup(metadata162Template);
        AddressTemplate metadata158Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*");
        this.metadata158 = mbuiContext.metadataRegistry().lookup(metadata158Template);
        this.handlebarElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("security-domain-configuration-form", metadata158)
            .onSave((form, changedValues) -> presenter.saveSecurityDomain(changedValues))
            .prepareReset(form -> presenter.resetSecurityDomain(form))
            .build();
        authenticationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-authentication-form", metadata159)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.AUTHENTICATION))
            .prepareReset(form -> presenter.resetModule(form, Module.AUTHENTICATION))
            .build();
        authorizationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-authorization-form", metadata160)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.AUTHORIZATION))
            .prepareReset(form -> presenter.resetModule(form, Module.AUTHORIZATION))
            .build();
        auditForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-audit-form", metadata161)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.AUDIT))
            .prepareReset(form -> presenter.resetModule(form, Module.AUDIT))
            .build();
        aclForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-acl-form", metadata162)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.ACL))
            .prepareReset(form -> presenter.resetModule(form, Module.ACL))
            .build();
        trustForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-trust-form", metadata164)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.TRUST))
            .prepareReset(form -> presenter.resetModule(form, Module.TRUST))
            .build();
        mappingForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-mapping-form", metadata163)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.MAPPING))
            .prepareReset(form -> presenter.resetModule(form, Module.MAPPING))
            .build();

        Options<org.jboss.hal.dmr.NamedNode> authenticationTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.NamedNode>(metadata159)
            .button(mbuiContext.resources().constants().add(), Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/authentication=classic/login-module=*:add)"), (event, api) -> presenter.addClassicAuthenticationModule())
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/authentication=classic/login-module=*:remove)"), (event, api) -> presenter.removeModule(api, Module.AUTHENTICATION))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        authenticationTable = new NamedNodeTable<>("security-domain-authentication-table", metadata159, authenticationTableOptions);
        Options<org.jboss.hal.dmr.NamedNode> authorizationTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.NamedNode>(metadata160)
            .button(mbuiContext.resources().constants().add(), Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/authorization=classic/policy-module=*:add)"), (event, api) -> presenter.addModule(Module.AUTHORIZATION))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/authorization=classic/policy-module=*:remove)"), (event, api) -> presenter.removeModule(api, Module.AUTHORIZATION))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        authorizationTable = new NamedNodeTable<>("security-domain-authorization-table", metadata160, authorizationTableOptions);
        Options<org.jboss.hal.dmr.NamedNode> auditTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.NamedNode>(metadata161)
            .button(mbuiContext.resources().constants().add(), Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/audit=classic/provider-module=*:add)"), (event, api) -> presenter.addModule(Module.AUDIT))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/audit=classic/provider-module=*:remove)"), (event, api) -> presenter.removeModule(api, Module.AUDIT))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        auditTable = new NamedNodeTable<>("security-domain-audit-table", metadata161, auditTableOptions);
        Options<org.jboss.hal.dmr.NamedNode> aclTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.NamedNode>(metadata162)
            .button(mbuiContext.resources().constants().add(), Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/acl=classic/acl-module=*:add)"), (event, api) -> presenter.addModule(Module.ACL))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/acl=classic/acl-module=*:remove)"), (event, api) -> presenter.removeModule(api, Module.ACL))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        aclTable = new NamedNodeTable<>("security-domain-acl-table", metadata162, aclTableOptions);
        Options<org.jboss.hal.dmr.NamedNode> trustTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.NamedNode>(metadata164)
            .button(mbuiContext.resources().constants().add(), Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/identity-trust=classic/trust-module=*:add)"), (event, api) -> presenter.addModule(Module.TRUST))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/identity-trust=classic/trust-module=*:remove)"), (event, api) -> presenter.removeModule(api, Module.TRUST))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        trustTable = new NamedNodeTable<>("security-domain-trust-table", metadata164, trustTableOptions);
        Options<org.jboss.hal.dmr.NamedNode> mappingTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.NamedNode>(metadata163)
            .button(mbuiContext.resources().constants().add(), Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/mapping=classic/mapping-module=*:add)"), (event, api) -> presenter.addModule(Module.MAPPING))
            .button(mbuiContext.resources().constants().remove(), Button.Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/mapping=classic/mapping-module=*:remove)"), (event, api) -> presenter.removeModule(api, Module.MAPPING))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        mappingTable = new NamedNodeTable<>("security-domain-mapping-table", metadata163, mappingTableOptions);

        navigation = new VerticalNavigation();
        Elements.Builder securityDomainConfigurationItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>{{metadata158.getDescription().getDescription()}}</p>"))
                    .rememberAs("html462")
                .end()
                .add(configurationForm)
            .end();
        Element securityDomainConfigurationItemElement = securityDomainConfigurationItemBuilder.build();
        handlebarElements.put("html462", securityDomainConfigurationItemBuilder.referenceFor("html462"));
        navigation.addPrimary("security-domain-configuration-item", "Configuration", "pficon pficon-settings", securityDomainConfigurationItemElement);
        Elements.Builder securityDomainAuthenticationItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Authentication Module</h1><p>{{metadata159.getDescription().getDescription()}}</p>"))
                    .rememberAs("html464")
                .end()
                .add(authenticationTable)
                .add(authenticationForm)
            .end();
        Element securityDomainAuthenticationItemElement = securityDomainAuthenticationItemBuilder.build();
        handlebarElements.put("html464", securityDomainAuthenticationItemBuilder.referenceFor("html464"));
        navigation.addPrimary("security-domain-authentication-item", "Authentication", "fa fa-sign-in", securityDomainAuthenticationItemElement);
        Elements.Builder securityDomainAuthorizationItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Authorization Module</h1><p>{{metadata160.getDescription().getDescription()}}</p>"))
                    .rememberAs("html467")
                .end()
                .add(authorizationTable)
                .add(authorizationForm)
            .end();
        Element securityDomainAuthorizationItemElement = securityDomainAuthorizationItemBuilder.build();
        handlebarElements.put("html467", securityDomainAuthorizationItemBuilder.referenceFor("html467"));
        navigation.addPrimary("security-domain-authorization-item", "Authorization", "fa fa-shield", securityDomainAuthorizationItemElement);
        Elements.Builder securityDomainAuditItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Audit Module</h1><p>{{metadata161.getDescription().getDescription()}}</p>"))
                    .rememberAs("html470")
                .end()
                .add(auditTable)
                .add(auditForm)
            .end();
        Element securityDomainAuditItemElement = securityDomainAuditItemBuilder.build();
        handlebarElements.put("html470", securityDomainAuditItemBuilder.referenceFor("html470"));
        navigation.addPrimary("security-domain-audit-item", "Audit", "fa fa-file-text-o", securityDomainAuditItemElement);
        Elements.Builder securityDomainAclItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>ACL Module</h1><p>{{metadata162.getDescription().getDescription()}}</p>"))
                    .rememberAs("html473")
                .end()
                .add(aclTable)
                .add(aclForm)
            .end();
        Element securityDomainAclItemElement = securityDomainAclItemBuilder.build();
        handlebarElements.put("html473", securityDomainAclItemBuilder.referenceFor("html473"));
        navigation.addPrimary("security-domain-acl-item", "ACL", "fa fa-lock", securityDomainAclItemElement);
        Elements.Builder securityDomainMappingItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Mapping Module</h1><p>{{metadata163.getDescription().getDescription()}}</p>"))
                    .rememberAs("html476")
                .end()
                .add(mappingTable)
                .add(mappingForm)
            .end();
        Element securityDomainMappingItemElement = securityDomainMappingItemBuilder.build();
        handlebarElements.put("html476", securityDomainMappingItemBuilder.referenceFor("html476"));
        navigation.addPrimary("security-domain-mapping-item", "Mapping", "fa fa-exchange", securityDomainMappingItemElement);
        Elements.Builder securityDomainTrustItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Trust Module</h1><p>{{metadata164.getDescription().getDescription()}}</p>"))
                    .rememberAs("html479")
                .end()
                .add(trustTable)
                .add(trustForm)
            .end();
        Element securityDomainTrustItemElement = securityDomainTrustItemBuilder.build();
        handlebarElements.put("html479", securityDomainTrustItemBuilder.referenceFor("html479"));
        navigation.addPrimary("security-domain-trust-item", "Identity Trust", "fa fa-handshake-o", securityDomainTrustItemElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(authenticationTable);
        registerAttachable(authenticationForm);
        registerAttachable(authorizationTable);
        registerAttachable(authorizationForm);
        registerAttachable(auditTable);
        registerAttachable(auditForm);
        registerAttachable(aclTable);
        registerAttachable(aclForm);
        registerAttachable(trustTable);
        registerAttachable(trustForm);
        registerAttachable(mappingTable);
        registerAttachable(mappingForm);

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            authenticationTable.bindForm(authenticationForm);
            authorizationTable.bindForm(authorizationForm);
            auditTable.bindForm(auditForm);
            aclTable.bindForm(aclForm);
            trustTable.bindForm(trustForm);
            mappingTable.bindForm(mappingForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html462"), "{{metadata158.getDescription().getDescription()}}", String.valueOf(metadata158.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html464"), "{{metadata159.getDescription().getDescription()}}", String.valueOf(metadata159.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html467"), "{{metadata160.getDescription().getDescription()}}", String.valueOf(metadata160.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html470"), "{{metadata161.getDescription().getDescription()}}", String.valueOf(metadata161.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html473"), "{{metadata162.getDescription().getDescription()}}", String.valueOf(metadata162.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html476"), "{{metadata163.getDescription().getDescription()}}", String.valueOf(metadata163.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html479"), "{{metadata164.getDescription().getDescription()}}", String.valueOf(metadata164.getDescription().getDescription()));
    }
}
