package org.jboss.hal.client.configuration.subsystem.security;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.table.NamedNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_SecurityView extends SecurityView {

    private final Metadata metadata167;
    private final Metadata metadata170;
    private final Metadata metadata168;
    private final Metadata metadata166;
    private final Metadata metadata171;
    private final Metadata metadata169;
    private final Metadata metadata165;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_SecurityView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata167Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-key-store=*");
        this.metadata167 = mbuiContext.metadataRegistry().lookup(metadata167Template);
        AddressTemplate metadata170Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-trust-store=*");
        this.metadata170 = mbuiContext.metadataRegistry().lookup(metadata170Template);
        AddressTemplate metadata168Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-realm=*");
        this.metadata168 = mbuiContext.metadataRegistry().lookup(metadata168Template);
        AddressTemplate metadata166Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-key-manager=*");
        this.metadata166 = mbuiContext.metadataRegistry().lookup(metadata166Template);
        AddressTemplate metadata171Template = AddressTemplate.of("/{selected.profile}/subsystem=security/vault=classic");
        this.metadata171 = mbuiContext.metadataRegistry().lookup(metadata171Template);
        AddressTemplate metadata169Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-trust-manager=*");
        this.metadata169 = mbuiContext.metadataRegistry().lookup(metadata169Template);
        AddressTemplate metadata165Template = AddressTemplate.of("/{selected.profile}/subsystem=security");
        this.metadata165 = mbuiContext.metadataRegistry().lookup(metadata165Template);
        this.handlebarElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("security-configuration-form", metadata165)
            .onSave((form, changedValues) -> saveSingletonForm("Configuration", metadata165Template.resolve(mbuiContext.statementContext()), changedValues, metadata165))
            .prepareReset(form -> resetSingletonForm("Configuration", metadata165Template.resolve(mbuiContext.statementContext()), form, metadata165))
            .build();
        keyManagerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-key-manager-form", metadata166)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Key Manager", name, metadata166Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata166);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Key Manager", name, metadata166Template.resolve(mbuiContext.statementContext(), name), form, metadata166);
            })
            .build();
        keyStoreForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-key-store-form", metadata167)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Key Store", name, metadata167Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata167);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Key Store", name, metadata167Template.resolve(mbuiContext.statementContext(), name), form, metadata167);
            })
            .build();
        realmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-realm-form", metadata168)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Realm", name, metadata168Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata168);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Realm", name, metadata168Template.resolve(mbuiContext.statementContext(), name), form, metadata168);
            })
            .build();
        trustManagerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-trust-manager-form", metadata169)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Trust Manager", name, metadata169Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata169);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Trust Manager", name, metadata169Template.resolve(mbuiContext.statementContext(), name), form, metadata169);
            })
            .build();
        trustStoreForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-trust-store-form", metadata170)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Trust Store", name, metadata170Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata170);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Trust Store", name, metadata170Template.resolve(mbuiContext.statementContext(), name), form, metadata170);
            })
            .build();
        vaultForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("security-vault-form", metadata171)
            .singleton(
                () -> new Operation.Builder(metadata171Template.resolve(mbuiContext.statementContext()), READ_RESOURCE_OPERATION).build(),
                () -> addSingleton("security-vault-form", "Vault", metadata171Template))
            .prepareRemove(form -> removeSingletonForm("Vault", metadata171Template.resolve(mbuiContext.statementContext()), form))
            .onSave((form, changedValues) -> saveSingletonForm("Vault", metadata171Template.resolve(mbuiContext.statementContext()), changedValues, metadata171))
            .prepareReset(form -> resetSingletonForm("Vault", metadata171Template.resolve(mbuiContext.statementContext()), form, metadata171))
            .build();

        Options<org.jboss.hal.dmr.NamedNode> keyManagerTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.NamedNode>(metadata166)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-key-manager-table", Ids.ADD_SUFFIX), "Elytron Key Manager",
                metadata166Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Key Manager", metadata166Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();
        keyManagerTable = new NamedNodeTable<>("security-elytron-key-manager-table", metadata166, keyManagerTableOptions);
        Options<org.jboss.hal.dmr.NamedNode> keyStoreTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.NamedNode>(metadata167)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-key-store-table", Ids.ADD_SUFFIX), "Elytron Key Store",
                metadata167Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Key Store", metadata167Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();
        keyStoreTable = new NamedNodeTable<>("security-elytron-key-store-table", metadata167, keyStoreTableOptions);
        Options<org.jboss.hal.dmr.NamedNode> realmTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.NamedNode>(metadata168)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-realm-table", Ids.ADD_SUFFIX), "Elytron Realm",
                metadata168Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Realm", metadata168Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jaas-config")
            .build();
        realmTable = new NamedNodeTable<>("security-elytron-realm-table", metadata168, realmTableOptions);
        Options<org.jboss.hal.dmr.NamedNode> trustManagerTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.NamedNode>(metadata169)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-trust-manager-table", Ids.ADD_SUFFIX), "Elytron Trust Manager",
                metadata169Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Trust Manager", metadata169Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();
        trustManagerTable = new NamedNodeTable<>("security-elytron-trust-manager-table", metadata169, trustManagerTableOptions);
        Options<org.jboss.hal.dmr.NamedNode> trustStoreTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.NamedNode>(metadata170)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-trust-store-table", Ids.ADD_SUFFIX), "Elytron Trust Store",
                metadata170Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Trust Store", metadata170Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("legacy-jsse-config")
            .build();
        trustStoreTable = new NamedNodeTable<>("security-elytron-trust-store-table", metadata170, trustStoreTableOptions);

        navigation = new VerticalNavigation();
        Elements.Builder securityConfigurationItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>{{metadata165.getDescription().getDescription()}}</p>"))
                    .rememberAs("html483")
                .end()
                .add(configurationForm)
            .end();
        Element securityConfigurationItemElement = securityConfigurationItemBuilder.build();
        handlebarElements.put("html483", securityConfigurationItemBuilder.referenceFor("html483"));
        navigation.addPrimary("security-configuration-item", "Configuration", "pficon pficon-settings", securityConfigurationItemElement);
        Elements.Builder securityElytronKeyManagerItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Key Manager</h1><p>{{metadata166.getDescription().getDescription()}}</p>"))
                    .rememberAs("html485")
                .end()
                .add(keyManagerTable)
                .add(keyManagerForm)
            .end();
        Element securityElytronKeyManagerItemElement = securityElytronKeyManagerItemBuilder.build();
        handlebarElements.put("html485", securityElytronKeyManagerItemBuilder.referenceFor("html485"));
        navigation.addPrimary("security-elytron-key-manager-item", "Key Manager", "fa fa-key", securityElytronKeyManagerItemElement);
        Elements.Builder securityElytronKeyStoreItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Key Store</h1><p>{{metadata167.getDescription().getDescription()}}</p>"))
                    .rememberAs("html488")
                .end()
                .add(keyStoreTable)
                .add(keyStoreForm)
            .end();
        Element securityElytronKeyStoreItemElement = securityElytronKeyStoreItemBuilder.build();
        handlebarElements.put("html488", securityElytronKeyStoreItemBuilder.referenceFor("html488"));
        navigation.addPrimary("security-elytron-key-store-item", "Key Store", "fa fa-key", securityElytronKeyStoreItemElement);
        Elements.Builder securityElytronRealmItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Realm</h1><p>{{metadata168.getDescription().getDescription()}}</p>"))
                    .rememberAs("html491")
                .end()
                .add(realmTable)
                .add(realmForm)
            .end();
        Element securityElytronRealmItemElement = securityElytronRealmItemBuilder.build();
        handlebarElements.put("html491", securityElytronRealmItemBuilder.referenceFor("html491"));
        navigation.addPrimary("security-elytron-realm-item", "Realm", "fa fa-map", securityElytronRealmItemElement);
        Elements.Builder securityElytronTrustManagerItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Trust Manager</h1><p>{{metadata169.getDescription().getDescription()}}</p>"))
                    .rememberAs("html494")
                .end()
                .add(trustManagerTable)
                .add(trustManagerForm)
            .end();
        Element securityElytronTrustManagerItemElement = securityElytronTrustManagerItemBuilder.build();
        handlebarElements.put("html494", securityElytronTrustManagerItemBuilder.referenceFor("html494"));
        navigation.addPrimary("security-elytron-trust-manager-item", "Trust Manager", "fa fa-lock", securityElytronTrustManagerItemElement);
        Elements.Builder securityElytronTrustStoreItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Trust Store</h1><p>{{metadata170.getDescription().getDescription()}}</p>"))
                    .rememberAs("html497")
                .end()
                .add(trustStoreTable)
                .add(trustStoreForm)
            .end();
        Element securityElytronTrustStoreItemElement = securityElytronTrustStoreItemBuilder.build();
        handlebarElements.put("html497", securityElytronTrustStoreItemBuilder.referenceFor("html497"));
        navigation.addPrimary("security-elytron-trust-store-item", "Trust Store", "fa fa-lock", securityElytronTrustStoreItemElement);
        Elements.Builder securityVaultItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Vault</h1><p>{{metadata171.getDescription().getDescription()}}</p>"))
                    .rememberAs("html500")
                .end()
                .add(vaultForm)
            .end();
        Element securityVaultItemElement = securityVaultItemBuilder.build();
        handlebarElements.put("html500", securityVaultItemBuilder.referenceFor("html500"));
        navigation.addPrimary("security-vault-item", "Vault", "fa fa-shield", securityVaultItemElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(keyManagerTable);
        registerAttachable(keyManagerForm);
        registerAttachable(keyStoreTable);
        registerAttachable(keyStoreForm);
        registerAttachable(realmTable);
        registerAttachable(realmForm);
        registerAttachable(trustManagerTable);
        registerAttachable(trustManagerForm);
        registerAttachable(trustStoreTable);
        registerAttachable(trustStoreForm);
        registerAttachable(vaultForm);

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            keyManagerTable.bindForm(keyManagerForm);
            keyStoreTable.bindForm(keyStoreForm);
            realmTable.bindForm(realmForm);
            trustManagerTable.bindForm(trustManagerForm);
            trustStoreTable.bindForm(trustStoreForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html483"), "{{metadata165.getDescription().getDescription()}}", String.valueOf(metadata165.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html485"), "{{metadata166.getDescription().getDescription()}}", String.valueOf(metadata166.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html488"), "{{metadata167.getDescription().getDescription()}}", String.valueOf(metadata167.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html491"), "{{metadata168.getDescription().getDescription()}}", String.valueOf(metadata168.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html494"), "{{metadata169.getDescription().getDescription()}}", String.valueOf(metadata169.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html497"), "{{metadata170.getDescription().getDescription()}}", String.valueOf(metadata170.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html500"), "{{metadata171.getDescription().getDescription()}}", String.valueOf(metadata171.getDescription().getDescription()));
    }
}
