package org.jboss.hal.client.configuration.subsystem.undertow;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.table.NamedNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_HandlerView extends HandlerView {

    private final Metadata metadata183;
    private final Metadata metadata182;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_HandlerView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata183Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=handler/reverse-proxy=*");
        this.metadata183 = mbuiContext.metadataRegistry().lookup(metadata183Template);
        AddressTemplate metadata182Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=handler/file=*");
        this.metadata182 = mbuiContext.metadataRegistry().lookup(metadata182Template);
        this.handlebarElements = new HashMap<>();

        fileHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-file-handler-form", metadata182)
            .include("cache-buffer-size")
            .include("cache-buffers")
            .include("case-sensitive")
            .include("directory-listing")
            .include("follow-symlink")
            .include("path")
            .include("safe-symlink-paths")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisHandler()), 7)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("File Handler", name, metadata182Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata182);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("File Handler", name, metadata182Template.resolve(mbuiContext.statementContext(), name), form, metadata182);
            })
            .build();
        reverseProxyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-reverse-proxy-form", metadata183)
            .include("cached-connections-per-thread")
            .include("connection-idle-timeout")
            .include("connections-per-thread")
            .include("max-request-time")
            .include("max-retries")
            .include("problem-server-retry")
            .include("request-queue-size")
            .include("session-cookie-names")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisHandler()), 8)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Reverse Proxy", name, metadata183Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata183);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Reverse Proxy", name, metadata183Template.resolve(mbuiContext.statementContext(), name), form, metadata183);
            })
            .build();

        Options<org.jboss.hal.dmr.NamedNode> fileHandlerTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.NamedNode>(metadata182)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-file-handler-table", Ids.ADD_SUFFIX), "File Handler",
                metadata182Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("File Handler", metadata182Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("path")
            .build();
        fileHandlerTable = new NamedNodeTable<>("undertow-file-handler-table", metadata182, fileHandlerTableOptions);
        Options<org.jboss.hal.dmr.NamedNode> reverseProxyTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.NamedNode>(metadata183)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-reverse-proxy-table", Ids.ADD_SUFFIX), "Reverse Proxy",
                metadata183Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Reverse Proxy", metadata183Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        reverseProxyTable = new NamedNodeTable<>("undertow-reverse-proxy-table", metadata183, reverseProxyTableOptions);

        navigation = new VerticalNavigation();
        Elements.Builder undertowFileHandlerItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>File Handler</h1><p>{{metadata182.getDescription().getDescription()}}</p>"))
                    .rememberAs("html542")
                .end()
                .add(fileHandlerTable)
                .add(fileHandlerForm)
            .end();
        Element undertowFileHandlerItemElement = undertowFileHandlerItemBuilder.build();
        handlebarElements.put("html542", undertowFileHandlerItemBuilder.referenceFor("html542"));
        navigation.addPrimary("undertow-file-handler-item", "File Handler", "fa fa-file-text-o", undertowFileHandlerItemElement);
        Elements.Builder undertowReverseProxyItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Reverse Proxy</h1><p>{{metadata183.getDescription().getDescription()}}</p>"))
                    .rememberAs("html545")
                .end()
                .add(reverseProxyTable)
                .add(reverseProxyForm)
            .end();
        Element undertowReverseProxyItemElement = undertowReverseProxyItemBuilder.build();
        handlebarElements.put("html545", undertowReverseProxyItemBuilder.referenceFor("html545"));
        navigation.addPrimary("undertow-reverse-proxy-item", "Reverse Proxy", "fa fa-undo", undertowReverseProxyItemElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        registerAttachable(navigation);
        registerAttachable(fileHandlerTable);
        registerAttachable(fileHandlerForm);
        registerAttachable(reverseProxyTable);
        registerAttachable(reverseProxyForm);

        Element root = layoutBuilder.build();
        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            fileHandlerTable.bindForm(fileHandlerForm);
            reverseProxyTable.bindForm(reverseProxyForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html542"), "{{metadata182.getDescription().getDescription()}}", String.valueOf(metadata182.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html545"), "{{metadata183.getDescription().getDescription()}}", String.valueOf(metadata183.getDescription().getDescription()));
    }
}
