package org.jboss.hal.client.configuration.subsystem.undertow;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.table.NamedNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_UndertowSubsystemView extends UndertowSubsystemView {

    private final Metadata metadata184;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_UndertowSubsystemView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata184Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow");
        this.metadata184 = mbuiContext.metadataRegistry().lookup(metadata184Template);
        this.handlebarElements = new HashMap<>();

        form = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("undertow-global-settings-form", metadata184)
            .include("default-security-domain", "default-server", "default-servlet-container", "default-virtual-host", "instance-id", "statistics-enabled")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Undertow Configuration", metadata184Template.resolve(mbuiContext.statementContext()), changedValues, metadata184))
            .prepareReset(form -> resetSingletonForm("Undertow Configuration", metadata184Template.resolve(mbuiContext.statementContext()), form, metadata184))
            .build();
        form.getFormItem("default-security-domain").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*")));
        form.getFormItem("default-server").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=undertow/server=*")));
        form.getFormItem("default-servlet-container").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=undertow/servlet-container=*")));
        form.getFormItem("default-virtual-host").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=undertow/server=*/host=*")));


        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .div()
                        .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Undertow Configuration</h1><p>{{metadata184.getDescription().getDescription()}}</p>"))
                        .rememberAs("html549")
                    .end()
                    .add(form)
                .end()
            .end();
            handlebarElements.put("html549", layoutBuilder.referenceFor("html549"));

        registerAttachable(form);

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();


        TemplateUtil.replaceHandlebar(handlebarElements.get("html549"), "{{metadata184.getDescription().getDescription()}}", String.valueOf(metadata184.getDescription().getDescription()));
    }
}
