package org.jboss.hal.client.runtime.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Button;
import org.jboss.hal.ballroom.table.Options;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.table.NamedNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_ServerView extends ServerView {

    private final Metadata metadata196;
    private final Metadata metadata197;
    private final Metadata metadata195;
    private final Metadata metadata199;
    private final Metadata metadata198;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_ServerView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata196Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/interface=*");
        this.metadata196 = mbuiContext.metadataRegistry().lookup(metadata196Template);
        AddressTemplate metadata197Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/jvm=*");
        this.metadata197 = mbuiContext.metadataRegistry().lookup(metadata197Template);
        AddressTemplate metadata195Template = AddressTemplate.of("/{selected.host}/{selected.server-config}");
        this.metadata195 = mbuiContext.metadataRegistry().lookup(metadata195Template);
        AddressTemplate metadata199Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/system-property=*");
        this.metadata199 = mbuiContext.metadataRegistry().lookup(metadata199Template);
        AddressTemplate metadata198Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/path=*");
        this.metadata198 = mbuiContext.metadataRegistry().lookup(metadata198Template);
        this.handlebarElements = new HashMap<>();

        serverConfigurationForm = new ModelNodeForm.Builder<org.jboss.hal.core.runtime.server.Server>("server-configuration-form", metadata195)
            .includeRuntime()
            .include("name")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("host"), 1)
            .include("group")
            .include("auto-start")
            .include("update-auto-start-with-server-status")
            .include("socket-binding-group")
            .include("socket-binding-port-offset")
            .include("socket-binding-default-interface")
            .include("status")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Server Configuration", metadata195Template.resolve(mbuiContext.statementContext()), changedValues, metadata195))
            .prepareReset(form -> resetSingletonForm("Server Configuration", metadata195Template.resolve(mbuiContext.statementContext()), form, metadata195))
            .build();
        serverInterfaceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-interface-form", metadata196)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Interface", name, metadata196Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata196);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Interface", name, metadata196Template.resolve(mbuiContext.statementContext(), name), form, metadata196);
            })
            .build();
        serverJvmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-jvm-form", metadata197)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Jvm", name, metadata197Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata197);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Jvm", name, metadata197Template.resolve(mbuiContext.statementContext(), name), form, metadata197);
            })
            .build();
        serverPathForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-path-form", metadata198)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Path", name, metadata198Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata198);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Path", name, metadata198Template.resolve(mbuiContext.statementContext(), name), form, metadata198);
            })
            .build();
        serverSystemPropertyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-system-property-form", metadata199)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("System Property", name, metadata199Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata199);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("System Property", name, metadata199Template.resolve(mbuiContext.statementContext(), name), form, metadata199);
            })
            .build();

        Options<org.jboss.hal.dmr.NamedNode> serverInterfaceTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.NamedNode>(metadata196)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-interface-table", Ids.ADD_SUFFIX), "Interface",
                metadata196Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Interface", metadata196Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        serverInterfaceTable = new NamedNodeTable<>("server-interface-table", metadata196, serverInterfaceTableOptions);
        Options<org.jboss.hal.dmr.NamedNode> serverJvmTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.NamedNode>(metadata197)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-jvm-table", Ids.ADD_SUFFIX), "Jvm",
                metadata197Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Jvm", metadata197Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        serverJvmTable = new NamedNodeTable<>("server-jvm-table", metadata197, serverJvmTableOptions);
        Options<org.jboss.hal.dmr.NamedNode> serverPathTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.NamedNode>(metadata198)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-path-table", Ids.ADD_SUFFIX), "Path",
                metadata198Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Path", metadata198Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "path")
            .build();
        serverPathTable = new NamedNodeTable<>("server-path-table", metadata198, serverPathTableOptions);
        Options<org.jboss.hal.dmr.NamedNode> serverSystemPropertyTableOptions = new NamedNodeTable.Builder<org.jboss.hal.dmr.NamedNode>(metadata199)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-system-property-table", Ids.ADD_SUFFIX), "System Property",
                metadata199Template, asList("value"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("System Property", metadata199Template,
                (api) -> api.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("value")
            .build();
        serverSystemPropertyTable = new NamedNodeTable<>("server-system-property-table", metadata199, serverSystemPropertyTableOptions);

        navigation = new VerticalNavigation();
        Elements.Builder serverConfigurationItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Server Configuration</h1><p>{{metadata195.getDescription().getDescription()}}</p>"))
                    .rememberAs("html581")
                .end()
                .add(serverConfigurationForm)
            .end();
        Element serverConfigurationItemElement = serverConfigurationItemBuilder.build();
        handlebarElements.put("html581", serverConfigurationItemBuilder.referenceFor("html581"));
        navigation.addPrimary("server-configuration-item", "Configuration", "pficon pficon-settings", serverConfigurationItemElement);
        Elements.Builder serverInterfaceItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Interfaces</h1><p>{{metadata196.getDescription().getDescription()}}</p>"))
                    .rememberAs("html583")
                .end()
                .add(serverInterfaceTable)
                .add(serverInterfaceForm)
            .end();
        Element serverInterfaceItemElement = serverInterfaceItemBuilder.build();
        handlebarElements.put("html583", serverInterfaceItemBuilder.referenceFor("html583"));
        navigation.addPrimary("server-interface-item", "Interfaces", "fa fa-exchange", serverInterfaceItemElement);
        Elements.Builder serverJvmItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JVMs</h1><p>{{metadata197.getDescription().getDescription()}}</p>"))
                    .rememberAs("html586")
                .end()
                .add(serverJvmTable)
                .add(serverJvmForm)
            .end();
        Element serverJvmItemElement = serverJvmItemBuilder.build();
        handlebarElements.put("html586", serverJvmItemBuilder.referenceFor("html586"));
        navigation.addPrimary("server-jvm-item", "JVMs", "fa fa-coffee", serverJvmItemElement);
        Elements.Builder serverPathItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Paths</h1><p>{{metadata198.getDescription().getDescription()}}</p>"))
                    .rememberAs("html589")
                .end()
                .add(serverPathTable)
                .add(serverPathForm)
            .end();
        Element serverPathItemElement = serverPathItemBuilder.build();
        handlebarElements.put("html589", serverPathItemBuilder.referenceFor("html589"));
        navigation.addPrimary("server-path-item", "Paths", "fa fa-folder-open", serverPathItemElement);
        Elements.Builder serverSystemPropertyItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>System Properties</h1><p>{{metadata199.getDescription().getDescription()}}</p>"))
                    .rememberAs("html592")
                .end()
                .add(serverSystemPropertyTable)
                .add(serverSystemPropertyForm)
            .end();
        Element serverSystemPropertyItemElement = serverSystemPropertyItemBuilder.build();
        handlebarElements.put("html592", serverSystemPropertyItemBuilder.referenceFor("html592"));
        navigation.addPrimary("server-system-property-item", "System Properties", "fa fa-list-ul", serverSystemPropertyItemElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        registerAttachable(navigation);
        registerAttachable(serverConfigurationForm);
        registerAttachable(serverInterfaceTable);
        registerAttachable(serverInterfaceForm);
        registerAttachable(serverJvmTable);
        registerAttachable(serverJvmForm);
        registerAttachable(serverPathTable);
        registerAttachable(serverPathForm);
        registerAttachable(serverSystemPropertyTable);
        registerAttachable(serverSystemPropertyForm);

        Element root = layoutBuilder.build();
        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            serverInterfaceTable.bindForm(serverInterfaceForm);
            serverJvmTable.bindForm(serverJvmForm);
            serverPathTable.bindForm(serverPathForm);
            serverSystemPropertyTable.bindForm(serverSystemPropertyForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html581"), "{{metadata195.getDescription().getDescription()}}", String.valueOf(metadata195.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html583"), "{{metadata196.getDescription().getDescription()}}", String.valueOf(metadata196.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html586"), "{{metadata197.getDescription().getDescription()}}", String.valueOf(metadata197.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html589"), "{{metadata198.getDescription().getDescription()}}", String.valueOf(metadata198.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html592"), "{{metadata199.getDescription().getDescription()}}", String.valueOf(metadata199.getDescription().getDescription()));
    }
}
