package org.jboss.hal.client.configuration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_PathsView extends PathsView {

    private final Metadata metadata1;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_PathsView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata1Template = AddressTemplate.of("/path=*");
        this.metadata1 = mbuiContext.metadataRegistry().lookup(metadata1Template);
        this.handlebarElements = new HashMap<>();

        form = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("path-form", metadata1)
            .include("name", "path", "relative-to")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Path", name, metadata1Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata1);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Path", name, metadata1Template.resolve(mbuiContext.statementContext(), name), form, metadata1);
            })
            .build();
        form.getFormItem("relative-to").registerSuggestHandler(new PathsAutoComplete());

        table = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("path-table", metadata1)
            .button(mbuiContext.tableButtonFactory().add(metadata1Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("path-table", Ids.ADD_SUFFIX),
                    mbuiContext.resources().messages().addResourceTitle("Path"),
                    metadata1,
                    asList("name", "path", "relative-to"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata1Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("Path", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.getForm().getFormItem("name").addValidationHandler(new org.jboss.hal.ballroom.form.BlacklistValidation("jboss.home", "user.home", "user.dir", "java.home", "jboss.server.base.dir"));
                dialog.getForm().getFormItem("relative-to").registerSuggestHandler(new PathsAutoComplete());
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Path", metadata1Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "path")
            .build();

        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .div()
                        .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Paths</h1><p>{{metadata1.getDescription().getDescription()}}</p>"))
                        .rememberAs("html2")
                    .end()
                    .add(table)
                    .add(form)
                .end()
            .end();
            handlebarElements.put("html2", layoutBuilder.referenceFor("html2"));

        registerAttachable(table);
        registerAttachable(form);

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            table.bindForm(form);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html2"), "{{metadata1.getDescription().getDescription()}}", String.valueOf(metadata1.getDescription().getDescription()));
    }
}
