package org.jboss.hal.client.configuration.subsystem.batch;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_BatchView extends BatchView {

    private final Metadata metadata9;
    private final Metadata metadata8;
    private final Metadata metadata5;
    private final Metadata metadata7;
    private final Metadata metadata6;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_BatchView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata9Template = AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet/thread-pool=*");
        this.metadata9 = mbuiContext.metadataRegistry().lookup(metadata9Template);
        AddressTemplate metadata8Template = AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet/thread-factory=*");
        this.metadata8 = mbuiContext.metadataRegistry().lookup(metadata8Template);
        AddressTemplate metadata5Template = AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet");
        this.metadata5 = mbuiContext.metadataRegistry().lookup(metadata5Template);
        AddressTemplate metadata7Template = AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet/jdbc-job-repository=*");
        this.metadata7 = mbuiContext.metadataRegistry().lookup(metadata7Template);
        AddressTemplate metadata6Template = AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet/in-memory-job-repository=*");
        this.metadata6 = mbuiContext.metadataRegistry().lookup(metadata6Template);
        this.handlebarElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("batch-configuration-form", metadata5)
            .onSave((form, changedValues) -> saveSingletonForm("Subsystem", metadata5Template.resolve(mbuiContext.statementContext()), changedValues, metadata5))
            .prepareReset(form -> resetSingletonForm("Subsystem", metadata5Template.resolve(mbuiContext.statementContext()), form, metadata5))
            .build();
        jdbcJobRepoForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("batch-jdbc-job-repo-form", metadata7)
            .include("data-source")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("JDBC Job Repository", name, metadata7Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata7);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("JDBC Job Repository", name, metadata7Template.resolve(mbuiContext.statementContext(), name), form, metadata7);
            })
            .build();
        jdbcJobRepoForm.getFormItem("data-source").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=datasources/data-source=*")));
        threadFactoryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("batch-thread-factory-form", metadata8)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Thread Factory", name, metadata8Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata8);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Thread Factory", name, metadata8Template.resolve(mbuiContext.statementContext(), name), form, metadata8);
            })
            .build();
        threadPoolForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("batch-thread-pool-form", metadata9)
            .include("name", "max-threads", "thread-factory")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Thread Pool", name, metadata9Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata9);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Thread Pool", name, metadata9Template.resolve(mbuiContext.statementContext(), name), form, metadata9);
            })
            .build();
        threadPoolForm.getFormItem("thread-factory").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet/thread-factory=*")));

        inMemoryJobRepoTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("batch-in-memory-job-repo-table", metadata6)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("batch-in-memory-job-repo-table", Ids.ADD_SUFFIX), "In Memory Job",
                metadata6Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("In Memory Job", metadata6Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        jdbcJobRepoTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("batch-jdbc-job-repo-table", metadata7)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("batch-jdbc-job-repo-table", Ids.ADD_SUFFIX), "JDBC Job Repository",
                metadata7Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("JDBC Job Repository", metadata7Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        threadFactoryTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("batch-thread-factory-table", metadata8)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("batch-thread-factory-table", Ids.ADD_SUFFIX), "Thread Factory",
                metadata8Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Thread Factory", metadata8Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        threadPoolTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("batch-thread-pool-table", metadata9)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("batch-thread-pool-table", Ids.ADD_SUFFIX), "Thread Pool",
                metadata9Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Thread Pool", metadata9Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        Elements.Builder batchConfigurationItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>{{metadata5.getDescription().getDescription()}}</p>"))
                    .rememberAs("html14")
                .end()
                .add(configurationForm)
            .end();
        Element batchConfigurationItemElement = batchConfigurationItemBuilder.build();
        handlebarElements.put("html14", batchConfigurationItemBuilder.referenceFor("html14"));
        navigation.addPrimary("batch-configuration-item", "Configuration", "pficon pficon-settings", batchConfigurationItemElement);
        Elements.Builder batchInMemoryJobRepoItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>In Memory Job Repository</h1><p>{{metadata6.getDescription().getDescription()}}</p>"))
                    .rememberAs("html16")
                .end()
                .add(inMemoryJobRepoTable)
            .end();
        Element batchInMemoryJobRepoItemElement = batchInMemoryJobRepoItemBuilder.build();
        handlebarElements.put("html16", batchInMemoryJobRepoItemBuilder.referenceFor("html16"));
        navigation.addPrimary("batch-in-memory-job-repo-item", "In Memory", "pficon pficon-memory", batchInMemoryJobRepoItemElement);
        Elements.Builder batchJdbcJobRepoItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JDBC Job Repository</h1><p>{{metadata7.getDescription().getDescription()}}</p>"))
                    .rememberAs("html18")
                .end()
                .add(jdbcJobRepoTable)
                .add(jdbcJobRepoForm)
            .end();
        Element batchJdbcJobRepoItemElement = batchJdbcJobRepoItemBuilder.build();
        handlebarElements.put("html18", batchJdbcJobRepoItemBuilder.referenceFor("html18"));
        navigation.addPrimary("batch-jdbc-job-repo-item", "JDBC", "fa fa-database", batchJdbcJobRepoItemElement);
        Elements.Builder batchThreadFactoryItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Thread Factory</h1><p>{{metadata8.getDescription().getDescription()}}</p>"))
                    .rememberAs("html21")
                .end()
                .add(threadFactoryTable)
                .add(threadFactoryForm)
            .end();
        Element batchThreadFactoryItemElement = batchThreadFactoryItemBuilder.build();
        handlebarElements.put("html21", batchThreadFactoryItemBuilder.referenceFor("html21"));
        navigation.addPrimary("batch-thread-factory-item", "Thread Factory", "pficon pficon-service", batchThreadFactoryItemElement);
        Elements.Builder batchThreadPoolItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Thread Pool</h1><p>{{metadata9.getDescription().getDescription()}}</p>"))
                    .rememberAs("html24")
                .end()
                .add(threadPoolTable)
                .add(threadPoolForm)
            .end();
        Element batchThreadPoolItemElement = batchThreadPoolItemBuilder.build();
        handlebarElements.put("html24", batchThreadPoolItemBuilder.referenceFor("html24"));
        navigation.addPrimary("batch-thread-pool-item", "Thread Pool", "pficon pficon-resource-pool", batchThreadPoolItemElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(inMemoryJobRepoTable);
        registerAttachable(jdbcJobRepoTable);
        registerAttachable(jdbcJobRepoForm);
        registerAttachable(threadFactoryTable);
        registerAttachable(threadFactoryForm);
        registerAttachable(threadPoolTable);
        registerAttachable(threadPoolForm);

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            jdbcJobRepoTable.bindForm(jdbcJobRepoForm);
            threadFactoryTable.bindForm(threadFactoryForm);
            threadPoolTable.bindForm(threadPoolForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html14"), "{{metadata5.getDescription().getDescription()}}", String.valueOf(metadata5.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html16"), "{{metadata6.getDescription().getDescription()}}", String.valueOf(metadata6.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html18"), "{{metadata7.getDescription().getDescription()}}", String.valueOf(metadata7.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html21"), "{{metadata8.getDescription().getDescription()}}", String.valueOf(metadata8.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html24"), "{{metadata9.getDescription().getDescription()}}", String.valueOf(metadata9.getDescription().getDescription()));
    }
}
