package org.jboss.hal.client.configuration.subsystem.logging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_LoggingProfileView extends LoggingProfileView {

    private final org.jboss.hal.core.CrudOperations crud;
    private final Metadata metadata103;
    private final Metadata metadata99;
    private final Metadata metadata104;
    private final Metadata metadata97;
    private final Metadata metadata96;
    private final Metadata metadata93;
    private final Metadata metadata101;
    private final Metadata metadata100;
    private final Metadata metadata95;
    private final Metadata metadata94;
    private final Metadata metadata102;
    private final Metadata metadata98;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_LoggingProfileView(MbuiContext mbuiContext, org.jboss.hal.core.CrudOperations crud) {
        super(mbuiContext);

        this.crud = crud;
        AddressTemplate metadata103Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/pattern-formatter=*");
        this.metadata103 = mbuiContext.metadataRegistry().lookup(metadata103Template);
        AddressTemplate metadata99Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/size-rotating-file-handler=*");
        this.metadata99 = mbuiContext.metadataRegistry().lookup(metadata99Template);
        AddressTemplate metadata104Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/custom-formatter=*");
        this.metadata104 = mbuiContext.metadataRegistry().lookup(metadata104Template);
        AddressTemplate metadata97Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/periodic-rotating-file-handler=*");
        this.metadata97 = mbuiContext.metadataRegistry().lookup(metadata97Template);
        AddressTemplate metadata96Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/file-handler=*");
        this.metadata96 = mbuiContext.metadataRegistry().lookup(metadata96Template);
        AddressTemplate metadata93Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/root-logger=ROOT");
        this.metadata93 = mbuiContext.metadataRegistry().lookup(metadata93Template);
        AddressTemplate metadata101Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/custom-handler=*");
        this.metadata101 = mbuiContext.metadataRegistry().lookup(metadata101Template);
        AddressTemplate metadata100Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/async-handler=*");
        this.metadata100 = mbuiContext.metadataRegistry().lookup(metadata100Template);
        AddressTemplate metadata95Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/console-handler=*");
        this.metadata95 = mbuiContext.metadataRegistry().lookup(metadata95Template);
        AddressTemplate metadata94Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/logger=*");
        this.metadata94 = mbuiContext.metadataRegistry().lookup(metadata94Template);
        AddressTemplate metadata102Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/syslog-handler=*");
        this.metadata102 = mbuiContext.metadataRegistry().lookup(metadata102Template);
        AddressTemplate metadata98Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile=*/periodic-size-rotating-file-handler=*");
        this.metadata98 = mbuiContext.metadataRegistry().lookup(metadata98Template);
        this.handlebarElements = new HashMap<>();

        rootLoggerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("logging-profile-root-logger-form", metadata93)
            .include("level", "handlers", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveRootLogger(form, changedValues))
            .prepareReset(form -> resetRootLogger(form))
            .build();
        loggerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-categories-form", metadata94)
            .include("category", "level", "handlers", "use-parent-handlers", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveLogger(form, changedValues))
            .prepareReset(form -> resetLogger(form))
            .build();
        consoleHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-console-form", metadata95)
            .include("level", "target", "autoflush", "formatter", "named-formatter", "enabled", "encoding", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveConsoleHandler(form, changedValues))
            .prepareReset(form -> resetConsoleHandler(form))
            .build();
        List<AddressTemplate> consoleHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-formatter=*"));
        consoleHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), consoleHandlerFormTemplates));
        fileHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-file-form", metadata96)
            .customFormItem("file", attributeDescription -> new FileFormItem())
            .include("level")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveFileHandler(form, changedValues))
            .prepareReset(form -> resetFileHandler(form))
            .build();
        List<AddressTemplate> fileHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-formatter=*"));
        fileHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), fileHandlerFormTemplates));
        periodicHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-periodic-rotating-file-form", metadata97)
            .customFormItem("file", attributeDescription -> new FileFormItem())
            .include("suffix")
            .include("level")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> savePeriodicHandler(form, changedValues))
            .prepareReset(form -> resetPeriodicHandler(form))
            .build();
        List<AddressTemplate> periodicHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-formatter=*"));
        periodicHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), periodicHandlerFormTemplates));
        periodicSizeHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-periodic-size-rotating-file-form", metadata98)
            .customFormItem("file", attributeDescription -> new FileFormItem())
            .include("suffix")
            .include("level")
            .include("rotate-size")
            .include("rotate-on-boot")
            .include("max-backup-index")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> savePeriodicSizeHandler(form, changedValues))
            .prepareReset(form -> resetPeriodicSizeHandler(form))
            .build();
        List<AddressTemplate> periodicSizeHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-formatter=*"));
        periodicSizeHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), periodicSizeHandlerFormTemplates));
        sizeHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-size-rotating-file-form", metadata99)
            .customFormItem("file", attributeDescription -> new FileFormItem())
            .include("suffix")
            .include("level")
            .include("rotate-size")
            .include("rotate-on-boot")
            .include("max-backup-index")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveSizeHandler(form, changedValues))
            .prepareReset(form -> resetSizeHandler(form))
            .build();
        List<AddressTemplate> sizeHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-formatter=*"));
        sizeHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), sizeHandlerFormTemplates));
        asyncHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-async-form", metadata100)
            .include("level", "subhandlers", "queue-length", "overflow-action", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveAsyncHandler(form, changedValues))
            .prepareReset(form -> resetAsyncHandler(form))
            .build();
        List<AddressTemplate> asyncHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/console-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/periodic-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/periodic-size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/syslog-handler=*"));
        asyncHandlerForm.getFormItem("subhandlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), asyncHandlerFormTemplates));
        customHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-custom-form", metadata101)
            .include("level", "module", "class", "properties", "formatter", "named-formatter", "enabled", "encoding", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveCustomHandler(form, changedValues))
            .prepareReset(form -> resetCustomHandler(form))
            .build();
        List<AddressTemplate> customHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/logging-profile={selection}/custom-formatter=*"));
        customHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), customHandlerFormTemplates));
        syslogHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-syslog-form", metadata102)
            .include("level", "syslog-format", "hostname", "server-address", "port", "app-name", "facility", "enabled")
            .unsorted()
            .onSave((form, changedValues) -> saveSyslogHandler(form, changedValues))
            .prepareReset(form -> resetSyslogHandler(form))
            .build();
        customFormatterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-formatter-custom-form", metadata104)
            .include("class", "module", "properties")
            .unsorted()
            .onSave((form, changedValues) -> saveCustomFormatter(form, changedValues))
            .prepareReset(form -> resetCustomFormatter(form))
            .build();
        patternFormatterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-formatter-pattern-form", metadata103)
            .include("color-map", "pattern")
            .unsorted()
            .onSave((form, changedValues) -> savePatternFormatter(form, changedValues))
            .prepareReset(form -> resetPatternFormatter(form))
            .build();

        loggerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-categories-table", metadata94)
            .button(mbuiContext.resources().constants().add(), table -> addLogger(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/logger=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeLogger(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/logger=*:remove)"))
            .columns("category", "level")
            .build();
        consoleHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-console-table", metadata95)
            .button(mbuiContext.resources().constants().add(), table -> addConsoleHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/console-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeConsoleHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/console-handler=*:remove)"))
            .columns("name", "level", "target")
            .build();
        fileHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-file-table", metadata96)
            .button(mbuiContext.resources().constants().add(), table -> addFileHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/file-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeFileHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/file-handler=*:remove)"))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        periodicHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-periodic-rotating-file-table", metadata97)
            .button(mbuiContext.resources().constants().add(), table -> addPeriodicHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/periodic-rotating-file-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removePeriodicHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/periodic-rotating-file-handler=*:remove)"))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        periodicSizeHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-periodic-size-rotating-file-table", metadata98)
            .button(mbuiContext.resources().constants().add(), table -> addPeriodicSizeHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/periodic-size-rotating-file-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removePeriodicSizeHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/periodic-size-rotating-file-handler=*:remove)"))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        sizeHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-size-rotating-file-table", metadata99)
            .button(mbuiContext.resources().constants().add(), table -> addSizeHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/size-rotating-file-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeSizeHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/size-rotating-file-handler=*:remove)"))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        asyncHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-async-table", metadata100)
            .button(mbuiContext.resources().constants().add(), table -> addAsyncHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/async-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeAsyncHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/async-handler=*:remove)"))
            .columns("name", "level")
            .build();
        customHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-custom-table", metadata101)
            .button(mbuiContext.resources().constants().add(), table -> addCustomHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/custom-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeCustomHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/custom-handler=*:remove)"))
            .columns("name", "level")
            .build();
        syslogHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-handler-syslog-table", metadata102)
            .button(mbuiContext.resources().constants().add(), table -> addSyslogHandler(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/syslog-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeSyslogHandler(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/syslog-handler=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("level")
            .build();
        customFormatterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-formatter-custom-table", metadata104)
            .button(mbuiContext.resources().constants().add(), table -> addCustomFormatter(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/custom-formatter=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removeCustomFormatter(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/custom-formatter=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        patternFormatterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-profile-formatter-pattern-table", metadata103)
            .button(mbuiContext.resources().constants().add(), table -> addPatternFormatter(), Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/pattern-formatter=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> removePatternFormatter(table), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=logging/logging-profile=*/pattern-formatter=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("pattern")
            .build();

        navigation = new VerticalNavigation();
        Elements.Builder loggingProfileRootLoggerItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1 id=\"logging-profile-root-logger-header\">Root Logger</h1><p id=\"logging-profile-root-logger-description\">{{metadata93.getDescription().getDescription()}}</p>"))
                    .rememberAs("html275")
                .end()
                .add(rootLoggerForm)
            .end();
        Element loggingProfileRootLoggerItemElement = loggingProfileRootLoggerItemBuilder.build();
        handlebarElements.put("html275", loggingProfileRootLoggerItemBuilder.referenceFor("html275"));
        navigation.addPrimary("logging-profile-root-logger-item", "Root Logger", "fa fa-sitemap", loggingProfileRootLoggerItemElement);
        Elements.Builder loggingProfileCategoriesItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Categories</h1><p>{{metadata94.getDescription().getDescription()}}</p>"))
                    .rememberAs("html277")
                .end()
                .add(loggerTable)
                .add(loggerForm)
            .end();
        Element loggingProfileCategoriesItemElement = loggingProfileCategoriesItemBuilder.build();
        handlebarElements.put("html277", loggingProfileCategoriesItemBuilder.referenceFor("html277"));
        navigation.addPrimary("logging-profile-categories-item", "Categories", "pficon pficon-repository", loggingProfileCategoriesItemElement);
        navigation.addPrimary("logging-profile-handler-item", "Handler", "fa fa-cogs");
        Elements.Builder loggingProfileHandlerConsoleItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Console Handler</h1><p>{{metadata95.getDescription().getDescription()}}</p>"))
                    .rememberAs("html280")
                .end()
                .add(consoleHandlerTable)
                .add(consoleHandlerForm)
            .end();
        Element loggingProfileHandlerConsoleItemElement = loggingProfileHandlerConsoleItemBuilder.build();
        handlebarElements.put("html280", loggingProfileHandlerConsoleItemBuilder.referenceFor("html280"));
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-console-item", "Console Handler", loggingProfileHandlerConsoleItemElement);
        Elements.Builder loggingProfileHandlerFileItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>File Handler</h1><p>{{metadata96.getDescription().getDescription()}}</p>"))
                    .rememberAs("html283")
                .end()
                .add(fileHandlerTable)
                .add(fileHandlerForm)
            .end();
        Element loggingProfileHandlerFileItemElement = loggingProfileHandlerFileItemBuilder.build();
        handlebarElements.put("html283", loggingProfileHandlerFileItemBuilder.referenceFor("html283"));
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-file-item", "File Handler", loggingProfileHandlerFileItemElement);
        Elements.Builder loggingProfileHandlerPeriodicRotatingFileItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Periodic Handler</h1><p>{{metadata97.getDescription().getDescription()}}</p>"))
                    .rememberAs("html286")
                .end()
                .add(periodicHandlerTable)
                .add(periodicHandlerForm)
            .end();
        Element loggingProfileHandlerPeriodicRotatingFileItemElement = loggingProfileHandlerPeriodicRotatingFileItemBuilder.build();
        handlebarElements.put("html286", loggingProfileHandlerPeriodicRotatingFileItemBuilder.referenceFor("html286"));
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-periodic-rotating-file-item", "Periodic Handler", loggingProfileHandlerPeriodicRotatingFileItemElement);
        Elements.Builder loggingProfileHandlerPeriodicSizeRotatingFileItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Periodic Size Handler</h1><p>{{metadata98.getDescription().getDescription()}}</p>"))
                    .rememberAs("html289")
                .end()
                .add(periodicSizeHandlerTable)
                .add(periodicSizeHandlerForm)
            .end();
        Element loggingProfileHandlerPeriodicSizeRotatingFileItemElement = loggingProfileHandlerPeriodicSizeRotatingFileItemBuilder.build();
        handlebarElements.put("html289", loggingProfileHandlerPeriodicSizeRotatingFileItemBuilder.referenceFor("html289"));
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-periodic-size-rotating-file-item", "Periodic Size Handler", loggingProfileHandlerPeriodicSizeRotatingFileItemElement);
        Elements.Builder loggingProfileHandlerSizeRotatingFileItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Size Handler</h1><p>{{metadata99.getDescription().getDescription()}}</p>"))
                    .rememberAs("html292")
                .end()
                .add(sizeHandlerTable)
                .add(sizeHandlerForm)
            .end();
        Element loggingProfileHandlerSizeRotatingFileItemElement = loggingProfileHandlerSizeRotatingFileItemBuilder.build();
        handlebarElements.put("html292", loggingProfileHandlerSizeRotatingFileItemBuilder.referenceFor("html292"));
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-size-rotating-file-item", "Size Handler", loggingProfileHandlerSizeRotatingFileItemElement);
        Elements.Builder loggingProfileHandlerAsyncItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Async Handler</h1><p>{{metadata100.getDescription().getDescription()}}</p>"))
                    .rememberAs("html295")
                .end()
                .add(asyncHandlerTable)
                .add(asyncHandlerForm)
            .end();
        Element loggingProfileHandlerAsyncItemElement = loggingProfileHandlerAsyncItemBuilder.build();
        handlebarElements.put("html295", loggingProfileHandlerAsyncItemBuilder.referenceFor("html295"));
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-async-item", "Async Handler", loggingProfileHandlerAsyncItemElement);
        Elements.Builder loggingProfileHandlerCustomItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Handler</h1><p>{{metadata101.getDescription().getDescription()}}</p>"))
                    .rememberAs("html298")
                .end()
                .add(customHandlerTable)
                .add(customHandlerForm)
            .end();
        Element loggingProfileHandlerCustomItemElement = loggingProfileHandlerCustomItemBuilder.build();
        handlebarElements.put("html298", loggingProfileHandlerCustomItemBuilder.referenceFor("html298"));
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-custom-item", "Custom Handler", loggingProfileHandlerCustomItemElement);
        Elements.Builder loggingProfileHandlerSyslogItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Syslog Handler</h1><p>{{metadata102.getDescription().getDescription()}}</p>"))
                    .rememberAs("html301")
                .end()
                .add(syslogHandlerTable)
                .add(syslogHandlerForm)
            .end();
        Element loggingProfileHandlerSyslogItemElement = loggingProfileHandlerSyslogItemBuilder.build();
        handlebarElements.put("html301", loggingProfileHandlerSyslogItemBuilder.referenceFor("html301"));
        navigation.addSecondary("logging-profile-handler-item", "logging-profile-handler-syslog-item", "Syslog Handler", loggingProfileHandlerSyslogItemElement);
        navigation.addPrimary("logging-profile-formatter-item", "Formatter", "fa fa-paint-brush");
        Elements.Builder loggingProfileFormatterPatternItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Pattern Formatter</h1><p>{{metadata103.getDescription().getDescription()}}</p>"))
                    .rememberAs("html304")
                .end()
                .add(patternFormatterTable)
                .add(patternFormatterForm)
            .end();
        Element loggingProfileFormatterPatternItemElement = loggingProfileFormatterPatternItemBuilder.build();
        handlebarElements.put("html304", loggingProfileFormatterPatternItemBuilder.referenceFor("html304"));
        navigation.addSecondary("logging-profile-formatter-item", "logging-profile-formatter-pattern-item", "Pattern Formatter", loggingProfileFormatterPatternItemElement);
        Elements.Builder loggingProfileFormatterCustomItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Formatter</h1><p>{{metadata104.getDescription().getDescription()}}</p>"))
                    .rememberAs("html307")
                .end()
                .add(customFormatterTable)
                .add(customFormatterForm)
            .end();
        Element loggingProfileFormatterCustomItemElement = loggingProfileFormatterCustomItemBuilder.build();
        handlebarElements.put("html307", loggingProfileFormatterCustomItemBuilder.referenceFor("html307"));
        navigation.addSecondary("logging-profile-formatter-item", "logging-profile-formatter-custom-item", "Custom Formatter", loggingProfileFormatterCustomItemElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        registerAttachable(navigation);
        registerAttachable(rootLoggerForm);
        registerAttachable(loggerTable);
        registerAttachable(loggerForm);
        registerAttachable(consoleHandlerTable);
        registerAttachable(consoleHandlerForm);
        registerAttachable(fileHandlerTable);
        registerAttachable(fileHandlerForm);
        registerAttachable(periodicHandlerTable);
        registerAttachable(periodicHandlerForm);
        registerAttachable(periodicSizeHandlerTable);
        registerAttachable(periodicSizeHandlerForm);
        registerAttachable(sizeHandlerTable);
        registerAttachable(sizeHandlerForm);
        registerAttachable(asyncHandlerTable);
        registerAttachable(asyncHandlerForm);
        registerAttachable(customHandlerTable);
        registerAttachable(customHandlerForm);
        registerAttachable(syslogHandlerTable);
        registerAttachable(syslogHandlerForm);
        registerAttachable(customFormatterTable);
        registerAttachable(customFormatterForm);
        registerAttachable(patternFormatterTable);
        registerAttachable(patternFormatterForm);

        Element root = layoutBuilder.build();
        initElement(root);

        init();
    }

    @Override
    org.jboss.hal.core.CrudOperations crud() {
    return crud;
    }

    @Override
    public void attach() {
        super.attach();

            loggerTable.bindForm(loggerForm);
            consoleHandlerTable.bindForm(consoleHandlerForm);
            fileHandlerTable.bindForm(fileHandlerForm);
            periodicHandlerTable.bindForm(periodicHandlerForm);
            periodicSizeHandlerTable.bindForm(periodicSizeHandlerForm);
            sizeHandlerTable.bindForm(sizeHandlerForm);
            asyncHandlerTable.bindForm(asyncHandlerForm);
            customHandlerTable.bindForm(customHandlerForm);
            syslogHandlerTable.bindForm(syslogHandlerForm);
            customFormatterTable.bindForm(customFormatterForm);
            patternFormatterTable.bindForm(patternFormatterForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html275"), "{{metadata93.getDescription().getDescription()}}", String.valueOf(metadata93.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html277"), "{{metadata94.getDescription().getDescription()}}", String.valueOf(metadata94.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html280"), "{{metadata95.getDescription().getDescription()}}", String.valueOf(metadata95.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html283"), "{{metadata96.getDescription().getDescription()}}", String.valueOf(metadata96.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html286"), "{{metadata97.getDescription().getDescription()}}", String.valueOf(metadata97.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html289"), "{{metadata98.getDescription().getDescription()}}", String.valueOf(metadata98.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html292"), "{{metadata99.getDescription().getDescription()}}", String.valueOf(metadata99.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html295"), "{{metadata100.getDescription().getDescription()}}", String.valueOf(metadata100.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html298"), "{{metadata101.getDescription().getDescription()}}", String.valueOf(metadata101.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html301"), "{{metadata102.getDescription().getDescription()}}", String.valueOf(metadata102.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html304"), "{{metadata103.getDescription().getDescription()}}", String.valueOf(metadata103.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html307"), "{{metadata104.getDescription().getDescription()}}", String.valueOf(metadata104.getDescription().getDescription()));
    }
}
