package org.jboss.hal.client.configuration.subsystem.messaging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_ServerView extends ServerView {

    private final Metadata metadata143;
    private final Metadata metadata142;
    private final Metadata metadata144;
    private final Metadata metadata141;
    private final Metadata metadata145;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_ServerView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata143Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/path=bindings-directory");
        this.metadata143 = mbuiContext.metadataRegistry().lookup(metadata143Template);
        AddressTemplate metadata142Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/path=paging-directory");
        this.metadata142 = mbuiContext.metadataRegistry().lookup(metadata142Template);
        AddressTemplate metadata144Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/path=large-messages-directory");
        this.metadata144 = mbuiContext.metadataRegistry().lookup(metadata144Template);
        AddressTemplate metadata141Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*");
        this.metadata141 = mbuiContext.metadataRegistry().lookup(metadata141Template);
        AddressTemplate metadata145Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/path=journal-directory");
        this.metadata145 = mbuiContext.metadataRegistry().lookup(metadata145Template);
        this.handlebarElements = new HashMap<>();

        form = new GroupedForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-server-form", metadata141)
            .attributeGroup("management").end()
            .attributeGroup("security").end()
            .attributeGroup("journal").end()
            .attributeGroup("cluster").end()
            .attributeGroup("message-expiry").end()
            .attributeGroup("transaction").end()
            .attributeGroup("statistics").end()
            .attributeGroup("debug").end()
            .onSave((form, changedValues) -> presenter.saveServer(changedValues))
            .prepareReset(form -> presenter.resetServer(form))
            .build();
        pagingDirectoryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("messaging-server-paging-directory-form", metadata142)
            .singleton(
                () -> new Operation.Builder(metadata142Template.resolve(mbuiContext.statementContext()), READ_RESOURCE_OPERATION).build(),
                () -> addSingleton("messaging-server-paging-directory-form", "Paging Directory", metadata142Template))
            .prepareRemove(form -> removeSingletonForm("Paging Directory", metadata142Template.resolve(mbuiContext.statementContext()), form))
            .onSave((form, changedValues) -> saveSingletonForm("Paging Directory", metadata142Template.resolve(mbuiContext.statementContext()), changedValues, metadata142))
            .build();
        bindingsDirectoryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("messaging-server-bindings-directory-form", metadata143)
            .singleton(
                () -> new Operation.Builder(metadata143Template.resolve(mbuiContext.statementContext()), READ_RESOURCE_OPERATION).build(),
                () -> addSingleton("messaging-server-bindings-directory-form", "Bindings Directory", metadata143Template))
            .prepareRemove(form -> removeSingletonForm("Bindings Directory", metadata143Template.resolve(mbuiContext.statementContext()), form))
            .onSave((form, changedValues) -> saveSingletonForm("Bindings Directory", metadata143Template.resolve(mbuiContext.statementContext()), changedValues, metadata143))
            .build();
        largeMessagesDirectoryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("messaging-server-large-messages-directory-form", metadata144)
            .singleton(
                () -> new Operation.Builder(metadata144Template.resolve(mbuiContext.statementContext()), READ_RESOURCE_OPERATION).build(),
                () -> addSingleton("messaging-server-large-messages-directory-form", "Large Messages Directory", metadata144Template))
            .prepareRemove(form -> removeSingletonForm("Large Messages Directory", metadata144Template.resolve(mbuiContext.statementContext()), form))
            .onSave((form, changedValues) -> saveSingletonForm("Large Messages Directory", metadata144Template.resolve(mbuiContext.statementContext()), changedValues, metadata144))
            .build();
        journalDirectoryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("messaging-server-journal-directory-form", metadata145)
            .singleton(
                () -> new Operation.Builder(metadata145Template.resolve(mbuiContext.statementContext()), READ_RESOURCE_OPERATION).build(),
                () -> addSingleton("messaging-server-journal-directory-form", "Journal Directory", metadata145Template))
            .prepareRemove(form -> removeSingletonForm("Journal Directory", metadata145Template.resolve(mbuiContext.statementContext()), form))
            .onSave((form, changedValues) -> saveSingletonForm("Journal Directory", metadata145Template.resolve(mbuiContext.statementContext()), changedValues, metadata145))
            .build();


        verticalNavigation = new VerticalNavigation();
        Elements.Builder messagingServerEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Messaging Server</h1><p>{{metadata141.getDescription().getDescription()}}</p>"))
                    .rememberAs("html419")
                .end()
                .add(form)
            .end();
        Element messagingServerEntryElement = messagingServerEntryBuilder.build();
        handlebarElements.put("html419", messagingServerEntryBuilder.referenceFor("html419"));
        verticalNavigation.addPrimary("messaging-server-entry", "Configuration", "pficon pficon-settings", messagingServerEntryElement);
        verticalNavigation.addPrimary("messaging-server-directory-entry", "Directories", "pficon pficon-repository");
        Elements.Builder messagingServerPagingDirectoryEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Paging Directory</h1><p>{{metadata142.getDescription().getDescription()}}</p>"))
                    .rememberAs("html421")
                .end()
                .add(pagingDirectoryForm)
            .end();
        Element messagingServerPagingDirectoryEntryElement = messagingServerPagingDirectoryEntryBuilder.build();
        handlebarElements.put("html421", messagingServerPagingDirectoryEntryBuilder.referenceFor("html421"));
        verticalNavigation.addSecondary("messaging-server-directory-entry", "messaging-server-paging-directory-entry", "Paging", messagingServerPagingDirectoryEntryElement);
        Elements.Builder messagingServerBindingsDirectoryEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Bindings Directory</h1><p>{{metadata143.getDescription().getDescription()}}</p>"))
                    .rememberAs("html423")
                .end()
                .add(bindingsDirectoryForm)
            .end();
        Element messagingServerBindingsDirectoryEntryElement = messagingServerBindingsDirectoryEntryBuilder.build();
        handlebarElements.put("html423", messagingServerBindingsDirectoryEntryBuilder.referenceFor("html423"));
        verticalNavigation.addSecondary("messaging-server-directory-entry", "messaging-server-bindings-directory-entry", "Bindings", messagingServerBindingsDirectoryEntryElement);
        Elements.Builder messagingServerLargeMessagesDirectoryEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Large Messages Directory</h1><p>{{metadata144.getDescription().getDescription()}}</p>"))
                    .rememberAs("html425")
                .end()
                .add(largeMessagesDirectoryForm)
            .end();
        Element messagingServerLargeMessagesDirectoryEntryElement = messagingServerLargeMessagesDirectoryEntryBuilder.build();
        handlebarElements.put("html425", messagingServerLargeMessagesDirectoryEntryBuilder.referenceFor("html425"));
        verticalNavigation.addSecondary("messaging-server-directory-entry", "messaging-server-large-messages-directory-entry", "Large Messages", messagingServerLargeMessagesDirectoryEntryElement);
        Elements.Builder messagingServerJournalDirectoryEntryBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Journal Directory</h1><p>{{metadata145.getDescription().getDescription()}}</p>"))
                    .rememberAs("html427")
                .end()
                .add(journalDirectoryForm)
            .end();
        Element messagingServerJournalDirectoryEntryElement = messagingServerJournalDirectoryEntryBuilder.build();
        handlebarElements.put("html427", messagingServerJournalDirectoryEntryBuilder.referenceFor("html427"));
        verticalNavigation.addSecondary("messaging-server-directory-entry", "messaging-server-journal-directory-entry", "Journal", messagingServerJournalDirectoryEntryElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(verticalNavigation.panes())
                .end()
            .end();

        registerAttachable(verticalNavigation);
        registerAttachable(form);
        registerAttachable(pagingDirectoryForm);
        registerAttachable(bindingsDirectoryForm);
        registerAttachable(largeMessagesDirectoryForm);
        registerAttachable(journalDirectoryForm);

        Element root = layoutBuilder.build();
        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();


        TemplateUtil.replaceHandlebar(handlebarElements.get("html419"), "{{metadata141.getDescription().getDescription()}}", String.valueOf(metadata141.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html421"), "{{metadata142.getDescription().getDescription()}}", String.valueOf(metadata142.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html423"), "{{metadata143.getDescription().getDescription()}}", String.valueOf(metadata143.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html425"), "{{metadata144.getDescription().getDescription()}}", String.valueOf(metadata144.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html427"), "{{metadata145.getDescription().getDescription()}}", String.valueOf(metadata145.getDescription().getDescription()));
    }
}
