package org.jboss.hal.client.configuration.subsystem.undertow;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_FilterView extends FilterView {

    private final Metadata metadata176;
    private final Metadata metadata175;
    private final Metadata metadata178;
    private final Metadata metadata174;
    private final Metadata metadata180;
    private final Metadata metadata177;
    private final Metadata metadata181;
    private final Metadata metadata179;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_FilterView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata176Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/expression-filter=*");
        this.metadata176 = mbuiContext.metadataRegistry().lookup(metadata176Template);
        AddressTemplate metadata175Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/error-page=*");
        this.metadata175 = mbuiContext.metadataRegistry().lookup(metadata175Template);
        AddressTemplate metadata178Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/mod-cluster=*");
        this.metadata178 = mbuiContext.metadataRegistry().lookup(metadata178Template);
        AddressTemplate metadata174Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/custom-filter=*");
        this.metadata174 = mbuiContext.metadataRegistry().lookup(metadata174Template);
        AddressTemplate metadata180Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/response-header=*");
        this.metadata180 = mbuiContext.metadataRegistry().lookup(metadata180Template);
        AddressTemplate metadata177Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/gzip=*");
        this.metadata177 = mbuiContext.metadataRegistry().lookup(metadata177Template);
        AddressTemplate metadata181Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/rewrite=*");
        this.metadata181 = mbuiContext.metadataRegistry().lookup(metadata181Template);
        AddressTemplate metadata179Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/request-limit=*");
        this.metadata179 = mbuiContext.metadataRegistry().lookup(metadata179Template);
        this.handlebarElements = new HashMap<>();

        customFilterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-custom-filter-form", metadata174)
            .include("class-name")
            .include("module")
            .include("parameters")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 3)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Custom Filter", name, metadata174Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata174);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Custom Filter", name, metadata174Template.resolve(mbuiContext.statementContext(), name), form, metadata174);
            })
            .build();
        errorPageForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-error-page-form", metadata175)
            .include("code")
            .include("path")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 2)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Error Page", name, metadata175Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata175);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Error Page", name, metadata175Template.resolve(mbuiContext.statementContext(), name), form, metadata175);
            })
            .build();
        expressionFilterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-expression-filter-form", metadata176)
            .include("expression")
            .include("module")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 2)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Expression Filter", name, metadata176Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata176);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Expression Filter", name, metadata176Template.resolve(mbuiContext.statementContext(), name), form, metadata176);
            })
            .build();
        gzipForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-gzip-form", metadata177)
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 0)
            .unsorted()
            .onSave((form, changedValues) -> noop())
            .build();
        modClusterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-mod-cluster-form", metadata178)
            .include("advertise-frequency")
            .include("advertise-path")
            .include("advertise-protocol")
            .include("advertise-socket-binding")
            .include("broken-node-timeout")
            .include("cached-connections-per-thread")
            .include("connection-idle-timeout")
            .include("connections-per-thread")
            .include("enable-http2")
            .include("health-check-interval")
            .include("http2-enable-push")
            .include("http2-header-table-size")
            .include("http2-initial-window-size")
            .include("http2-max-concurrent-streams")
            .include("http2-max-frame-size")
            .include("http2-max-header-list-size")
            .include("management-access-predicate")
            .include("management-socket-binding")
            .include("max-ajp-packet-size")
            .include("max-request-time")
            .include("max-retries")
            .include("request-queue-size")
            .include("security-key")
            .include("security-realm")
            .include("ssl-context")
            .include("use-alias")
            .include("worker")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 27)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Mod Cluster", name, metadata178Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata178);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Mod Cluster", name, metadata178Template.resolve(mbuiContext.statementContext(), name), form, metadata178);
            })
            .build();
        requestLimitForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-request-limit-form", metadata179)
            .include("max-concurrent-requests")
            .include("queue-size")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 2)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Request Limit", name, metadata179Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata179);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Request Limit", name, metadata179Template.resolve(mbuiContext.statementContext(), name), form, metadata179);
            })
            .build();
        responseHeaderForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-response-header-form", metadata180)
            .include("header-name")
            .include("header-value")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 2)
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveResponseHeader(form, changedValues))
            .prepareReset(form -> presenter.resetResponseHeader(form))
            .build();
        rewriteForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-rewrite-form", metadata181)
            .include("redirect")
            .include("target")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 2)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Rewrite", name, metadata181Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata181);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Rewrite", name, metadata181Template.resolve(mbuiContext.statementContext(), name), form, metadata181);
            })
            .build();

        customFilterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-custom-filter-table", metadata174)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-custom-filter-table", Ids.ADD_SUFFIX), "Custom Filter",
                metadata174Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Custom Filter", metadata174Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        errorPageTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-error-page-table", metadata175)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-error-page-table", Ids.ADD_SUFFIX), "Error Page",
                metadata175Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Error Page", metadata175Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("code")
            .build();
        expressionFilterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-expression-filter-table", metadata176)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-expression-filter-table", Ids.ADD_SUFFIX), "Expression Filter",
                metadata176Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Expression Filter", metadata176Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("expression")
            .build();
        gzipTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-gzip-table", metadata177)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-gzip-table", Ids.ADD_SUFFIX), "GZip",
                metadata177Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("GZip", metadata177Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        modClusterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-mod-cluster-table", metadata178)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-mod-cluster-table", Ids.ADD_SUFFIX), "Mod Cluster",
                metadata178Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Mod Cluster", metadata178Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("management-socket-binding")
            .build();
        requestLimitTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-request-limit-table", metadata179)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-request-limit-table", Ids.ADD_SUFFIX), "Request Limit",
                metadata179Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Request Limit", metadata179Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("max-concurrent-requests")
            .build();
        responseHeaderTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-response-header-table", metadata180)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addResponseHeader(), Constraint.parse("executable({selected.profile}/subsystem=undertow/configuration=filter/response-header=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeResponseHeader(table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=undertow/configuration=filter/response-header=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.get("header-name").asString())
            .column("value", (cell, type, row, meta) -> row.get("header-value").asString())
            .build();
        rewriteTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-rewrite-table", metadata181)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-rewrite-table", Ids.ADD_SUFFIX), "Rewrite",
                metadata181Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Rewrite", metadata181Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("target")
            .build();

        navigation = new VerticalNavigation();
        Elements.Builder undertowCustomFilterItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Filter</h1><p>{{metadata174.getDescription().getDescription()}}</p>"))
                    .rememberAs("html517")
                .end()
                .add(customFilterTable)
                .add(customFilterForm)
            .end();
        Element undertowCustomFilterItemElement = undertowCustomFilterItemBuilder.build();
        handlebarElements.put("html517", undertowCustomFilterItemBuilder.referenceFor("html517"));
        navigation.addPrimary("undertow-custom-filter-item", "Custom Filter", "fa fa-file-o", undertowCustomFilterItemElement);
        Elements.Builder undertowErrorPageItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Error Page</h1><p>{{metadata175.getDescription().getDescription()}}</p>"))
                    .rememberAs("html520")
                .end()
                .add(errorPageTable)
                .add(errorPageForm)
            .end();
        Element undertowErrorPageItemElement = undertowErrorPageItemBuilder.build();
        handlebarElements.put("html520", undertowErrorPageItemBuilder.referenceFor("html520"));
        navigation.addPrimary("undertow-error-page-item", "Error Page", "fa fa-bug", undertowErrorPageItemElement);
        Elements.Builder undertowExpressionFilterItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Expression Filter</h1><p>{{metadata176.getDescription().getDescription()}}</p>"))
                    .rememberAs("html523")
                .end()
                .add(expressionFilterTable)
                .add(expressionFilterForm)
            .end();
        Element undertowExpressionFilterItemElement = undertowExpressionFilterItemBuilder.build();
        handlebarElements.put("html523", undertowExpressionFilterItemBuilder.referenceFor("html523"));
        navigation.addPrimary("undertow-expression-filter-item", "Expression Filter", "fa fa-terminal", undertowExpressionFilterItemElement);
        Elements.Builder undertowGzipItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>GZip</h1><p>{{metadata177.getDescription().getDescription()}}</p>"))
                    .rememberAs("html526")
                .end()
                .add(gzipTable)
                .add(gzipForm)
            .end();
        Element undertowGzipItemElement = undertowGzipItemBuilder.build();
        handlebarElements.put("html526", undertowGzipItemBuilder.referenceFor("html526"));
        navigation.addPrimary("undertow-gzip-item", "GZip", "fa fa-archive", undertowGzipItemElement);
        Elements.Builder undertowModClusterItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Mod Cluster</h1><p>{{metadata178.getDescription().getDescription()}}</p>"))
                    .rememberAs("html529")
                .end()
                .add(modClusterTable)
                .add(modClusterForm)
            .end();
        Element undertowModClusterItemElement = undertowModClusterItemBuilder.build();
        handlebarElements.put("html529", undertowModClusterItemBuilder.referenceFor("html529"));
        navigation.addPrimary("undertow-mod-cluster-item", "Mod Cluster Filter", "pficon pficon-cluster", undertowModClusterItemElement);
        Elements.Builder undertowRequestLimitItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Request Limit</h1><p>{{metadata179.getDescription().getDescription()}}</p>"))
                    .rememberAs("html532")
                .end()
                .add(requestLimitTable)
                .add(requestLimitForm)
            .end();
        Element undertowRequestLimitItemElement = undertowRequestLimitItemBuilder.build();
        handlebarElements.put("html532", undertowRequestLimitItemBuilder.referenceFor("html532"));
        navigation.addPrimary("undertow-request-limit-item", "Request Limit", "fa fa-ban", undertowRequestLimitItemElement);
        Elements.Builder undertowResponseHeaderItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Response Header</h1><p>{{metadata180.getDescription().getDescription()}}</p>"))
                    .rememberAs("html535")
                .end()
                .add(responseHeaderTable)
                .add(responseHeaderForm)
            .end();
        Element undertowResponseHeaderItemElement = undertowResponseHeaderItemBuilder.build();
        handlebarElements.put("html535", undertowResponseHeaderItemBuilder.referenceFor("html535"));
        navigation.addPrimary("undertow-response-header-item", "Response Header", "fa fa-exchange", undertowResponseHeaderItemElement);
        Elements.Builder undertowRewriteItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Rewrite</h1><p>{{metadata181.getDescription().getDescription()}}</p>"))
                    .rememberAs("html538")
                .end()
                .add(rewriteTable)
                .add(rewriteForm)
            .end();
        Element undertowRewriteItemElement = undertowRewriteItemBuilder.build();
        handlebarElements.put("html538", undertowRewriteItemBuilder.referenceFor("html538"));
        navigation.addPrimary("undertow-rewrite-item", "Rewrite", "fa fa-refresh", undertowRewriteItemElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        registerAttachable(navigation);
        registerAttachable(customFilterTable);
        registerAttachable(customFilterForm);
        registerAttachable(errorPageTable);
        registerAttachable(errorPageForm);
        registerAttachable(expressionFilterTable);
        registerAttachable(expressionFilterForm);
        registerAttachable(gzipTable);
        registerAttachable(gzipForm);
        registerAttachable(modClusterTable);
        registerAttachable(modClusterForm);
        registerAttachable(requestLimitTable);
        registerAttachable(requestLimitForm);
        registerAttachable(responseHeaderTable);
        registerAttachable(responseHeaderForm);
        registerAttachable(rewriteTable);
        registerAttachable(rewriteForm);

        Element root = layoutBuilder.build();
        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            customFilterTable.bindForm(customFilterForm);
            errorPageTable.bindForm(errorPageForm);
            expressionFilterTable.bindForm(expressionFilterForm);
            modClusterTable.bindForm(modClusterForm);
            requestLimitTable.bindForm(requestLimitForm);
            responseHeaderTable.bindForm(responseHeaderForm);
            rewriteTable.bindForm(rewriteForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html517"), "{{metadata174.getDescription().getDescription()}}", String.valueOf(metadata174.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html520"), "{{metadata175.getDescription().getDescription()}}", String.valueOf(metadata175.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html523"), "{{metadata176.getDescription().getDescription()}}", String.valueOf(metadata176.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html526"), "{{metadata177.getDescription().getDescription()}}", String.valueOf(metadata177.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html529"), "{{metadata178.getDescription().getDescription()}}", String.valueOf(metadata178.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html532"), "{{metadata179.getDescription().getDescription()}}", String.valueOf(metadata179.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html535"), "{{metadata180.getDescription().getDescription()}}", String.valueOf(metadata180.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html538"), "{{metadata181.getDescription().getDescription()}}", String.valueOf(metadata181.getDescription().getDescription()));
    }
}
