package org.jboss.hal.client.runtime.group;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_ServerGroupView extends ServerGroupView {

    private final Metadata metadata187;
    private final Metadata metadata186;
    private final Metadata metadata188;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_ServerGroupView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata187Template = AddressTemplate.of("/{selected.group}/jvm=*");
        this.metadata187 = mbuiContext.metadataRegistry().lookup(metadata187Template);
        AddressTemplate metadata186Template = AddressTemplate.of("/{selected.group}");
        this.metadata186 = mbuiContext.metadataRegistry().lookup(metadata186Template);
        AddressTemplate metadata188Template = AddressTemplate.of("/{selected.group}/system-property=*");
        this.metadata188 = mbuiContext.metadataRegistry().lookup(metadata188Template);
        this.handlebarElements = new HashMap<>();

        serverGroupConfigurationForm = new ModelNodeForm.Builder<org.jboss.hal.core.runtime.group.ServerGroup>("server-group-configuration-form", metadata186)
            .includeRuntime()
            .include("profile", "socket-binding-group", "socket-binding-port-offset", "socket-binding-default-interface", "management-subsystem-endpoint")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Server Group Configuration", metadata186Template.resolve(mbuiContext.statementContext()), changedValues, metadata186))
            .prepareReset(form -> resetSingletonForm("Server Group Configuration", metadata186Template.resolve(mbuiContext.statementContext()), form, metadata186))
            .build();
        serverGroupJvmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-group-jvm-form", metadata187)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Jvm", name, metadata187Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata187);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Jvm", name, metadata187Template.resolve(mbuiContext.statementContext(), name), form, metadata187);
            })
            .build();
        serverGroupSystemPropertyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-group-system-property-form", metadata188)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("System Property", name, metadata188Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata188);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("System Property", name, metadata188Template.resolve(mbuiContext.statementContext(), name), form, metadata188);
            })
            .build();

        serverGroupJvmTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-group-jvm-table", metadata187)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-group-jvm-table", Ids.ADD_SUFFIX), "Jvm",
                metadata187Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Jvm", metadata187Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        serverGroupSystemPropertyTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-group-system-property-table", metadata188)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-group-system-property-table", Ids.ADD_SUFFIX), "System Property",
                metadata188Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("System Property", metadata188Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("value")
            .build();

        navigation = new VerticalNavigation();
        Elements.Builder serverGroupConfigurationItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Server Group Configuration</h1><p>{{metadata186.getDescription().getDescription()}}</p>"))
                    .rememberAs("html554")
                .end()
                .add(serverGroupConfigurationForm)
            .end();
        Element serverGroupConfigurationItemElement = serverGroupConfigurationItemBuilder.build();
        handlebarElements.put("html554", serverGroupConfigurationItemBuilder.referenceFor("html554"));
        navigation.addPrimary("server-group-configuration-item", "Configuration", "pficon pficon-settings", serverGroupConfigurationItemElement);
        Elements.Builder serverGroupJvmItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JVMs</h1><p>{{metadata187.getDescription().getDescription()}}</p>"))
                    .rememberAs("html556")
                .end()
                .add(serverGroupJvmTable)
                .add(serverGroupJvmForm)
            .end();
        Element serverGroupJvmItemElement = serverGroupJvmItemBuilder.build();
        handlebarElements.put("html556", serverGroupJvmItemBuilder.referenceFor("html556"));
        navigation.addPrimary("server-group-jvm-item", "JVMs", "fa fa-coffee", serverGroupJvmItemElement);
        Elements.Builder serverGroupSystemPropertyItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>System Properties</h1><p>{{metadata188.getDescription().getDescription()}}</p>"))
                    .rememberAs("html559")
                .end()
                .add(serverGroupSystemPropertyTable)
                .add(serverGroupSystemPropertyForm)
            .end();
        Element serverGroupSystemPropertyItemElement = serverGroupSystemPropertyItemBuilder.build();
        handlebarElements.put("html559", serverGroupSystemPropertyItemBuilder.referenceFor("html559"));
        navigation.addPrimary("server-group-system-property-item", "System Properties", "fa fa-list-ul", serverGroupSystemPropertyItemElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        registerAttachable(navigation);
        registerAttachable(serverGroupConfigurationForm);
        registerAttachable(serverGroupJvmTable);
        registerAttachable(serverGroupJvmForm);
        registerAttachable(serverGroupSystemPropertyTable);
        registerAttachable(serverGroupSystemPropertyForm);

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            serverGroupJvmTable.bindForm(serverGroupJvmForm);
            serverGroupSystemPropertyTable.bindForm(serverGroupSystemPropertyForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html554"), "{{metadata186.getDescription().getDescription()}}", String.valueOf(metadata186.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html556"), "{{metadata187.getDescription().getDescription()}}", String.valueOf(metadata187.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html559"), "{{metadata188.getDescription().getDescription()}}", String.valueOf(metadata188.getDescription().getDescription()));
    }
}
