package org.jboss.hal.client.configuration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_SystemPropertiesView extends SystemPropertiesView {

    private final Metadata metadata185;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_SystemPropertiesView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata185Template = AddressTemplate.of("/system-property=*");
        this.metadata185 = mbuiContext.metadataRegistry().lookup(metadata185Template);
        this.handlebarElements = new HashMap<>();

        systemPropertyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("system-property-form", metadata185)
            .include("value", "boot-time")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("System Property", name, metadata185Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata185);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("System Property", name, metadata185Template.resolve(mbuiContext.statementContext(), name), form, metadata185);
            })
            .build();

        systemPropertyTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("system-property-table", metadata185)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(), Constraint.parse("executable(system-property=*:add)"))
            .button(mbuiContext.tableButtonFactory().remove("System Property", metadata185Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("value")
            .column("boot-time")
            .build();

        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .div()
                        .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>System Properties</h1><p>{{metadata185.getDescription().getDescription()}}</p>"))
                        .rememberAs("html551")
                    .end()
                    .add(systemPropertyTable)
                    .add(systemPropertyForm)
                .end()
            .end();
            handlebarElements.put("html551", layoutBuilder.referenceFor("html551"));

        registerAttachable(systemPropertyTable);
        registerAttachable(systemPropertyForm);

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            systemPropertyTable.bindForm(systemPropertyForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html551"), "{{metadata185.getDescription().getDescription()}}", String.valueOf(metadata185.getDescription().getDescription()));
    }
}
