package org.jboss.hal.client.configuration.subsystem.io;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental.dom.Element;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.core.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
final class Mbui_IOView extends IOView {

    private final Metadata metadata90;
    private final Metadata metadata91;
    private final Map<String, Element> handlebarElements;

    @SuppressWarnings("unchecked")
    Mbui_IOView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata90Template = AddressTemplate.of("/{selected.profile}/subsystem=io/worker=*");
        this.metadata90 = mbuiContext.metadataRegistry().lookup(metadata90Template);
        AddressTemplate metadata91Template = AddressTemplate.of("/{selected.profile}/subsystem=io/buffer-pool=*");
        this.metadata91 = mbuiContext.metadataRegistry().lookup(metadata91Template);
        this.handlebarElements = new HashMap<>();

        bufferPoolForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("io-buffer-pool-form", metadata91)
            .include("buffer-size", "buffers-per-slice", "direct-buffers")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Buffer Pool", name, metadata91Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata91);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Buffer Pool", name, metadata91Template.resolve(mbuiContext.statementContext(), name), form, metadata91);
            })
            .build();
        workerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("io-worker-form", metadata90)
            .include("io-threads", "stack-size", "task-keepalive", "task-max-threads")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Worker", name, metadata90Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata90);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Worker", name, metadata90Template.resolve(mbuiContext.statementContext(), name), form, metadata90);
            })
            .build();

        bufferPoolTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("io-buffer-pool-table", metadata91)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("io-buffer-pool-table", Ids.ADD_SUFFIX), "Buffer Pool",
                metadata91Template, asList("buffer-size", "buffers-per-slice", "direct-buffers"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Buffer Pool", metadata91Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        workerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("io-worker-table", metadata90)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("io-worker-table", Ids.ADD_SUFFIX), "Worker",
                metadata90Template, asList("io-threads", "stack-size", "task-keepalive", "task-max-threads"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Worker", metadata90Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        Elements.Builder ioWorkerItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Worker</h1><p>{{metadata90.getDescription().getDescription()}}</p>"))
                    .rememberAs("html266")
                .end()
                .add(workerTable)
                .add(workerForm)
            .end();
        Element ioWorkerItemElement = ioWorkerItemBuilder.build();
        handlebarElements.put("html266", ioWorkerItemBuilder.referenceFor("html266"));
        navigation.addPrimary("io-worker-item", "Worker", "fa fa-cogs", ioWorkerItemElement);
        Elements.Builder ioBufferPoolItemBuilder = new Elements.Builder()
            .section()
                .div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Buffer Pool</h1><p>{{metadata91.getDescription().getDescription()}}</p>"))
                    .rememberAs("html269")
                .end()
                .add(bufferPoolTable)
                .add(bufferPoolForm)
            .end();
        Element ioBufferPoolItemElement = ioBufferPoolItemBuilder.build();
        handlebarElements.put("html269", ioBufferPoolItemBuilder.referenceFor("html269"));
        navigation.addPrimary("io-buffer-pool-item", "Buffer Pool", "pficon pficon-repository", ioBufferPoolItemElement);
        LayoutBuilder layoutBuilder = new LayoutBuilder()
            .row()
                .column()
                    .addAll(navigation.panes())
                .end()
            .end();

        registerAttachable(navigation);
        registerAttachable(bufferPoolTable);
        registerAttachable(bufferPoolForm);
        registerAttachable(workerTable);
        registerAttachable(workerForm);

        Element root = layoutBuilder.build();
        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            bufferPoolTable.bindForm(bufferPoolForm);
            workerTable.bindForm(workerForm);

        TemplateUtil.replaceHandlebar(handlebarElements.get("html266"), "{{metadata90.getDescription().getDescription()}}", String.valueOf(metadata90.getDescription().getDescription()));
        TemplateUtil.replaceHandlebar(handlebarElements.get("html269"), "{{metadata91.getDescription().getDescription()}}", String.valueOf(metadata91.getDescription().getDescription()));
    }
}
